/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.ui.graph;

import java.util.HashMap;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;

public class GraphBuilder {
    private HashMap<String, GraphNode> fNodeCache = new HashMap();
    private final Graph graph;

    public GraphBuilder(Graph graph) {
        this.graph = graph;
    }

    public void computeGraph(IValue fact) {
        if (GraphBuilder.canShow(fact.getType())) {
            this.convertBinaryRelToGraph((IRelation)fact);
        }
    }

    public static boolean canShow(Type type) {
        return type.isRelationType() && type.getArity() == 2;
    }

    private void convertBinaryRelToGraph(IRelation rel) {
        this.fNodeCache.clear();
        for (IValue value : rel) {
            ITuple tuple = (ITuple)value;
            GraphNode from = this.getOrCreateNode(tuple.get(0));
            GraphNode to = this.getOrCreateNode(tuple.get(1));
            if (from == null || to == null) continue;
            new GraphConnection(this.graph, 0, from, to);
        }
    }

    private GraphNode getOrCreateNode(IValue value) {
        GraphNode node;
        String nodeName = this.getNodeName(value);
        if (nodeName.length() == 0) {
            return null;
        }
        if (this.fNodeCache.containsKey(nodeName)) {
            node = this.fNodeCache.get(nodeName);
        } else {
            node = new GraphNode((IContainer)this.graph, 0, nodeName);
            this.fNodeCache.put(nodeName, node);
        }
        return node;
    }

    private String getNodeName(IValue value) {
        return value.toString();
    }
}

