/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.tools;

import com.ibm.wala.annotations.NonNull;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.info.LocalAllocator;
import java.util.Arrays;
import java.util.BitSet;

public final class MethodOptimizer {
    private final MethodData data;
    private Instruction[] instructions;
    private ExceptionHandler[][] handlers;
    @NonNull
    private final MethodEditor editor;
    private int[][] uniqueStackDefLocations;
    private int[] uniqueStackUseLocations;
    private int[] stackSizes;
    private int[][] backEdges;
    static final int[] noEdges = new int[0];

    public MethodOptimizer(MethodData d, MethodEditor e) {
        this.data = d;
        this.editor = e;
    }

    public MethodOptimizer(MethodData d) {
        this(d, new MethodEditor(d));
    }

    public int findUniqueStackDef(int instr, int stack) throws UnoptimizableCodeException {
        this.instructions = this.editor.getInstructions();
        this.handlers = this.editor.getHandlers();
        this.checkConsistentStackSizes();
        this.buildBackEdges();
        this.buildStackDefMap();
        return this.uniqueStackDefLocations[instr][stack];
    }

    public void optimize() throws UnoptimizableCodeException {
        boolean changed;
        do {
            this.instructions = this.editor.getInstructions();
            this.handlers = this.editor.getHandlers();
            this.checkConsistentStackSizes();
            this.buildBackEdges();
            this.editor.beginPass();
            this.buildStackDefMap();
            this.pushBackLocalStores();
            this.forwardDups();
            changed = this.editor.applyPatches();
            this.editor.endPass();
        } while (changed);
    }

    private void buildBackEdges() {
        int j;
        ExceptionHandler[] hs;
        int[] targets;
        int i;
        int[] backEdgeCount = new int[this.instructions.length];
        for (i = 0; i < this.instructions.length; ++i) {
            targets = this.instructions[i].getBranchTargets();
            for (int j2 = 0; j2 < targets.length; ++j2) {
                int n = targets[j2];
                backEdgeCount[n] = backEdgeCount[n] + 1;
            }
            hs = this.handlers[i];
            for (j = 0; j < hs.length; ++j) {
                int n = hs[j].getHandler();
                backEdgeCount[n] = backEdgeCount[n] + 1;
            }
        }
        this.backEdges = new int[this.instructions.length][];
        for (i = 0; i < this.backEdges.length; ++i) {
            this.backEdges[i] = backEdgeCount[i] > 0 ? new int[backEdgeCount[i]] : noEdges;
        }
        Arrays.fill(backEdgeCount, 0);
        for (i = 0; i < this.instructions.length; ++i) {
            targets = this.instructions[i].getBranchTargets();
            for (int j3 = 0; j3 < targets.length; ++j3) {
                int target = targets[j3];
                this.backEdges[target][backEdgeCount[target]] = i;
                int n = target;
                backEdgeCount[n] = backEdgeCount[n] + 1;
            }
            hs = this.handlers[i];
            for (j = 0; j < hs.length; ++j) {
                int target = hs[j].getHandler();
                this.backEdges[target][backEdgeCount[target]] = i;
                int n = target;
                backEdgeCount[n] = backEdgeCount[n] + 1;
            }
        }
    }

    private int checkConsistentStackSizes() throws UnoptimizableCodeException {
        this.stackSizes = new int[this.instructions.length];
        Arrays.fill(this.stackSizes, -1);
        this.checkStackSizesAt(0, 0);
        int result = 0;
        for (int i = 0; i < this.stackSizes.length; ++i) {
            result = Math.max(result, this.stackSizes[i]);
        }
        return result;
    }

    private void checkStackSizesAt(int instruction, int stackSize) throws UnoptimizableCodeException {
        while (true) {
            if (instruction < 0 || instruction >= this.instructions.length) {
                throw new UnoptimizableCodeException("Code exits in an illegal way");
            }
            if (this.stackSizes[instruction] != -1) {
                if (this.stackSizes[instruction] != stackSize) {
                    throw new UnoptimizableCodeException("Mismatched stack sizes at " + instruction + ": " + stackSize + " and " + this.stackSizes[instruction]);
                }
                return;
            }
            this.stackSizes[instruction] = stackSize;
            Instruction instr = this.instructions[instruction];
            if ((stackSize -= instr.getPoppedCount()) < 0) {
                throw new UnoptimizableCodeException("Stack underflow at " + instruction);
            }
            if (instr instanceof DupInstruction) {
                DupInstruction d = (DupInstruction)instr;
                stackSize += d.getSize() + d.getPoppedCount();
            } else if (instr.getPushedType(null) != null) {
                ++stackSize;
            }
            int[] targets = instr.getBranchTargets();
            for (int i = 0; i < targets.length; ++i) {
                this.checkStackSizesAt(targets[i], stackSize);
            }
            ExceptionHandler[] hs = this.handlers[instruction];
            for (int i = 0; i < hs.length; ++i) {
                this.checkStackSizesAt(hs[i].getHandler(), 1);
            }
            if (!instr.isFallThrough()) {
                return;
            }
            ++instruction;
        }
    }

    private static boolean instructionKillsVar(Instruction instr, int v) {
        if (instr instanceof StoreInstruction) {
            StoreInstruction st = (StoreInstruction)instr;
            return st.getVarIndex() == v || Util.getWordSize(st.getType()) == 2 && st.getVarIndex() + 1 == v;
        }
        return false;
    }

    private void forwardDups() {
        for (int i = 0; i < this.instructions.length; ++i) {
            Instruction instr = this.instructions[i];
            if (!(instr instanceof DupInstruction) || ((DupInstruction)instr).getDelta() != 0 || this.uniqueStackDefLocations[i][0] < 0 || !(this.instructions[this.uniqueStackDefLocations[i][0]] instanceof LoadInstruction)) continue;
            int source = this.uniqueStackDefLocations[i][0];
            final LoadInstruction li = (LoadInstruction)this.instructions[source];
            for (int j = 0; j < this.instructions.length; ++j) {
                int[] locs = this.uniqueStackDefLocations[j];
                if (locs[0] != i) continue;
                BitSet path = this.getInstructionsOnPath(source, j);
                boolean killed = false;
                int v = li.getVarIndex();
                int k = 0;
                while (j < this.instructions.length && !killed) {
                    if (path.get(k) && MethodOptimizer.instructionKillsVar(this.instructions[k], v)) {
                        killed = true;
                    }
                    ++k;
                }
                if (killed) continue;
                this.editor.insertBefore(j, new MethodEditor.Patch(){

                    public void emitTo(MethodEditor.Output w) {
                        w.emit(PopInstruction.make(1));
                        w.emit(li);
                    }
                });
            }
        }
    }

    private void pushBackLocalStores() {
        for (int i = 0; i < this.instructions.length; ++i) {
            Instruction instr = this.instructions[i];
            if (!(instr instanceof StoreInstruction) || this.uniqueStackDefLocations[i][0] < 0 || this.uniqueStackDefLocations[i][0] == i - 1 || this.uniqueStackUseLocations[this.uniqueStackDefLocations[i][0]] != i) continue;
            final StoreInstruction s = (StoreInstruction)instr;
            int source = this.uniqueStackDefLocations[i][0];
            BitSet path = this.getInstructionsOnPath(source, i);
            boolean killed = false;
            int v = s.getVarIndex();
            for (int j = 0; j < this.instructions.length && !killed; ++j) {
                if (!path.get(j) || !MethodOptimizer.instructionKillsVar(this.instructions[j], v)) continue;
                killed = true;
            }
            if (killed) {
                final String type = s.getType();
                final int newVar = LocalAllocator.allocate(this.data, type);
                this.editor.insertAfter(source, new MethodEditor.Patch(){

                    public void emitTo(MethodEditor.Output w) {
                        w.emit(StoreInstruction.make(type, newVar));
                    }
                });
                this.editor.insertBefore(i, new MethodEditor.Patch(){

                    public void emitTo(MethodEditor.Output w) {
                        w.emit(LoadInstruction.make(type, newVar));
                    }
                });
                continue;
            }
            this.editor.replaceWith(i, new MethodEditor.Patch(){

                public void emitTo(MethodEditor.Output w) {
                }
            });
            this.editor.insertAfter(source, new MethodEditor.Patch(){

                public void emitTo(MethodEditor.Output w) {
                    w.emit(s);
                }
            });
        }
    }

    private void buildStackDefMap() {
        int j;
        int i;
        int[][] abstractStacks = new int[this.instructions.length][];
        for (i = 0; i < this.instructions.length; ++i) {
            abstractStacks[i] = new int[this.stackSizes[i]];
            Arrays.fill(abstractStacks[i], -2);
        }
        for (i = 0; i < this.instructions.length; ++i) {
            if (this.instructions[i] instanceof DupInstruction) {
                DupInstruction d = (DupInstruction)this.instructions[i];
                for (j = 0; j < 2 * d.getSize() + d.getDelta(); ++j) {
                    this.followStackDef(abstractStacks, i, i + 1, this.stackSizes[i + 1] - 1 - j);
                }
                continue;
            }
            if (this.instructions[i].getPushedType(null) == null) continue;
            this.followStackDef(abstractStacks, i, i + 1, this.stackSizes[i + 1] - 1);
        }
        this.uniqueStackDefLocations = new int[this.instructions.length][];
        for (i = 0; i < this.instructions.length; ++i) {
            this.uniqueStackDefLocations[i] = new int[this.instructions[i].getPoppedCount()];
            int popped = this.instructions[i].getPoppedCount();
            System.arraycopy(abstractStacks[i], this.stackSizes[i] - popped, this.uniqueStackDefLocations[i], 0, popped);
        }
        this.uniqueStackUseLocations = new int[this.instructions.length];
        Arrays.fill(this.uniqueStackUseLocations, -2);
        for (i = 0; i < this.instructions.length; ++i) {
            abstractStacks[i] = new int[this.stackSizes[i]];
            Arrays.fill(abstractStacks[i], -2);
        }
        for (i = 0; i < this.instructions.length; ++i) {
            int count = this.instructions[i].getPoppedCount();
            if (count == 1) {
                this.followStackUse(abstractStacks, i, i, this.stackSizes[i] - 1);
                continue;
            }
            if (count <= 1) continue;
            for (j = 0; j < count; ++j) {
                this.followStackUse(abstractStacks, -1, i, this.stackSizes[i] - 1 - j);
            }
        }
        for (i = 0; i < this.instructions.length; ++i) {
            if (this.instructions[i].getPushedType(null) == null) continue;
            this.uniqueStackUseLocations[i] = abstractStacks[i + 1][this.stackSizes[i + 1] - 1];
        }
    }

    private void followStackDef(int[][] abstractDefStacks, int def, int instruction, int stackPointer) {
        int[] stack;
        while (stackPointer < (stack = abstractDefStacks[instruction]).length) {
            if (stack[stackPointer] == -2) {
                stack[stackPointer] = def;
            } else {
                if (stack[stackPointer] == def) {
                    return;
                }
                if (stack[stackPointer] == -1) {
                    return;
                }
                stack[stackPointer] = -1;
                def = -1;
            }
            int[] targets = this.instructions[instruction].getBranchTargets();
            for (int i = 0; i < targets.length; ++i) {
                this.followStackDef(abstractDefStacks, def, targets[i], stackPointer);
            }
            ExceptionHandler[] hs = this.handlers[instruction];
            for (int i = 0; i < hs.length; ++i) {
                this.followStackDef(abstractDefStacks, -1, hs[i].getHandler(), 0);
            }
            if (!this.instructions[instruction].isFallThrough()) {
                return;
            }
            ++instruction;
        }
        return;
    }

    private void followStackUse(int[][] abstractUseStacks, int use, int instruction, int stackPointer) {
        int[] stack;
        while (stackPointer < (stack = abstractUseStacks[instruction]).length) {
            if (stack[stackPointer] == -2) {
                stack[stackPointer] = use;
            } else {
                if (stack[stackPointer] == use || stack[stackPointer] == -1) {
                    return;
                }
                stack[stackPointer] = -1;
                use = -1;
            }
            int[] back = this.backEdges[instruction];
            for (int i = 0; i < back.length; ++i) {
                this.followStackUse(abstractUseStacks, use, back[i], stackPointer);
            }
            if (instruction == 0 || !this.instructions[instruction - 1].isFallThrough()) {
                return;
            }
            --instruction;
        }
        return;
    }

    private BitSet getInstructionsOnPath(int from, int to) {
        BitSet reachable = new BitSet();
        this.getReachableInstructions(reachable, from, to);
        BitSet reaching = new BitSet();
        this.getReachingInstructions(reaching, from, to);
        reachable.and(reaching);
        return reachable;
    }

    private void getReachableInstructions(BitSet bits, int from, int to) {
        while (from != to) {
            bits.set(from);
            int[] targets = this.instructions[from].getBranchTargets();
            for (int i = 0; i < targets.length; ++i) {
                this.getReachableInstructions(bits, targets[i], to);
            }
            if (!this.instructions[from].isFallThrough()) {
                return;
            }
            ++from;
        }
        return;
    }

    private void getReachingInstructions(BitSet bits, int from, int to) {
        while (to != from) {
            bits.set(to);
            int[] targets = this.backEdges[to];
            for (int i = 0; i < targets.length; ++i) {
                this.getReachingInstructions(bits, from, targets[i]);
            }
            if (to == 0 || !this.instructions[to - 1].isFallThrough()) {
                return;
            }
            --to;
        }
        return;
    }

    public static class UnoptimizableCodeException
    extends Exception {
        private static final long serialVersionUID = 2543170335674010642L;

        public UnoptimizableCodeException(String s) {
            super(s);
        }
    }
}

