/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.spec;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.imp.box.builders.BoxFactory;
import org.eclipse.imp.box.parser.Ast.IBox;
import org.eclipse.imp.box.parser.BoxParseController;
import org.eclipse.imp.formatting.spec.ExtensionPointBinder;
import org.eclipse.imp.formatting.spec.ParseException;
import org.eclipse.imp.formatting.spec.Rule;
import org.eclipse.imp.formatting.spec.Separator;
import org.eclipse.imp.formatting.spec.Specification;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler {
    protected static SAXParserFactory spf = SAXParserFactory.newInstance();
    protected Specification spec;
    protected Rule tmpRule;
    protected String tmpContents;
    private ISourceProject project;
    private IPath path;
    private IParseController objectParser;
    private Language objectLanguage;
    private IParseController boxParser;
    private IProgressMonitor boxParserMonitor;
    private IProgressMonitor objectParserMonitor;
    private IMessageHandler handler;
    private Separator tmpSeparator;
    private boolean noObjectParsing;

    public Parser(IPath path, ISourceProject project, IMessageHandler handler) throws ModelFactory.ModelException {
        this.path = path;
        this.spec = new Specification(this);
        this.project = project;
        this.handler = handler;
        this.noObjectParsing = false;
    }

    public void setMessageHandler(IMessageHandler handler) {
        this.handler = handler;
    }

    public Specification parse(IPath path) throws ParseException, FileNotFoundException {
        this.path = path;
        this.noObjectParsing = false;
        return this.parse(new InputSource(new FileReader(path.toOSString())));
    }

    public Specification parse(String inputString) throws ParseException {
        this.noObjectParsing = false;
        return this.parse(new InputSource(new StringReader(inputString)));
    }

    public Specification load(String inputString) throws ParseException {
        this.noObjectParsing = true;
        return this.parse(new InputSource(new StringReader(inputString)));
    }

    private Specification parse(InputSource input) throws ParseException {
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(input, (DefaultHandler)this);
            if (this.spec == null) {
                throw new ParseException("Parsing of " + input + "failed miserably");
            }
            return this.spec;
        }
        catch (SAXException se) {
            throw new ParseException("Parsing of " + input + " failed because XML was invalid", se);
        }
        catch (ParserConfigurationException pce) {
            throw new ParseException("Parsing of " + input + " failed because XML configuration is wrong", pce);
        }
        catch (IOException ie) {
            throw new ParseException("Parsing of " + input + " failed because of an input error", ie);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("rule")) {
            this.tmpRule = new Rule();
        } else if (qName.equals("box")) {
            this.tmpContents = "";
        } else if (qName.equals("preview")) {
            this.tmpContents = "";
        } else if (qName.equals("example")) {
            this.tmpContents = "";
        } else if (qName.equals("language")) {
            this.tmpContents = "";
        } else if (qName.equals("separator")) {
            this.tmpSeparator = new Separator();
            this.tmpContents = "";
        } else if (qName.equals("space-option")) {
            String name = attributes.getValue("name");
            Integer value = Integer.parseInt(attributes.getValue("value"));
            this.spec.setSpaceOption(name, value);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("rule")) {
            this.spec.addRule(this.tmpRule);
        } else if (qName.equals("box")) {
            if (this.tmpRule != null) {
                if (this.noObjectParsing) {
                    this.tmpRule.setBoxString(this.tmpContents);
                } else {
                    try {
                        this.parseBoxAndObject(this.tmpContents, this.tmpRule);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (qName.equals("preview")) {
            if (this.tmpRule != null) {
                this.tmpRule.setPatternString(this.tmpContents);
            }
        } else if (qName.equals("example")) {
            this.spec.setExample(this.tmpContents);
            this.spec.setExampleAst(this.parseObject(this.tmpContents));
        } else if (qName.equals("language")) {
            this.spec.setLanguage(this.tmpContents);
            this.setLanguage(this.tmpContents);
        } else if (qName.equals("separator")) {
            this.tmpSeparator.setLabel(this.tmpContents);
            this.spec.addSeparator(this.tmpSeparator);
        }
    }

    public void setLanguage(String langName) {
        if (this.objectParser == null) {
            try {
                this.objectLanguage = LanguageRegistry.findLanguage((String)langName);
                ExtensionPointBinder b = new ExtensionPointBinder(this.objectLanguage);
                this.objectParser = b.getObjectParser();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void parseBoxAndObject(String boxString, Rule rule) throws ParseException {
        rule.setBoxString(boxString);
        rule.setBoxAst(this.parseBox(boxString));
        if (rule.getBoxAst() != null) {
            rule.setPatternString(BoxFactory.extractText((IBox)rule.getBoxAst()));
            rule.setPatternAst(this.parseObject(rule.getPatternString()));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tmpContents = this.tmpContents + new String(ch, start, length);
    }

    public IBox parseBox(String boxString) {
        this.initializeBoxParser();
        return (IBox)this.boxParser.parse(boxString, false, this.boxParserMonitor);
    }

    private void initializeBoxParser() {
        if (this.boxParser == null) {
            this.boxParser = new BoxParseController();
            this.boxParserMonitor = new NullProgressMonitor();
        }
        this.boxParser.initialize(this.path, this.project, this.handler);
    }

    public Object parseObject(String objectString) {
        this.initializeObjectParser(this.objectParser);
        return this.objectParser.parse(objectString, false, this.objectParserMonitor);
    }

    private void initializeObjectParser(IParseController parseController) {
        if (this.objectParserMonitor == null) {
            this.objectParserMonitor = new NullProgressMonitor();
        }
        parseController.initialize(this.path, this.project, this.handler);
    }
}

