/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.editor.IRegionSelectionService;
import org.eclipse.imp.editor.TargetLink;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.services.IReferenceResolver;
import org.eclipse.imp.services.ISourceHyperlinkDetector;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class HyperlinkDetector
implements ISourceHyperlinkDetector,
ILanguageService {
    private IReferenceResolver fResolver;
    private final Language fLanguage;

    public HyperlinkDetector(Language lang) {
        this.fLanguage = lang;
    }

    public IHyperlink[] detectHyperlinks(IRegion region, ITextEditor editor, ITextViewer textViewer, IParseController parseController) {
        Object targetArg;
        boolean isSamePath;
        if (this.fResolver == null) {
            this.fResolver = ServiceFactory.getInstance().getReferenceResolver(this.fLanguage);
        }
        if (this.fResolver == null) {
            return null;
        }
        if (parseController == null) {
            return null;
        }
        Object ast = parseController.getCurrentAst();
        if (ast == null) {
            return null;
        }
        int offset = region.getOffset();
        ISourcePositionLocator nodeLocator = parseController.getNodeLocator();
        Object source = nodeLocator.findNode(ast, offset);
        if (source == null) {
            return null;
        }
        Object target = this.fResolver.getLinkTarget(source, parseController);
        if (target == null) {
            return null;
        }
        int srcStart = nodeLocator.getStartOffset(source);
        int srcLength = nodeLocator.getEndOffset(source) - srcStart + 1;
        int targetStart = nodeLocator.getStartOffset(target) < 0 ? 0 : nodeLocator.getStartOffset(target);
        int targetLength = nodeLocator.getEndOffset(target) - targetStart + 1;
        IPath targetPath = nodeLocator.getPath(target);
        if (targetPath == null) {
            return null;
        }
        String linkText = this.fResolver.getLinkText(source);
        IPath srcPath = ((IFileEditorInput)editor.getEditorInput()).getFile().getLocation();
        IPath wsPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        boolean bl = isSamePath = targetPath.equals(srcPath) || srcPath.removeFirstSegments(wsPath.segmentCount()).setDevice(null).equals(targetPath);
        if (!isSamePath && targetPath.segmentCount() == 0) {
            isSamePath = nodeLocator.getStartOffset(target) >= 0;
        }
        ITextEditor targetEditor = targetPath.segmentCount() == 0 || isSamePath ? editor : null;
        Object object = targetArg = targetEditor == null ? targetPath : target;
        if (srcStart == targetStart && srcLength == targetLength && targetPath.equals(srcPath)) {
            return null;
        }
        IRegionSelectionService selService = isSamePath ? (IRegionSelectionService)editor.getAdapter(IRegionSelectionService.class) : null;
        IHyperlink[] result = new IHyperlink[]{new TargetLink(linkText, srcStart, srcLength, targetArg, targetStart, targetLength, selService)};
        return result;
    }
}

