/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.editor.IRegionSelectionService;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.editor.OutlineContentProviderBase;
import org.eclipse.imp.editor.OutlineLabelProvider;
import org.eclipse.imp.editor.internal.TreeDiffer;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class IMPOutlinePage
extends ContentOutlinePage
implements IModelListener {
    private final OutlineContentProviderBase fContentProvider;
    private final TreeModelBuilderBase fModelBuilder;
    private final ILabelProvider fLabelProvider;
    private final OutlineLabelProvider.IElementImageProvider fImageProvider;
    private final IParseController fParseController;
    private final IRegionSelectionService regionSelector;

    public IMPOutlinePage(IParseController parseController, TreeModelBuilderBase modelBuilder, ILabelProvider labelProvider, OutlineLabelProvider.IElementImageProvider imageProvider, IRegionSelectionService regionSelector) {
        this.fParseController = parseController;
        this.fModelBuilder = modelBuilder;
        this.fLabelProvider = labelProvider;
        this.fImageProvider = imageProvider;
        this.regionSelector = regionSelector != null ? regionSelector : new IRegionSelectionService(){

            public void selectAndReveal(int startOffset, int length) {
                IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                ITextEditor textEditor = (ITextEditor)activeEditor;
                textEditor.selectAndReveal(startOffset, length);
            }
        };
        this.fContentProvider = new OutlineContentProviderBase(null){
            private ModelTreeNode fOldTree;
            {
                this.fOldTree = null;
            }

            public Object[] getChildren(Object element) {
                ModelTreeNode node = (ModelTreeNode)element;
                return node.getChildren();
            }

            public Object getParent(Object element) {
                ModelTreeNode node = (ModelTreeNode)element;
                return node.getParent();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                super.inputChanged(viewer, oldInput, newInput);
                if (this.fOldTree != null) {
                    TreeDiffer treeDiffer = new TreeDiffer((TreeViewer)viewer, IMPOutlinePage.this.fLabelProvider);
                    treeDiffer.diff((ModelTreeNode)oldInput, (ModelTreeNode)newInput);
                }
                this.fOldTree = (ModelTreeNode)newInput;
            }
        };
    }

    public IModelListener.AnalysisRequired getAnalysisRequired() {
        return IModelListener.AnalysisRequired.SYNTACTIC_ANALYSIS;
    }

    public void update(IParseController parseController, IProgressMonitor monitor) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IMPOutlinePage.this.getTreeViewer().setInput((Object)IMPOutlinePage.this.fModelBuilder.buildTree(IMPOutlinePage.this.fParseController.getCurrentAst()));
                }
            });
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ITreeSelection sel = (ITreeSelection)event.getSelection();
        if (sel.isEmpty()) {
            return;
        }
        ModelTreeNode first = (ModelTreeNode)sel.getFirstElement();
        ISourcePositionLocator locator = this.fParseController.getNodeLocator();
        Object node = first.getASTNode();
        int startOffset = locator.getStartOffset(node);
        int endOffset = locator.getEndOffset(node);
        int length = endOffset - startOffset + 1;
        this.regionSelector.selectAndReveal(startOffset, length);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        if (this.fLabelProvider != null) {
            viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        }
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        ModelTreeNode rootNode = this.fModelBuilder.buildTree(this.fParseController.getCurrentAst());
        viewer.setInput((Object)rootNode);
        viewer.setAutoExpandLevel(2);
        IPageSite site = this.getSite();
        IActionBars actionBars = site.getActionBars();
        this.registerToolbarActions(actionBars);
    }

    private void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)new LexicalSortingAction());
    }

    class LexicalSortingAction
    extends Action {
        private ViewerComparator fElementComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int cat2;
                ModelTreeNode t1 = (ModelTreeNode)e1;
                ModelTreeNode t2 = (ModelTreeNode)e2;
                int cat1 = t1.getCategory();
                if (cat1 == (cat2 = t2.getCategory())) {
                    return IMPOutlinePage.this.fLabelProvider.getText((Object)t1).compareTo(IMPOutlinePage.this.fLabelProvider.getText((Object)t2));
                }
                return cat1 - cat2;
            }
        };
        private ISourcePositionLocator fLocator = IMPOutlinePage.access$100(IMPOutlinePage.this).getNodeLocator();
        private ViewerComparator fPositionComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int pos1 = LexicalSortingAction.this.fLocator.getStartOffset(e1);
                int pos2 = LexicalSortingAction.this.fLocator.getStartOffset(e2);
                return pos1 - pos2;
            }
        };

        public LexicalSortingAction() {
            this.setText("Sort");
            this.setToolTipText("Sort by name");
            this.setDescription("Sort entries lexically by name");
            ImageDescriptor desc = RuntimePlugin.getImageDescriptor("icons/alphab_sort_co.gif");
            this.setHoverImageDescriptor(desc);
            this.setImageDescriptor(desc);
            boolean checked = RuntimePlugin.getInstance().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(final boolean on, boolean store) {
            final TreeViewer outlineViewer = IMPOutlinePage.this.getTreeViewer();
            this.setChecked(on);
            BusyIndicator.showWhile((Display)outlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    if (on) {
                        outlineViewer.setComparator(LexicalSortingAction.this.fElementComparator);
                    } else {
                        outlineViewer.setComparator(LexicalSortingAction.this.fPositionComparator);
                    }
                }
            });
            if (store) {
                RuntimePlugin.getInstance().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
            }
        }
    }
}

