/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.imp.editor.StorageLabelProvider;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class OutlineLabelProvider
implements ILabelProvider,
IColorProvider,
ILanguageService {
    boolean fShowDefiningType;
    private boolean fIsShowingInheritedMembers;
    protected ListenerList fListeners = new ListenerList(1);
    private final ILabelProvider fLanguageLabelProvider;
    private ArrayList fLabelDecorators;
    protected final StorageLabelProvider fStorageLabelProvider;
    protected final IElementImageProvider fImageLabelProvider;
    private Color fForegroundColor;

    public OutlineLabelProvider(ILabelProvider langLabelProvider, IElementImageProvider elemImageProvider, boolean showInheritedMembers, boolean showStorage, Color foregroundColor) {
        this.fLanguageLabelProvider = langLabelProvider;
        this.fImageLabelProvider = elemImageProvider;
        this.fIsShowingInheritedMembers = showInheritedMembers;
        this.fForegroundColor = foregroundColor;
        this.fStorageLabelProvider = showStorage ? new StorageLabelProvider() : null;
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        if (this.fLabelDecorators == null) {
            this.fLabelDecorators = new ArrayList(2);
        }
        this.fLabelDecorators.add(decorator);
    }

    public String getText(Object element) {
        String result = this.fLanguageLabelProvider.getText(element);
        if (result.length() == 0 && element instanceof IStorage) {
            result = this.fStorageLabelProvider.getText(element);
        }
        result = this.decorateText(result, element);
        if (this.fShowDefiningType) {
            // empty if block
        }
        return result;
    }

    private long getTextFlags(Object element) {
        return 0L;
    }

    private long getImageFlags(Object element) {
        return 0L;
    }

    protected String decorateText(String text, Object element) {
        if (this.fLabelDecorators != null && text.length() > 0) {
            for (int i = 0; i < this.fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                text = decorator.decorateText(text, element);
            }
        }
        return text;
    }

    public Color getForeground(Object element) {
        if (this.fIsShowingInheritedMembers) {
            return this.fForegroundColor;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public void setShowDefiningType(boolean showDefiningType) {
        this.fShowDefiningType = showDefiningType;
    }

    public boolean isShowDefiningType() {
        return this.fShowDefiningType;
    }

    public Image getImage(Object element) {
        Image result = null;
        if (this.fImageLabelProvider != null) {
            result = this.fImageLabelProvider.getImageLabel(element, this.getImageFlags(element));
        } else if (this.fLanguageLabelProvider != null) {
            result = this.fLanguageLabelProvider.getImage(element);
        }
        if (result == null && element instanceof IStorage) {
            result = this.fStorageLabelProvider.getImage(element);
        }
        return this.decorateImage(result, element);
    }

    protected Image decorateImage(Image image, Object element) {
        if (this.fLabelDecorators != null && image != null) {
            for (int i = 0; i < this.fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                image = decorator.decorateImage(image, element);
            }
        }
        return image;
    }

    public void addListener(ILabelProviderListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        if (this.fLabelDecorators != null) {
            for (int i = 0; i < this.fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                decorator.dispose();
            }
            this.fLabelDecorators = null;
        }
        if (this.fStorageLabelProvider != null) {
            this.fStorageLabelProvider.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fLabelDecorators != null) {
            for (int i = 0; i < this.fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this.fLabelDecorators.get(i);
                decorator.removeListener(listener);
            }
        }
        this.fListeners.remove((Object)listener);
    }

    public static interface IElementImageProvider
    extends ILanguageService {
        public Image getImageLabel(Object var1, long var2);
    }
}

