/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.services.ITokenColorer;
import org.eclipse.imp.utils.ConsoleUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationController
implements IModelListener {
    public static final String CONSOLE_NAME = "Source Tokens";
    private final ISourceViewer fSourceViewer;
    private final ITokenColorer fColorer;
    private final Stack<IRegion> fWorkItems = new Stack();

    public PresentationController(ISourceViewer sourceViewer, Language language) {
        this.fSourceViewer = sourceViewer;
        this.fColorer = ServiceFactory.getInstance().getTokenColorer(language);
    }

    @Override
    public IModelListener.AnalysisRequired getAnalysisRequired() {
        return IModelListener.AnalysisRequired.LEXICAL_ANALYSIS;
    }

    private void dumpToken(Object token, PrintStream ps) {
        ps.print(" \t" + token);
        ps.println();
    }

    private void dumpTokens(Iterator<Object> tokenIter, PrintStream ps) {
        ps.println(" Kind \tOffset \tLen \tLine \tCol \tText");
        while (tokenIter.hasNext()) {
            this.dumpToken(tokenIter.next(), ps);
        }
    }

    public void damage(IRegion region) {
        if (this.fColorer == null) {
            return;
        }
        IRegion bigRegion = this.fColorer.calculateDamageExtent(region);
        if (bigRegion != null) {
            this.fWorkItems.push(bigRegion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IParseController controller, IProgressMonitor monitor) {
        if (!monitor.isCanceled()) {
            Stack<IRegion> stack = this.fWorkItems;
            synchronized (stack) {
                for (int n = this.fWorkItems.size() - 1; !monitor.isCanceled() && n >= 0; --n) {
                    Region damage = (Region)this.fWorkItems.get(n);
                    this.changeTextPresentationForRegion(controller, monitor, (IRegion)damage);
                }
                if (!monitor.isCanceled()) {
                    this.fWorkItems.removeAllElements();
                }
            }
        }
    }

    private void changeTextPresentationForRegion(IParseController parseController, IProgressMonitor monitor, IRegion damage) {
        if (parseController == null) {
            return;
        }
        if (PreferenceCache.dumpTokens) {
            PrintStream ps = ConsoleUtil.findConsoleStream(CONSOLE_NAME);
            this.dumpTokens(parseController.getTokenIterator(damage), ps);
        }
        TextPresentation presentation = new TextPresentation();
        ISourcePositionLocator locator = parseController.getNodeLocator();
        this.aggregateTextPresentation(parseController, monitor, damage, presentation, locator);
        if (!monitor.isCanceled() && !presentation.isEmpty()) {
            this.submitTextPresentation(presentation);
        }
    }

    private void aggregateTextPresentation(IParseController parseController, IProgressMonitor monitor, IRegion damage, TextPresentation presentation, ISourcePositionLocator locator) {
        int prevOffset = -1;
        int prevEnd = -1;
        Iterator iter = parseController.getTokenIterator(damage);
        while (iter.hasNext() && !monitor.isCanceled()) {
            Object token = iter.next();
            int offset = locator.getStartOffset(token);
            int end = locator.getEndOffset(token);
            if (offset <= prevEnd && end >= prevOffset) continue;
            this.changeTokenPresentation(parseController, presentation, token, locator);
            prevOffset = offset;
            prevEnd = end;
        }
    }

    private void changeTokenPresentation(IParseController controller, TextPresentation presentation, Object token, ISourcePositionLocator locator) {
        TextAttribute attribute = this.fColorer.getColoring(controller, token);
        StyleRange styleRange = new StyleRange(locator.getStartOffset(token), locator.getEndOffset(token) - locator.getStartOffset(token) + 1, attribute == null ? null : attribute.getForeground(), attribute == null ? null : attribute.getBackground(), attribute == null ? 0 : attribute.getStyle());
        if (styleRange.length > 0 && styleRange.start + styleRange.length <= this.fSourceViewer.getDocument().getLength()) {
            presentation.addStyleRange(styleRange);
        }
    }

    private void submitTextPresentation(final TextPresentation presentation) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                int charCount = PresentationController.this.fSourceViewer != null ? PresentationController.this.fSourceViewer.getDocument().getLength() : 0;
                int lastStart = presentation.getLastStyleRange().start;
                int lastLength = presentation.getLastStyleRange().length;
                int end = lastStart + lastLength;
                TextPresentation newPresentation = null;
                if (end >= charCount) {
                    newPresentation = new TextPresentation();
                    Iterator presIt = presentation.getAllStyleRangeIterator();
                    while (presIt.hasNext()) {
                        StyleRange nextRange = (StyleRange)presIt.next();
                        if (nextRange.start + nextRange.length >= charCount) continue;
                        newPresentation.addStyleRange(nextRange);
                    }
                } else {
                    newPresentation = presentation;
                }
                try {
                    if (PresentationController.this.fSourceViewer != null) {
                        PresentationController.this.fSourceViewer.changeTextPresentation(newPresentation, true);
                    }
                }
                catch (IllegalArgumentException e) {
                    Iterator ranges = presentation.getAllStyleRangeIterator();
                    ArrayList<StyleRange> rangesList = new ArrayList<StyleRange>();
                    while (ranges.hasNext()) {
                        rangesList.add((StyleRange)ranges.next());
                    }
                    String explanation = null;
                    if (rangesList.size() > 0) {
                        int finalLength;
                        int finalStart;
                        int finalEnd;
                        StyleRange firstRange = (StyleRange)rangesList.get(0);
                        if (firstRange.length < 0) {
                            explanation = "Style range with start = " + firstRange.start + " has negative length = " + firstRange.length;
                        }
                        if (explanation == null) {
                            for (int i = 1; i < rangesList.size(); ++i) {
                                int currStart = ((StyleRange)rangesList.get((int)i)).start;
                                int currLength = ((StyleRange)rangesList.get((int)i)).length;
                                if (currLength < 0) {
                                    explanation = "Style range with start = " + currStart + " has negative length = " + currLength;
                                    break;
                                }
                                int prevStart = ((StyleRange)rangesList.get((int)(i - 1))).start;
                                int prevLength = ((StyleRange)rangesList.get((int)(i - 1))).length;
                                if (prevStart + prevLength - 1 < currStart) continue;
                                explanation = "Style range with start = " + prevStart + " and length = " + prevLength + "overlaps style range with start = " + currStart;
                                break;
                            }
                        }
                        if (explanation == null && (finalEnd = (finalStart = presentation.getLastStyleRange().start) + (finalLength = presentation.getLastStyleRange().length)) >= charCount) {
                            explanation = "Final style range with start = " + finalStart + " and length = " + finalLength + "extends beyond last character (character count = " + charCount + ")";
                        }
                        if (explanation == null) {
                            explanation = "Cause not identified";
                        }
                    }
                    ErrorHandler.logError("PresentationController.submitTextPresentation:  IllegalArgumentException:  " + explanation, e);
                    throw e;
                }
            }
        });
    }
}

