/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.language;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.LanguageValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Language {
    public static final String LANGUAGE_ID_ATTR = "language";
    private String language;
    public static final String DERIVED_FROM_ATTR = "derivedFrom";
    private String derivedFrom;
    public static final String EXTENSIONS_ATTR = "extensions";
    private Collection<String> fFilenameExtensions;
    public static final String VALIDATOR_ATTR = "validator";
    private LanguageValidator validator;
    public static final String DESCRIPTION_ATTR = "description";
    private String description;
    public static final String NATURE_ID_ATTR = "natureID";
    private String natureId;
    public static final String SYNONYMS_ATTR = "synonyms";
    private Collection<String> fSynonyms;
    public static final String URL_ATTR = "url";
    private String url;

    Language(IConfigurationElement element) {
        try {
            this.language = element.getAttribute(LANGUAGE_ID_ATTR);
            this.natureId = element.getAttribute(NATURE_ID_ATTR);
            this.description = element.getAttribute(DESCRIPTION_ATTR);
            this.derivedFrom = element.getAttribute(DERIVED_FROM_ATTR);
            this.url = element.getAttribute(URL_ATTR);
            this.fFilenameExtensions = this.parseList(element.getAttribute(EXTENSIONS_ATTR));
            this.fSynonyms = this.parseList(element.getAttribute(SYNONYMS_ATTR));
            this.validator = (LanguageValidator)element.createExecutableExtension(VALIDATOR_ATTR);
        }
        catch (CoreException e) {
            this.validator = null;
        }
    }

    public Language(String language, String natureId, String description, String derivedFrom, String url, String fileNameExtensions, String synonyms, LanguageValidator validator) {
        this.language = language;
        this.natureId = natureId;
        this.description = description;
        this.derivedFrom = derivedFrom;
        this.url = url;
        this.fFilenameExtensions = this.parseList(fileNameExtensions);
        this.fSynonyms = this.parseList(synonyms);
        this.validator = validator;
    }

    public String getName() {
        return this.language;
    }

    public String getNatureID() {
        return this.natureId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDerivedFrom() {
        return this.derivedFrom;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasExtension(String extension) {
        return this.fFilenameExtensions.contains(extension);
    }

    public Collection<String> getFilenameExtensions() {
        return this.fFilenameExtensions;
    }

    @Deprecated
    public Collection<String> getSynonyms() {
        return this.fSynonyms;
    }

    public Language getBaseLanguage() {
        String baseLangName = this.getDerivedFrom();
        if (baseLangName != null) {
            return LanguageRegistry.findLanguage(baseLangName);
        }
        return null;
    }

    public LanguageValidator getValidator() {
        return this.validator;
    }

    protected Collection<String> parseList(String list) {
        ArrayList<String> result = new ArrayList<String>();
        if (list != null) {
            int length = list.length();
            int size = length > 0 ? 1 : 0;
            for (int n = 0; n < length; ++n) {
                if (list.charAt(n) != ',') continue;
                ++size;
            }
            StringTokenizer st = new StringTokenizer(list, ",");
            int n = 0;
            while (st.hasMoreElements()) {
                String exten = st.nextToken().trim();
                if (exten.startsWith(".")) {
                    ErrorHandler.logMessage("Ignoring leading '.' in file-name extension " + exten + " for language '" + this.getName() + "'.", null);
                    exten = exten.substring(1);
                }
                result.add(exten);
                ++n;
            }
        }
        return result;
    }

    public String toString() {
        return "Language[name=" + this.getName() + ",description=" + this.getDescription() + ",filename extensions=" + this.getFilenameExtensions() + "]";
    }
}

