/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.language;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.EditorInputUtils;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageValidator;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageRegistry {
    private static Object statusCheckMutex = new Object();
    private static boolean isFullyInitialized = false;
    private static Map<String, Language> fRegister;
    private static final String EXTENSION = "languageDescription";
    private static IEditorDescriptor universalEditor;
    private static EditorRegistry editorRegistry;

    private LanguageRegistry() {
    }

    private static Map<String, Language> getRegister() {
        if (fRegister == null) {
            fRegister = new HashMap<String, Language>();
        }
        return fRegister;
    }

    private static void preInitEditorRegistry() {
        try {
            editorRegistry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
            LanguageRegistry.initializeUniversalEditorDescriptor(editorRegistry);
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.imp.runtime", EXTENSION);
            if (extensionPoint == null) {
                ErrorHandler.reportError("Nonexistent extension point called \"org.eclipse.imp.runtime.languageDescription");
            } else {
                IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
                if (elements != null) {
                    for (IConfigurationElement element : elements) {
                        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
                        if (bundle == null) continue;
                        LanguageRegistry.register(new Language(element));
                    }
                }
            }
        }
        catch (InvalidRegistryObjectException e) {
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeErrorMsg("IMP LanguageRegistry error in preInitEditorRegistry():  InvalidRegistryObjectException:  " + (Object)((Object)e));
            }
            ErrorHandler.reportError("IMP LanguageRegistry error", e);
        }
    }

    public static Language findLanguage(IEditorInput editorInput, IDocumentProvider docProvider) {
        if (!isFullyInitialized) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        IPath path = EditorInputUtils.getPath(editorInput);
        return LanguageRegistry.findLanguage(path, docProvider.getDocument((Object)editorInput));
    }

    public static Language findLanguage(IPath path, IDocument doc) {
        String docContents;
        if (!LanguageRegistry.isFullyInitialized()) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        String extension = path.getFileExtension();
        String string = docContents = doc != null ? doc.get() : null;
        if (extension != null) {
            for (Language lang : LanguageRegistry.getRegister().values()) {
                if (!lang.hasExtension(extension)) continue;
                LanguageValidator validator = lang.getValidator();
                if (validator != null && docContents != null) {
                    if (!validator.validate(docContents)) continue;
                    return lang;
                }
                return lang;
            }
        }
        if (PreferenceCache.emitMessages) {
            RuntimePlugin.getInstance().writeErrorMsg("No language support for text/source file of type '" + extension + "'.");
        } else {
            ErrorHandler.reportError("No language support for text/source file of type '" + extension + "'.");
        }
        return null;
    }

    public static Language findLanguageByNature(String natureID) {
        if (!LanguageRegistry.isFullyInitialized()) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        for (Language lang : LanguageRegistry.getRegister().values()) {
            String aNatureID = lang.getNatureID();
            if (aNatureID == null || !aNatureID.equals(natureID)) continue;
            return lang;
        }
        return null;
    }

    public static Collection<Language> getLanguages() {
        if (!LanguageRegistry.isFullyInitialized()) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        return Collections.unmodifiableCollection(LanguageRegistry.getRegister().values());
    }

    public static Language findLanguage(String languageName) {
        if (!LanguageRegistry.isFullyInitialized()) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        return LanguageRegistry.getRegister().get(languageName.toLowerCase());
    }

    public static void registerLanguage(Language language) {
        if (!LanguageRegistry.isFullyInitialized()) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        LanguageRegistry.register(language);
        ArrayList<IFileEditorMapping> mappings = new ArrayList<IFileEditorMapping>();
        Collections.addAll(mappings, LanguageRegistry.getEditorRegistry().getFileEditorMappings());
        LanguageRegistry.addUniversalEditorMappings(language.getFilenameExtensions(), mappings);
        LanguageRegistry.updateEditorRegistry(mappings);
    }

    private static EditorRegistry getEditorRegistry() {
        return editorRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeRegistryAsNeeded() {
        Object object = statusCheckMutex;
        synchronized (object) {
            if (LanguageRegistry.isFullyInitialized()) {
                return;
            }
            LanguageRegistry.preInitEditorRegistry();
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeInfoMsg("Looking for IMP language description extensions...");
            }
            List<String> langExtens = LanguageRegistry.collectAllLanguageFileNameExtensions();
            ArrayList<IFileEditorMapping> newMap = new ArrayList<IFileEditorMapping>();
            LanguageRegistry.addNonUniversalEditorMappings(newMap);
            LanguageRegistry.addUniversalEditorMappings(langExtens, newMap);
            LanguageRegistry.updateEditorRegistry(newMap);
            LanguageRegistry.setFullyInitialized();
        }
    }

    private static void addNonUniversalEditorMappings(List<IFileEditorMapping> newMap) {
        for (IFileEditorMapping mapping : LanguageRegistry.getEditorRegistry().getFileEditorMappings()) {
            IEditorDescriptor defaultEditor = mapping.getDefaultEditor();
            if (defaultEditor != null && defaultEditor.getId().equals("org.eclipse.imp.runtime.impEditor")) continue;
            newMap.add(mapping);
        }
    }

    private static void addUniversalEditorMappings(Iterable<String> extensions, List<IFileEditorMapping> newMap) {
        IFileEditorMapping[] mappings = editorRegistry.getFileEditorMappings();
        for (String ext : extensions) {
            IFileEditorMapping mapping = LanguageRegistry.findMappingFor(ext, mappings);
            if (mapping == null) {
                mapping = new FileEditorMapping(ext);
                FileEditorMapping fem = (FileEditorMapping)mapping;
            }
            IEditorDescriptor defaultEditor = mapping.getDefaultEditor();
            FileEditorMapping fem = (FileEditorMapping)mapping;
            if (defaultEditor == null || defaultEditor.getId().equals("")) {
                fem.setDefaultEditor((EditorDescriptor)universalEditor);
            } else {
                boolean gotIt = false;
                for (IEditorDescriptor editor : fem.getEditors()) {
                    if (editor != universalEditor) continue;
                    gotIt = true;
                    break;
                }
                if (!gotIt) {
                    fem.addEditor((EditorDescriptor)universalEditor);
                }
            }
            newMap.add(mapping);
        }
    }

    private static IFileEditorMapping findMappingFor(String ext, IFileEditorMapping[] mappings) {
        for (int i = 0; i < mappings.length; ++i) {
            if (!mappings[i].getExtension().equals(ext)) continue;
            return mappings[i];
        }
        return null;
    }

    private static void updateEditorRegistry(final List<IFileEditorMapping> newMap) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LanguageRegistry.getEditorRegistry().setFileEditorMappings(newMap.toArray(new FileEditorMapping[newMap.size()]));
                LanguageRegistry.getEditorRegistry().saveAssociations();
            }
        });
    }

    private static List<String> collectAllLanguageFileNameExtensions() {
        ArrayList<String> allExtens = new ArrayList<String>();
        for (Language lang : LanguageRegistry.getRegister().values()) {
            allExtens.addAll(lang.getFilenameExtensions());
        }
        return allExtens;
    }

    private static void initializeUniversalEditorDescriptor(EditorRegistry editorRegistry) {
        IEditorDescriptor[] allEditors;
        for (IEditorDescriptor editor : allEditors = editorRegistry.getSortedEditorsFromPlugins()) {
            if (!editor.getId().equals("org.eclipse.imp.runtime.impEditor")) continue;
            universalEditor = editor;
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeInfoMsg("Universal editor descriptor: " + universalEditor.getId() + ":" + universalEditor.getLabel());
            }
            return;
        }
        if (universalEditor == null) {
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeErrorMsg("IMP LanguageRegistry error in initializeUniversalEditorDescroptor():  unable to initialize Universal Editor");
            } else {
                ErrorHandler.reportError("Unable to locate Universal Editor descriptor", null);
            }
        }
    }

    private static void register(Language language) {
        LanguageRegistry.getRegister().put(language.getName().toLowerCase(), language);
        if (PreferenceCache.emitMessages) {
            RuntimePlugin.getInstance().writeInfoMsg("Registered language description: " + language.getName());
        }
    }

    private static void setFullyInitialized() {
        isFullyInitialized = true;
    }

    private static boolean isFullyInitialized() {
        return isFullyInitialized;
    }
}

