/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.model.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.model.ISourceFolder;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.IWorkspaceModel;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public class CompilationUnitRef
implements ICompilationUnit {
    final ISourceProject fProject;
    final IPath fPath;
    private IParseController fParseCtrlr;

    public CompilationUnitRef(IPath path, ISourceProject proj) {
        this.fProject = proj;
        this.fPath = path;
    }

    public ISourceProject getProject() {
        return this.fProject;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public String getName() {
        return this.fPath.lastSegment();
    }

    public ISourceEntity getParent() {
        IContainer parent = (IContainer)this.fProject.getRawProject().findMember(this.fPath.removeLastSegments(1));
        try {
            return ModelFactory.open(parent);
        }
        catch (ModelFactory.ModelException e) {
            RuntimePlugin.getInstance().logException("Error obtaining parent of " + this.getName(), e);
            return null;
        }
    }

    public ISourceEntity getAncestor(Class ofType) {
        if (ofType == ICompilationUnit.class) {
            return this;
        }
        if (ofType == ISourceProject.class) {
            return this.fProject;
        }
        if (ofType == IWorkspaceModel.class) {
            return ModelFactory.getModelRoot();
        }
        if (ofType == ISourceFolder.class) {
            return this.getParent();
        }
        return null;
    }

    public IResource getResource() {
        return this.getFile();
    }

    public IFile getFile() {
        if (this.fPath.getDevice() != null && this.fPath.getDevice().length() > 0) {
            return null;
        }
        if (this.fPath.isAbsolute()) {
            return this.fProject.getRawProject().getWorkspace().getRoot().getFile(this.fPath);
        }
        return this.fProject.getRawProject().getFile(this.fPath);
    }

    public Object getAST(IMessageHandler msgHandler, IProgressMonitor monitor) {
        IDocument doc;
        IFile file = this.getFile();
        TextFileDocumentProvider tfdp = new TextFileDocumentProvider();
        IDocument iDocument = doc = file != null ? tfdp.getDocument((Object)file) : null;
        if (this.fParseCtrlr == null) {
            Language lang = LanguageRegistry.findLanguage(this.fPath, doc);
            this.fParseCtrlr = ServiceFactory.getInstance().getParseController(lang);
        }
        IPath projRelPath = this.fPath.isAbsolute() ? this.fPath.removeFirstSegments(1) : this.fPath;
        this.fParseCtrlr.initialize(projRelPath, this.fProject, msgHandler);
        return this.fParseCtrlr.parse(this.getSource(), false, monitor);
    }

    public String getSource() {
        String absPath = this.fPath.getDevice() != null ? this.fPath.toOSString() : (this.fPath.isAbsolute() ? ResourcesPlugin.getWorkspace().getRoot().getLocation().append(this.fPath).toOSString() : this.fProject.getRawProject().getLocation().append(this.fPath).toOSString());
        File inFile = new File(absPath);
        if (!inFile.exists() || !inFile.canRead()) {
            throw new IllegalArgumentException("CompilationUnitRef.getSource(): file does not exist or cannot be read: " + this);
        }
        FileReader fileReader = null;
        long fileLen = inFile.length();
        try {
            fileReader = new FileReader(inFile);
            char[] buffer = new char[(int)fileLen];
            fileReader.read(buffer);
            return new String(buffer);
        }
        catch (FileNotFoundException e) {
            ErrorHandler.reportError("CompilationUnitRef.getSource(): file not found: " + this);
            return null;
        }
        catch (IOException e) {
            ErrorHandler.reportError("CompilationUnitRef.getSource(): cannot read file: " + this);
            return null;
        }
    }

    public void commit(IProgressMonitor mon) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompilationUnitRef)) {
            return false;
        }
        CompilationUnitRef other = (CompilationUnitRef)obj;
        return this.fProject.equals(other.fProject) && this.fPath.equals(other.fPath);
    }

    public int hashCode() {
        int result = 4831;
        result = result * 4933 + this.fProject.hashCode();
        result = result * 1627 + this.fPath.hashCode();
        return result;
    }

    public String toString() {
        return "<compilation unit " + this.getPath().toPortableString() + ">";
    }
}

