/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import java.util.Arrays;
import java.util.List;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class FieldEditor
extends org.eclipse.jface.preference.FieldEditor {
    protected static final List<String> PREFS_LEVELS_AS_LIST = Arrays.asList(IPreferencesService.levels);
    protected PreferencePage prefPage = null;
    protected PreferencesTab prefTab = null;
    protected IPreferencesService preferencesService = null;
    protected String preferencesLevel = null;
    protected Composite parent = null;
    protected boolean isInherited = false;
    protected boolean wasInherited = false;
    protected boolean isRemovable = false;
    protected boolean hasSpecialValue = false;
    protected Object specialValue = null;
    protected String levelFromWhichLoaded = null;
    protected boolean fieldModified = false;
    protected Object previousValue = null;
    protected String toolTipText = null;

    protected FieldEditor() {
    }

    public FieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level) {
        this.preferencesService = service;
        this.preferencesLevel = level;
        this.prefPage = page;
        this.setPage((DialogPage)this.prefPage);
        this.prefTab = tab;
    }

    public FieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.preferencesService = service;
        this.preferencesLevel = level;
        this.parent = parent;
        this.prefPage = page;
        this.setPage((DialogPage)this.prefPage);
        this.prefTab = tab;
    }

    public String getLevelFromWhichLoaded() {
        return this.levelFromWhichLoaded;
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    protected void setInherited(boolean inherited) {
        this.wasInherited = this.isInherited;
        this.isInherited = inherited;
    }

    protected boolean inheritanceChanged() {
        return this.wasInherited != this.isInherited;
    }

    public boolean hasSpecialValue() {
        return this.hasSpecialValue;
    }

    public void setNoSpecialValue() {
        this.hasSpecialValue = false;
        this.specialValue = null;
    }

    public Object getSpecialValue() {
        if (this.hasSpecialValue) {
            return this.specialValue;
        }
        throw new IllegalStateException("FieldEditor.getSpecialValue():  called when field does not have a special value");
    }

    public void setSpecialValue(Object specialValue) {
        this.hasSpecialValue = true;
        this.specialValue = specialValue;
    }

    public boolean isRemovable() {
        return this.isRemovable;
    }

    public void setRemovable(boolean isRemovable) {
        this.isRemovable = isRemovable;
    }

    public void load() {
        if (this.preferencesService != null) {
            this.doLoad();
            this.refreshValidState();
        }
    }

    protected abstract void doLoad();

    public void loadDefault() {
        if (this.preferencesService != null) {
            this.setPresentsDefaultValue(true);
            this.doLoadDefault();
            this.refreshValidState();
        }
    }

    protected abstract void doLoadDefault();

    public void loadLevel(String level) {
        if (this.preferencesService != null && this.preferencesService.isaPreferencesLevel(level)) {
            this.doLoadLevel(level);
            if ("default".equals(level)) {
                this.setPresentsDefaultValue(true);
            }
            this.valueChanged();
            this.refreshValidState();
        }
    }

    protected abstract void doLoadLevel(String var1);

    public String loadWithInheritance() {
        if (this.preferencesService != null) {
            this.levelFromWhichLoaded = this.doLoadWithInheritance();
            if ("default".equals(this.levelFromWhichLoaded)) {
                this.setPresentsDefaultValue(true);
            }
            this.refreshValidState();
        }
        return this.levelFromWhichLoaded;
    }

    protected abstract String doLoadWithInheritance();

    public void store() {
        if (this.preferencesService == null) {
            throw new IllegalStateException("FieldEditor.store():  attempt to store when preferences service is null");
        }
        if (this.preferencesService == null) {
            throw new IllegalStateException("FieldEditor.store():  attempt to store when preferences level is null");
        }
        if (this.isInherited) {
            return;
        }
        if (!this.fieldModified) {
            return;
        }
        if ("project".equals(this.preferencesLevel) && this.preferencesService.getProject() == null) {
            throw new IllegalStateException("FieldEditor.store():  attempt to store project preference when project is not set");
        }
        this.doStore();
        this.fieldModified = false;
        this.levelFromWhichLoaded = this.preferencesLevel;
    }

    protected abstract void doStore();

    public void setPreferencesLevel(String level) {
        if (!this.preferencesService.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("FieldEditor.setPreferencesLevel():  given level = " + level + " is invalid");
        }
        this.preferencesLevel = level;
    }

    public String getPreferencesLevel() {
        return this.preferencesLevel;
    }

    public Composite getParent() {
        return this.parent;
    }

    protected abstract boolean valueChanged();

    protected boolean notifyState(boolean state) {
        if (this.prefTab != null) {
            this.prefTab.setValid(state);
        }
        return state;
    }

    public void setModifiedMarkOnLabel() {
        Label label = this.getLabelControl(this.parent);
        if (label != null) {
            label.setForeground(PreferencesUtilities.colorRed);
        }
    }

    public void clearModifiedMarkOnLabel() {
        Label label = this.getLabelControl(this.parent);
        if (label != null) {
            label.setForeground(PreferencesUtilities.colorBlack);
        }
    }

    protected void clearErrorMessage() {
        this.prefTab.clearErrorMessages((Object)this);
    }

    protected void setErrorMessage(String msg) {
        this.prefTab.setErrorMessage((Object)this, msg);
    }

    public boolean hasErrorMessage() {
        return this.prefTab.errorMessages.containsKey((Object)this);
    }

    public String getFieldMessagePrefix() {
        return this.getLabelText() + ":  ";
    }

    protected abstract void doSetToolTip();

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        this.doSetToolTip();
    }

    public String getToolTipText() {
        return this.toolTipText;
    }
}

