/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.services.base;

import java.util.ArrayList;
import lpg.runtime.Adjunct;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import org.eclipse.imp.services.base.FolderBase;

public abstract class LPGFolderBase
extends FolderBase {
    protected IPrsStream prsStream;

    protected void makeAnnotationWithOffsets(int first_offset, int last_offset) {
        super.makeAnnotation(first_offset, last_offset - first_offset + 1);
    }

    protected void makeAnnotation(IToken first_token, IToken last_token) {
        if (last_token.getEndLine() > first_token.getLine()) {
            IToken next_token = this.prsStream.getIToken(this.prsStream.getNext(last_token.getTokenIndex()));
            IToken[] adjuncts = next_token.getPrecedingAdjuncts();
            IToken gate_token = adjuncts.length == 0 ? next_token : adjuncts[0];
            this.makeAnnotationWithOffsets(first_token.getStartOffset(), last_token.getEndOffset());
        }
    }

    protected void makeAdjunctAnnotations() {
        IToken[] comments;
        ILexStream lexStream = this.prsStream.getILexStream();
        if (lexStream == null) {
            return;
        }
        ArrayList adjuncts = this.prsStream.getAdjuncts();
        for (int i = 0; i < adjuncts.size(); i += comments.length) {
            Adjunct adjunct = (Adjunct)adjuncts.get(i);
            IToken previous_token = this.prsStream.getIToken(adjunct.getTokenIndex());
            IToken next_token = this.prsStream.getIToken(this.prsStream.getNext(previous_token.getTokenIndex()));
            comments = previous_token.getFollowingAdjuncts();
            for (int k = 0; k < comments.length; ++k) {
                Adjunct comment = (Adjunct)comments[k];
                if (comment.getEndLine() <= comment.getLine()) continue;
                IToken gate_token = k + 1 < comments.length ? comments[k + 1] : next_token;
                this.makeAnnotationWithOffsets(comment.getStartOffset(), gate_token.getLine() > comment.getEndLine() ? lexStream.getLineOffset(gate_token.getLine() - 1) : comment.getEndOffset());
            }
        }
    }
}

