/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.services.base;

import java.util.ArrayList;
import java.util.Stack;
import lpg.runtime.IToken;
import lpg.runtime.PrsStream;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.parser.SimpleLPGParseController;
import org.eclipse.imp.services.IOutlineImage;
import org.eclipse.imp.services.IOutliner;
import org.eclipse.imp.services.base.DefaultOutlineImage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class OutlinerBase
implements IOutliner {
    protected IParseController fParseController;
    protected Tree tree;
    private Stack<TreeItem> fItemStack = new Stack();
    private Object[] previous = null;

    public void setEditor(ITextEditor editor) {
    }

    public void setTree(Tree tree) {
        this.tree = tree;
        this.tree.addSelectionListener((SelectionListener)new TreeSelectionListener());
    }

    public void pushTopItem(String itemName, Object node) {
        this.fItemStack.push(this.createTopItem(itemName, node));
    }

    public void pushTopItem(String itemName, Object node, IOutlineImage image) {
        this.fItemStack.push(this.createTopItem(itemName, node, image));
    }

    public void pushTopItem(String itemName, Object node, IOutlineImage image, int style) {
        this.fItemStack.push(this.createTopItem(itemName, node, image, style));
    }

    public void pushSubItem(String itemName, Object node) {
        this.fItemStack.push(this.createSubItem(itemName, node));
    }

    public void pushSubItem(String itemName, Object node, IOutlineImage image) {
        this.fItemStack.push(this.createSubItem(itemName, node, image));
    }

    public void pushSubItem(String itemName, Object node, IOutlineImage image, int style) {
        this.fItemStack.push(this.createSubItem(itemName, node, image, style));
    }

    public void popSubItem() {
        this.fItemStack.pop();
    }

    public void addSubItem(String label, Object node) {
        this.createSubItem(label, node);
    }

    public void addSubItem(String label, Object node, IOutlineImage image) {
        this.createSubItem(label, node, image);
    }

    public void addSubItem(String label, Object node, IOutlineImage image, int style) {
        this.createSubItem(label, node, image, style);
    }

    public TreeItem createTopItem(String label, Object n) {
        TreeItem treeItem = new TreeItem(this.tree, 0);
        treeItem.setText(label);
        treeItem.setImage(DefaultOutlineImage.getDefaultOutlineImage().getOutlineItemImage());
        if (n != null) {
            treeItem.setData(n);
        }
        return treeItem;
    }

    public TreeItem createTopItem(String label, Object n, IOutlineImage image) {
        TreeItem treeItem = new TreeItem(this.tree, 0);
        treeItem.setText(label);
        treeItem.setImage(image.getOutlineItemImage());
        if (n != null) {
            treeItem.setData(n);
        }
        return treeItem;
    }

    public TreeItem createTopItem(String label, Object n, IOutlineImage image, int style) {
        TreeItem treeItem = new TreeItem(this.tree, style);
        treeItem.setText(label);
        treeItem.setImage(image.getOutlineItemImage());
        if (n != null) {
            treeItem.setData(n);
        }
        return treeItem;
    }

    public TreeItem createSubItem(String label, Object n) {
        TreeItem treeItem = new TreeItem(this.fItemStack.peek(), 0);
        treeItem.setText(label);
        if (n != null) {
            treeItem.setData(n);
        }
        treeItem.setImage(DefaultOutlineImage.getDefaultOutlineImage().getOutlineItemImage());
        return treeItem;
    }

    public TreeItem createSubItem(String label, Object n, IOutlineImage image) {
        TreeItem treeItem = new TreeItem(this.fItemStack.peek(), 0);
        treeItem.setText(label);
        if (n != null) {
            treeItem.setData(n);
        }
        treeItem.setImage(image.getOutlineItemImage());
        return treeItem;
    }

    public TreeItem createSubItem(String label, Object n, IOutlineImage image, int style) {
        TreeItem treeItem = new TreeItem(this.fItemStack.peek(), style);
        treeItem.setText(label);
        if (n != null) {
            treeItem.setData(n);
        }
        treeItem.setImage(image.getOutlineItemImage());
        return treeItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOutlinePresentation(IParseController controller, int offset) {
        if (controller == null || this.tree == null) {
            return;
        }
        if (!this.significantChange(controller)) {
            return;
        }
        this.fParseController = controller;
        boolean redrawSetFalse = false;
        try {
            Object root = controller.getCurrentAst();
            if (root == null) {
                return;
            }
            if (!this.tree.isDisposed()) {
                this.tree.setRedraw(false);
                redrawSetFalse = true;
                this.tree.removeAll();
            }
            this.fItemStack.clear();
            this.sendVisitorToAST(root);
        }
        catch (Throwable e) {
            ErrorHandler.reportError("Exception generating outlinel", e);
        }
        finally {
            if (redrawSetFalse) {
                this.tree.setRedraw(true);
            }
        }
    }

    protected boolean significantChange(IParseController controller) {
        int i;
        boolean previousWasNull = this.previous == null;
        boolean result = false;
        if (previousWasNull) {
            this.previous = new Object[3];
            for (i = 0; i < this.previous.length; ++i) {
                this.previous[i] = null;
            }
            if (controller == null) {
                return false;
            }
        }
        if (controller == null) {
            for (i = 0; i < this.previous.length; ++i) {
                if (this.previous[i] == null) continue;
                result = true;
                this.previous[i] = null;
            }
            return result;
        }
        PrsStream parseStream = ((SimpleLPGParseController)controller).getParser().getParseStream();
        ArrayList tokens = parseStream.getTokens();
        char[] chars = parseStream.getInputChars();
        IParseController previousController = (IParseController)this.previous[0];
        ArrayList previousTokens = (ArrayList)this.previous[1];
        char[] previousChars = (char[])this.previous[2];
        this.previous[0] = controller;
        this.previous[1] = tokens;
        this.previous[2] = chars;
        if (previousController != controller) {
            return true;
        }
        if (previousTokens.size() != tokens.size()) {
            return true;
        }
        for (int i2 = 0; i2 < previousTokens.size() - 1; ++i2) {
            IToken previousToken = (IToken)previousTokens.get(i2);
            IToken token = (IToken)tokens.get(i2);
            if (previousToken.getKind() != token.getKind()) {
                return true;
            }
            int previousStart = previousToken.getStartOffset();
            int previousEnd = previousToken.getEndOffset();
            int start = token.getStartOffset();
            int end = token.getEndOffset();
            if (previousEnd - previousStart != end - start) {
                return true;
            }
            for (int j = 0; j < previousEnd - previousStart + 1; ++j) {
                if (previousStart + j >= previousChars.length || start + j >= chars.length || previousChars.length == 0 || previousChars[previousStart + j] == chars[start + j]) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void sendVisitorToAST(Object var1);

    protected class TreeSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            TreeItem ti = (TreeItem)e.item;
            Object data = ti.getData();
            if (data == null) {
                System.out.println("Wiget selected for outline item with no node; returning");
                return;
            }
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ITextEditor textEditor = (ITextEditor)activeEditor;
            ISourcePositionLocator nodeLocator = OutlinerBase.this.fParseController.getNodeLocator();
            int startOffset = 0;
            int endOffset = 0;
            try {
                startOffset = nodeLocator.getStartOffset(data);
                endOffset = nodeLocator.getEndOffset(data);
            }
            catch (ClassCastException x) {
                System.err.println("OutlinerBase.TreeSelectionListener.wigetSelected:  ClassCastException trying to treat event data as AST node type");
                return;
            }
            textEditor.selectAndReveal(startOffset, endOffset - startOffset + 1);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

