/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.ui.explorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.imp.editor.EditorUtility;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class OpenActionUtil {
    private OpenActionUtil() {
    }

    public static void open(Object element) throws JavaModelException, PartInitException {
        OpenActionUtil.open(element, true);
    }

    public static void open(Object element, boolean activate) throws PartInitException {
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (element instanceof ISourceEntity) {
            EditorUtility.revealInEditor(part, (ISourceEntity)element);
        }
    }

    public static List filterResolveResults(ISourceEntity[] codeResolveResults) {
        int nResults = codeResolveResults.length;
        ArrayList<ISourceEntity> refs = new ArrayList<ISourceEntity>(nResults);
        for (int i = 0; i < nResults; ++i) {
            if (!(codeResolveResults[i] instanceof ISourceReference)) continue;
            refs.add(codeResolveResults[i]);
        }
        return refs;
    }

    public static ISourceEntity selectJavaElement(ISourceEntity[] elements, Shell shell, String title, String message) {
        Object[] selection;
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = JavaElementLabelProvider.SHOW_DEFAULT | 0x400 | 0x40;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            for (Object current : selection) {
                if (!(current instanceof ISourceEntity)) continue;
                return (ISourceEntity)current;
            }
        }
        return null;
    }
}

