/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.ui.explorer;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.ui.actions.OpenProjectAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.ide.IDEActionFactory;

public class ProjectActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private OpenProjectAction fOpenAction;
    private CloseResourceAction fCloseAction;

    public void updateActionBars() {
        ActionContext context = this.getContext();
        super.updateActionBars();
    }

    public ProjectActionGroup(IViewPart part) {
        this.fSite = part.getSite();
        Shell shell = this.fSite.getShell();
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fCloseAction = new CloseResourceAction(shell);
        this.fCloseAction.setActionDefinitionId("org.eclipse.ui.project.closeProject");
        System.out.println("CREATING IMP CloseUnrelatedProjectsAction(Shell)");
        this.fOpenAction = new OpenProjectAction(this.fSite);
        this.fOpenAction.setActionDefinitionId("org.eclipse.ui.project.openProject");
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection s = (IStructuredSelection)selection;
            this.fOpenAction.selectionChanged(s);
            this.fCloseAction.selectionChanged(s);
        }
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.fCloseAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.fCloseAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.fOpenAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.fOpenAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.fOpenAction);
        }
        if (this.fCloseAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.fCloseAction);
        }
    }

    private boolean areOnlyProjectsSelected(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object obj : selection) {
            if (!(obj instanceof IAdaptable) || ((IAdaptable)obj).getAdapter(IProject.class) != null) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fCloseAction);
        super.dispose();
    }
}

