/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.ui.explorer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.imp.core.IMPMessages;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.ISourceFolder;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private final long LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private IStatusLineManager fStatusLineManager;

    public StatusBarUpdater(IStatusLineManager statusLineManager) {
        this.fStatusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String statusBarMessage = this.formatMessage(event.getSelection());
        this.fStatusLineManager.setMessage(statusBarMessage);
    }

    protected String formatMessage(ISelection sel) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IWorkbenchAdapter wbadapter;
            IStructuredSelection selection = (IStructuredSelection)sel;
            int nElements = selection.size();
            if (nElements > 1) {
                return IMPMessages.format(IMPMessages.StatusBarUpdater_num_elements_selected, String.valueOf(nElements));
            }
            Object elem = selection.getFirstElement();
            if (elem instanceof ISourceProject) {
                return ((ISourceProject)elem).getRawProject().getName();
            }
            if (elem instanceof ISourceFolder) {
                return ((ISourceFolder)elem).getName();
            }
            if (elem instanceof ICompilationUnit) {
                return ((ICompilationUnit)elem).getName();
            }
            if (elem instanceof IJavaElement) {
                return this.formatJavaElementMessage((IJavaElement)elem);
            }
            if (elem instanceof IResource) {
                return this.formatResourceMessage((IResource)elem);
            }
            if (elem instanceof ClassPathContainer) {
                ClassPathContainer container = (ClassPathContainer)elem;
                return this.getLabel(container) + JavaElementLabels.CONCAT_STRING + container.getJavaProject().getElementName();
            }
            if (elem instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)elem).getAdapter(IWorkbenchAdapter.class)) != null) {
                return wbadapter.getLabel(elem);
            }
        }
        return "";
    }

    public String getLabel(ClassPathContainer cpc) {
        if (cpc != null && cpc instanceof IClasspathContainer) {
            return ((IClasspathContainer)cpc).getDescription();
        }
        return PackagesMessages.ClassPathContainer_unknown_label;
    }

    private String formatJavaElementMessage(IJavaElement element) {
        return JavaElementLabels.getElementLabel((IJavaElement)element, (long)this.LABEL_FLAGS);
    }

    private String formatResourceMessage(IResource element) {
        IContainer parent = element.getParent();
        if (parent != null && parent.getType() != 8) {
            return element.getName() + JavaElementLabels.CONCAT_STRING + parent.getFullPath().makeRelative().toString();
        }
        return element.getName();
    }
}

