/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.imp.utils.HTMLPrinter;
import org.eclipse.imp.utils.IPositionPredicate;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.AnnotationBag;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static String formatAnnotationList(List annotations) {
        if (annotations != null) {
            if (annotations.size() == 1) {
                Annotation annotation = (Annotation)annotations.get(0);
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return HTMLPrinter.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                for (Annotation annotation : annotations) {
                    String message = annotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return HTMLPrinter.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return HTMLPrinter.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    public static IAnnotationModel getAnnotationModel(ISourceViewer viewer) {
        return viewer.getAnnotationModel();
    }

    public static boolean includeAnnotation(Annotation annotation, Position position, HashMap messagesAtPosition) {
        return true;
    }

    public static List getAnnotations(ISourceViewer viewer, IPositionPredicate posPred) {
        IAnnotationModel model = AnnotationUtils.getAnnotationModel(viewer);
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        HashMap messagesAtPosition = new HashMap();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation2 = (Annotation)iterator.next();
            Position position = model.getPosition(annotation2);
            if (annotation2.getType().equals("org.eclipse.ui.workbench.texteditor.quickdiffUnchanged") || position == null || !posPred.matchPosition(position)) continue;
            if (annotation2 instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)annotation2;
                for (Annotation annotation2 : bag) {
                    position = model.getPosition(annotation2);
                    if (position == null || !AnnotationUtils.includeAnnotation(annotation2, position, messagesAtPosition)) continue;
                    annotations.add(annotation2);
                }
                continue;
            }
            if (!AnnotationUtils.includeAnnotation(annotation2, position, messagesAtPosition)) continue;
            annotations.add(annotation2);
        }
        return annotations;
    }

    public static List getAnnotationsForLine(ISourceViewer viewer, final int line) {
        final IDocument document = viewer.getDocument();
        IPositionPredicate posPred = new IPositionPredicate(){

            public boolean matchPosition(Position p) {
                return AnnotationUtils.offsetIsAtLine(p, document, line);
            }
        };
        return AnnotationUtils.getAnnotations(viewer, posPred);
    }

    public static List getAnnotationsForOffset(ISourceViewer viewer, final int offset) {
        IPositionPredicate posPred = new IPositionPredicate(){

            public boolean matchPosition(Position p) {
                return offset >= p.offset && offset < p.offset + p.length;
            }
        };
        return AnnotationUtils.getAnnotations(viewer, posPred);
    }

    public static boolean offsetIsAtLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int posLine = document.getLineOfOffset(position.getOffset());
                return line == posLine;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }
}

