/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.imp.editor.internal.ToggleBreakpointsAdapter;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;

public class BreakpointUtils {
    public static void resetJavaBreakpoints(IFile origSrcFile) {
        int i;
        IFile javaFile = ToggleBreakpointsAdapter.javaFileForRootSourceFile(origSrcFile);
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        try {
            IMarker[] markers = origSrcFile.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 2);
            for (i = 0; i < markers.length; ++i) {
                Integer num = (Integer)markers[i].getAttribute("lineNumber");
                if (!ToggleBreakpointsAdapter.validateLineNumber(origSrcFile, num)) continue;
                lineNumbers.add(num);
            }
        }
        catch (CoreException e) {
            System.err.println((Object)e);
        }
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        for (i = 0; i < breakpoints.length; ++i) {
            IResource res = breakpoints[i].getMarker().getResource();
            if (!res.equals(origSrcFile)) continue;
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoints[i], true);
                continue;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        try {
            for (Integer origSrcLineNumber : lineNumbers) {
                String typeName = ToggleBreakpointsAdapter.getTypeName(origSrcFile);
                HashMap bkptAttributes = new HashMap();
                IJavaStratumLineBreakpoint bkpt = JDIDebugModel.createStratumBreakpoint((IResource)origSrcFile, (String)"x10", (String)origSrcFile.getName(), null, null, (int)origSrcLineNumber, (int)-1, (int)-1, (int)0, (boolean)true, bkptAttributes);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IJavaLineBreakpoint lineBreakpointExists(IResource resource, String typeName, int lineNumber) throws CoreException {
        String modelId = JDIDebugModel.getPluginIdentifier();
        String markerType = "org.eclipse.jdt.debug.javaStratumLineBreakpointMarker";
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        for (int i = 0; i < breakpoints.length; ++i) {
            IJavaLineBreakpoint breakpoint;
            IMarker marker;
            if (!(breakpoints[i] instanceof IJavaLineBreakpoint) || (marker = (breakpoint = (IJavaLineBreakpoint)breakpoints[i]).getMarker()) == null || !marker.exists() || !marker.getType().equals(markerType)) continue;
            String breakpointTypeName = breakpoint.getTypeName();
            if (breakpoint.getLineNumber() != lineNumber || !resource.equals(marker.getResource())) continue;
            return breakpoint;
        }
        return null;
    }
}

