/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.utils.ExtensionException;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFactory {
    public static ILanguageService createServiceExtension(Language language, String extensionPointID) throws ExtensionException {
        return ExtensionFactory.createServiceExtensionForPlugin(language, "org.eclipse.imp.runtime", extensionPointID);
    }

    public static Set<ILanguageService> createServiceExtensionSet(Language language, String extensionPointID) throws ExtensionException {
        return ExtensionFactory.createServiceExtensionSetForPlugin(language, "org.eclipse.imp.runtime", extensionPointID);
    }

    public static String retrieveLanguageIdFromPlugin(String pluginID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.imp.runtime", RuntimePlugin.LANGUAGE_DESCRIPTOR);
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        for (int i = 0; i < configElements.length; ++i) {
            IContributor contrib = configElements[i].getContributor();
            if (!contrib.getName().equals(pluginID)) continue;
            return configElements[i].getAttribute("language");
        }
        return null;
    }

    public static ILanguageService createServiceExtensionForPlugin(Language language, String pluginID, String extensionPointId, String elementName) throws ExtensionException {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pluginID, extensionPointId);
        if (extensionPoint == null) {
            throw new ExtensionException("No such language service extension point defined: " + pluginID + "." + extensionPointId);
        }
        ILanguageService service = ExtensionFactory.getLanguageServiceForElement(extensionPoint, language.getName(), elementName);
        if (service == null && ExtensionFactory.languageIsDerived(language)) {
            service = ExtensionFactory.createServiceExtensionForPlugin(LanguageRegistry.findLanguage(language.getDerivedFrom()), pluginID, extensionPointId, elementName);
        }
        return service;
    }

    private static boolean languageIsDerived(Language language) {
        boolean hasParent = language.getDerivedFrom() != null && LanguageRegistry.findLanguage(language.getDerivedFrom()) != null;
        return hasParent;
    }

    public static ILanguageService createServiceExtensionForPlugin(Language language, String pluginID, String extensionPointId) throws ExtensionException {
        return ExtensionFactory.createServiceExtensionForPlugin(language, pluginID, extensionPointId, "class");
    }

    public static Set<ILanguageService> createServiceExtensionSetForPlugin(Language language, String pluginID, String extensionPointId) throws ExtensionException {
        ILanguageService baseServiceImpl;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pluginID, extensionPointId);
        if (extensionPoint == null) {
            throw new ExtensionException("No such language service extension point defined: " + pluginID + "." + extensionPointId);
        }
        Set<ILanguageService> services = ExtensionFactory.getLanguageServiceSet(extensionPoint, language.getName());
        if (services.isEmpty() && ExtensionFactory.languageIsDerived(language) && (baseServiceImpl = ExtensionFactory.createServiceExtensionForPlugin(LanguageRegistry.findLanguage(language.getDerivedFrom()), pluginID, extensionPointId)) != null) {
            services.add(baseServiceImpl);
        }
        return services;
    }

    public static boolean languageServiceExists(String pluginID, String extensionPointID, Language language) {
        if (language == null) {
            return false;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pluginID, extensionPointID);
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        String lowerLang = language.getName().toLowerCase();
        if (elements != null) {
            for (int n = 0; n < elements.length; ++n) {
                String attrValue;
                IConfigurationElement element = elements[n];
                Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
                if (bundle == null || (attrValue = element.getAttribute("language")) == null || !lowerLang.equals(attrValue.toLowerCase())) continue;
                return true;
            }
        }
        if (ExtensionFactory.languageIsDerived(language)) {
            return ExtensionFactory.languageServiceExists(pluginID, extensionPointID, LanguageRegistry.findLanguage(language.getDerivedFrom()));
        }
        return false;
    }

    private static Set<ILanguageService> getLanguageServiceSet(IExtensionPoint extensionPoint, String language) throws ExtensionException {
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        HashSet<ILanguageService> result = new HashSet<ILanguageService>();
        if (elements != null) {
            for (int n = 0; n < elements.length; ++n) {
                IConfigurationElement element = elements[n];
                ILanguageService service = ExtensionFactory.loadLanguageService(extensionPoint, language, "class", element);
                if (service == null) continue;
                result.add(service);
            }
        }
        return result;
    }

    private static ILanguageService getLanguageServiceForElement(IExtensionPoint extensionPoint, String language, String elementName) throws ExtensionException {
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        if (elements != null) {
            for (int n = 0; n < elements.length; ++n) {
                IConfigurationElement element = elements[n];
                ILanguageService service = ExtensionFactory.loadLanguageService(extensionPoint, language, elementName, element);
                if (service == null) continue;
                return service;
            }
        }
        return null;
    }

    private static ILanguageService loadLanguageService(IExtensionPoint extensionPoint, String language, String elementName, IConfigurationElement element) throws ExtensionException {
        String attrValue;
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
        String lowerLang = language.toLowerCase();
        if (bundle != null && (attrValue = element.getAttribute("language")) != null && lowerLang.equals(attrValue.toLowerCase())) {
            try {
                return (ILanguageService)element.createExecutableExtension(elementName);
            }
            catch (ClassCastException e) {
                throw new ExtensionException("Extension does not point to a class that implements an ILanguageService:" + element, e);
            }
            catch (IncompatibleClassChangeError e) {
                throw new ExtensionException("Unable to instantiate implementation of " + extensionPoint.getLabel() + " plugin for language '" + language + "' because some class in the plugin is incompatible (out-of-date)", e);
            }
            catch (CoreException e) {
                throw new ExtensionException("Unable to instantiate implementation of " + extensionPoint.getLabel() + " plugin for language '" + language + "' because of the following low level exception: " + e.getStatus().getException(), e);
            }
            catch (NoClassDefFoundError e) {
                throw new ExtensionException("Unable to instantiate implementation of " + extensionPoint.getLabel() + " plugin for language '" + language + "' because it may not have a public zero argument constructor, or some class referenced by the plugin could not be found in the class path.", e);
            }
        }
        return null;
    }

    public static URL createResourceURL(String language, IExtensionPoint extensionPoint, String label) {
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        String lowerLabel = label.toLowerCase();
        String lowerLang = language.toLowerCase();
        if (elements != null) {
            for (int n = 0; n < elements.length; ++n) {
                String attrValue;
                IConfigurationElement element = elements[n];
                Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
                if (bundle == null || (attrValue = element.getAttribute("language")) == null || !lowerLang.equals(attrValue.toLowerCase())) continue;
                String resourceName = element.getAttribute(lowerLabel);
                return bundle.getResource(resourceName);
            }
        }
        return null;
    }
}

