/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.wizards;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.wizards.fields.DialogField;
import org.eclipse.imp.wizards.fields.IDialogFieldListener;
import org.eclipse.imp.wizards.fields.IStringButtonAdapter;
import org.eclipse.imp.wizards.fields.LayoutUtil;
import org.eclipse.imp.wizards.fields.SelectionButtonDialogField;
import org.eclipse.imp.wizards.fields.StringButtonDialogField;
import org.eclipse.imp.wizards.fields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NewProjectWizardFirstPage
extends WizardPage {
    private NameGroup fNameGroup;
    private LocationGroup fLocationGroup;
    private LayoutGroup fLayoutGroup;
    private Validator fValidator;
    protected String fInitialName;

    public NewProjectWizardFirstPage(String pageName) {
        super(pageName);
    }

    public NewProjectWizardFirstPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public IPath getLocationPath() {
        return this.fLocationGroup.getLocation();
    }

    public boolean isInWorkspace() {
        String location = this.fLocationGroup.getLocation().toOSString();
        IPath projectPath = Path.fromOSString((String)location);
        return Platform.getLocation().isPrefixOf(projectPath);
    }

    public boolean getDetect() {
        return false;
    }

    public boolean isSrcBin() {
        return this.fLayoutGroup.isSrcBin();
    }

    public String getJRECompliance() {
        return "1.4";
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fLocationGroup = new LocationGroup(composite);
        this.fLayoutGroup = new LayoutGroup(composite);
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    public final class Validator
    implements Observer {
        public void update(Observable o, Object arg) {
            IStatus locationStatus;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String name = NewProjectWizardFirstPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                NewProjectWizardFirstPage.this.setErrorMessage(null);
                NewProjectWizardFirstPage.this.setMessage("Enter a project name");
                NewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                NewProjectWizardFirstPage.this.setErrorMessage(nameStatus.getMessage());
                NewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject handle = NewProjectWizardFirstPage.this.getProjectHandle();
            if (handle.exists()) {
                NewProjectWizardFirstPage.this.setErrorMessage("Project already exists");
                NewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            String location = NewProjectWizardFirstPage.this.fLocationGroup.getLocation().toOSString();
            if (location.length() == 0) {
                NewProjectWizardFirstPage.this.setErrorMessage(null);
                NewProjectWizardFirstPage.this.setMessage("Enter location");
                NewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                NewProjectWizardFirstPage.this.setErrorMessage("Invalid directory");
                NewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (!NewProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && Platform.getLocation().isPrefixOf(projectPath)) {
                NewProjectWizardFirstPage.this.setErrorMessage("Cannot create in workspace");
                NewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!NewProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && !(locationStatus = workspace.validateProjectLocation(handle, projectPath)).isOK()) {
                NewProjectWizardFirstPage.this.setErrorMessage(locationStatus.getMessage());
                NewProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            NewProjectWizardFirstPage.this.setPageComplete(true);
            NewProjectWizardFirstPage.this.setErrorMessage(null);
            NewProjectWizardFirstPage.this.setMessage(null);
        }
    }

    public final class LayoutGroup
    implements Observer,
    SelectionListener {
        private final SelectionButtonDialogField fStdRadio;
        private final SelectionButtonDialogField fSrcBinRadio;
        private final Group fGroup;
        private final Link fPreferenceLink;

        public LayoutGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)NewProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText("Project layout");
            this.fStdRadio = new SelectionButtonDialogField(16);
            this.fStdRadio.setLabelText("&Use project folder as root for sources and class files");
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText("&Create separate folders for sources and class files");
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fStdRadio.getSelectionButton(null));
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText("<a>Configure d&efault...</a>");
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 3, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            boolean useSrcBin = true;
            this.fSrcBinRadio.setSelection(useSrcBin);
            this.fStdRadio.setSelection(!useSrcBin);
        }

        public void update(Observable o, Object arg) {
            boolean detect = false;
            this.fStdRadio.setEnabled(true);
            this.fSrcBinRadio.setEnabled(true);
            this.fPreferenceLink.setEnabled(true);
            this.fGroup.setEnabled(true);
        }

        public boolean isSrcBin() {
            return this.fSrcBinRadio.isSelected();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String id = "org.eclipse.jdt.ui.preferences.BuildPathPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)NewProjectWizardFirstPage.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
        }
    }

    public final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio;
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;

        public LocationGroup(Composite composite) {
            int numColumns = 3;
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)NewProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText("Project Location:");
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(this);
            this.fWorkspaceRadio.setLabelText("Workspace");
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setLabelText("External");
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText("Location");
            this.fLocation.setButtonLabel("Browse...");
            this.fExternalRadio.attachDialogField(this.fLocation);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        public void update(Observable o, Object arg) {
            if (this.isInWorkspace()) {
                this.fLocation.setText(this.getDefaultPath(NewProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            DirectoryDialog dialog = new DirectoryDialog(NewProjectWizardFirstPage.this.getShell());
            dialog.setMessage("???");
            String directoryName = this.fLocation.getText().trim();
            if (directoryName.length() == 0) {
                // empty if block
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLocation.setText(selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fWorkspaceRadio) {
                boolean checked = this.fWorkspaceRadio.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(NewProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }
    }

    public final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)NewProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText("Name:");
            this.fNameField.setDialogFieldListener(this);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(NewProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }
}

