/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.actions;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class EnableDocBuilder
implements IWorkbenchWindowActionDelegate {
    private IProject fProject;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        try {
            IProjectDescription projDesc = this.fProject.getDescription();
            ICommand[] buildCmds = projDesc.getBuildSpec();
            for (int i = 0; i < buildCmds.length; ++i) {
                if (!buildCmds[i].getBuilderName().equals("org.eclipse.imp.lpg.runtime.docBuilder")) continue;
                return;
            }
            ICommand compilerCmd = projDesc.newCommand();
            compilerCmd.setBuilderName("org.eclipse.imp.lpg.runtime.docBuilder");
            ICommand[] newCmds = new ICommand[buildCmds.length + 1];
            System.arraycopy(buildCmds, 0, newCmds, 0, buildCmds.length);
            newCmds[buildCmds.length] = compilerCmd;
            projDesc.setBuildSpec(newCmds);
            this.fProject.setDescription(projDesc, null);
        }
        catch (CoreException e) {
            LPGRuntimePlugin.getInstance().logException("Error adding LPG Doc Builder to project description", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object first = ss.getFirstElement();
            if (first instanceof IProject) {
                this.fProject = (IProject)first;
            } else if (first instanceof IJavaProject) {
                this.fProject = ((IJavaProject)first).getProject();
            }
        }
    }
}

