/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.lpg.actions.LanguageActionContributor;
import org.eclipse.imp.lpg.parser.ASTUtils;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.lpg.views.GrammarInteractionView;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseNonTerminalAction
extends TextEditorAction
implements GrammarInteractionView.InputHandler {
    private final IFile fGrammarFile;
    private final LPGParser.ASTNode fNode;
    private final LPGParser.JikesPG fRoot;
    private LPGParser.nonTerm fNonTerm;
    private Set<LPGParser.nonTerm> fReachable;

    public ParseNonTerminalAction(UniversalEditor editor) {
        super(LanguageActionContributor.ResBundle, "parseNonTerminal.", (ITextEditor)editor);
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.fGrammarFile = fileInput.getFile();
            this.fRoot = this.getAST(editor);
            this.fNode = this.findNode(editor);
        } else {
            this.fGrammarFile = null;
            this.fRoot = null;
            this.fNode = null;
        }
    }

    public void run() {
        Object nt;
        UniversalEditor editor = (UniversalEditor)this.getTextEditor();
        IParseController parseController = editor.getParseController();
        this.dumpSymbolTable();
        if (this.fNode instanceof LPGParser.symWithAttrs1) {
            LPGParser.symWithAttrs1 sym = (LPGParser.symWithAttrs1)this.fNode;
            nt = ASTUtils.findDefOf(sym, this.fRoot, parseController);
        } else if (this.fNode instanceof LPGParser.IASTNodeToken) {
            LPGParser.IASTNodeToken tok = (LPGParser.IASTNodeToken)((Object)this.fNode);
            nt = ASTUtils.findDefOf(tok, this.fRoot, parseController);
        } else {
            nt = this.fNode;
        }
        if (!(nt instanceof LPGParser.nonTerm)) {
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Error", (String)"Can only parse sentence for a non-terminal.");
            return;
        }
        this.fNonTerm = (LPGParser.nonTerm)nt;
        this.collectGrammarSubset();
        this.generateParser();
        this.loadParser();
        GrammarInteractionView.getDefault().addInputListener(this);
    }

    private void dumpSymbolTable() {
        LPGParser.SymbolTable st = this.fRoot.symbolTable;
        List<String> allMacros = st.allSymbolsOfType(LPGParser.defineSpec.class);
        List<String> allTerminals = st.allSymbolsOfType(LPGParser.terminal.class);
        List<String> allNonTerminals = st.allSymbolsOfType(LPGParser.nonTerm.class);
        for (String sym : allMacros) {
            System.out.println("Macro " + sym + " => " + st.lookup(sym));
        }
        for (String sym : allTerminals) {
            System.out.println("Terminal " + sym + " => " + st.lookup(sym));
        }
        for (String sym : allNonTerminals) {
            System.out.println("Non-terminal " + sym + " => " + st.lookup(sym));
        }
    }

    private void collectGrammarSubset() {
        LPGParser.SymbolTable symbolTable = this.fRoot.symbolTable;
        Stack<LPGParser.nonTerm> workList = new Stack<LPGParser.nonTerm>();
        this.fReachable = new HashSet<LPGParser.nonTerm>();
        workList.push(this.fNonTerm);
        while (!workList.empty()) {
            LPGParser.nonTerm nt = (LPGParser.nonTerm)workList.pop();
            LPGParser.ruleList rules = nt.getruleList();
            for (int i = 0; i < rules.size(); ++i) {
                LPGParser.rule r = rules.getruleAt(i);
                LPGParser.symWithAttrsList syms = r.getsymWithAttrsList();
                for (int j = 0; j < syms.size(); ++j) {
                    LPGParser.IsymWithAttrs sym = syms.getsymWithAttrsAt(j);
                    LPGParser.ASTNode node = symbolTable.lookup(sym.toString());
                    if (!(node instanceof LPGParser.nonTerm) || this.fReachable.contains(node)) continue;
                    LPGParser.nonTerm thisNT = (LPGParser.nonTerm)node;
                    this.fReachable.add(thisNT);
                    workList.add(thisNT);
                }
            }
        }
        this.dumpNonTerms(this.fReachable, "Reachable: ");
    }

    private void dumpNonTerms(Set<LPGParser.nonTerm> reachable, String headerMsg) {
        System.out.println(headerMsg);
        for (LPGParser.nonTerm nt : reachable) {
            System.out.println(nt);
        }
    }

    private void generateParser() {
        throw new IllegalArgumentException("Unimplemented");
    }

    private void loadParser() {
        throw new IllegalArgumentException("Unimplemented");
    }

    @Override
    public void handleInput(String line) {
        Object result = this.parseSentenceAs(this.fNonTerm, line);
        GrammarInteractionView.println(result.toString());
    }

    private Object parseSentenceAs(LPGParser.ASTNode node, String sentence) {
        throw new IllegalArgumentException("Unimplemented");
    }

    private static String stripAnnotations(String symbol) {
        String result = symbol;
        while (result.lastIndexOf(36) >= 0) {
            result = result.substring(0, result.lastIndexOf(36));
        }
        return result;
    }

    private LPGParser.JikesPG getAST(UniversalEditor editor) {
        IParseController parseController = editor.getParseController();
        return (LPGParser.JikesPG)parseController.getCurrentAst();
    }

    private LPGParser.ASTNode findNode(UniversalEditor editor) {
        Point sel = editor.getSelection();
        IParseController parseController = editor.getParseController();
        ISourcePositionLocator locator = parseController.getNodeLocator();
        return (LPGParser.ASTNode)locator.findNode((Object)this.fRoot, sel.x);
    }
}

