/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.lpg.actions.LanguageActionContributor;
import org.eclipse.imp.lpg.parser.ASTUtils;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowFollowSetAction
extends TextEditorAction {
    private final IFile fGrammarFile;
    private final LPGParser.ASTNode fNode;
    private final LPGParser.JikesPG fRoot;
    private LPGParser.nonTerm fNonTerm;
    private Set<LPGParser.IASTNodeToken> fFollowSet;
    private Set<LPGParser.nonTerm> fEpsilonSet;

    public ShowFollowSetAction(UniversalEditor editor) {
        super(LanguageActionContributor.ResBundle, "showFollowSet.", (ITextEditor)editor);
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.fGrammarFile = fileInput.getFile();
            this.fRoot = this.getAST(editor);
            this.fNode = this.findNode(editor);
        } else {
            this.fGrammarFile = null;
            this.fRoot = null;
            this.fNode = null;
        }
    }

    public void run() {
        Object nt;
        UniversalEditor editor = (UniversalEditor)this.getTextEditor();
        IParseController parseController = editor.getParseController();
        if (this.fNode instanceof LPGParser.symWithAttrs1) {
            LPGParser.symWithAttrs1 sym = (LPGParser.symWithAttrs1)this.fNode;
            nt = ASTUtils.findDefOf(sym, this.fRoot, parseController);
        } else if (this.fNode instanceof LPGParser.IASTNodeToken) {
            LPGParser.IASTNodeToken tok = (LPGParser.IASTNodeToken)((Object)this.fNode);
            nt = ASTUtils.findDefOf(tok, this.fRoot, parseController);
        } else {
            nt = this.fNode;
        }
        if (!(nt instanceof LPGParser.nonTerm)) {
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Error", (String)"Can only show follow-set of a non-terminal.");
            return;
        }
        this.fNonTerm = (LPGParser.nonTerm)nt;
        this.collectFollowSet();
        StringBuffer buff = new StringBuffer();
        buff.append("BOGUS BOGUS BOGUS!\n");
        for (LPGParser.IASTNodeToken tok : this.fFollowSet) {
            buff.append(tok.toString()).append('\n');
        }
        MessageDialog.openInformation((Shell)editor.getSite().getShell(), (String)("Follow set of " + this.fNonTerm.getruleNameWithAttributes().getSYMBOL()), (String)buff.toString());
    }

    private void collectFollowSet() {
        LPGParser.SymbolTable symbolTable = this.fRoot.symbolTable;
        Stack<LPGParser.nonTerm> workList = new Stack<LPGParser.nonTerm>();
        HashSet<LPGParser.nonTerm> processed = new HashSet<LPGParser.nonTerm>();
        this.fFollowSet = new HashSet<LPGParser.IASTNodeToken>();
        HashSet<LPGParser.nonTerm> epsilonSet = new HashSet<LPGParser.nonTerm>();
        this.collectEpsilonSet();
        workList.push(this.fNonTerm);
        while (!workList.empty()) {
            LPGParser.nonTerm nt = (LPGParser.nonTerm)workList.pop();
            processed.add(nt);
            LPGParser.ruleList rules = nt.getruleList();
            for (int i = 0; i < rules.size(); ++i) {
                LPGParser.ASTNode node;
                LPGParser.rule r = rules.getruleAt(i);
                LPGParser.symWithAttrsList syms = r.getsymWithAttrsList();
                LPGParser.IsymWithAttrs firstSym = null;
                int symIdx = 0;
                do {
                    firstSym = syms.getsymWithAttrsAt(symIdx++);
                    node = symbolTable.lookup(firstSym.toString());
                    if (!firstSym.toString().equals("$empty")) continue;
                    epsilonSet.add(nt);
                } while (symIdx < syms.size() && firstSym.toString().equals("$empty") || epsilonSet.contains(node));
                if (node == null) {
                    if (firstSym.toString().equals("$empty")) continue;
                    this.fFollowSet.add(firstSym);
                    continue;
                }
                if (node instanceof LPGParser.terminal) {
                    if (this.fFollowSet.contains(node)) continue;
                    LPGParser.terminal thisTerm = (LPGParser.terminal)node;
                    this.fFollowSet.add(thisTerm.getterminal_symbol());
                    continue;
                }
                if (!(node instanceof LPGParser.nonTerm) || processed.contains(node)) continue;
                workList.add((LPGParser.nonTerm)node);
            }
        }
    }

    private Set<LPGParser.nonTerm> collectEpsilonSet() {
        this.fEpsilonSet = new HashSet<LPGParser.nonTerm>();
        LPGParser.SymbolTable symbolTable = this.fRoot.symbolTable;
        Stack<LPGParser.nonTerm> workList = new Stack<LPGParser.nonTerm>();
        List<LPGParser.nonTerm> allNonTerms = symbolTable.allDefsOfType(LPGParser.nonTerm.class);
        block0: for (LPGParser.nonTerm nt : allNonTerms) {
            LPGParser.ruleList rules = nt.getruleList();
            for (int i = 0; i < rules.size(); ++i) {
                LPGParser.IsymWithAttrs onlySym;
                LPGParser.rule r = rules.getruleAt(i);
                LPGParser.symWithAttrsList syms = r.getsymWithAttrsList();
                if (syms.size() != 1 || !(onlySym = syms.getsymWithAttrsAt(0)).toString().equals("$empty")) continue;
                this.fEpsilonSet.add(nt);
                continue block0;
            }
        }
        for (LPGParser.nonTerm nt : this.fEpsilonSet) {
            workList.add(nt);
        }
        while (!workList.empty()) {
            LPGParser.nonTerm nt = (LPGParser.nonTerm)workList.pop();
            LPGParser.ruleList rules = nt.getruleList();
            block4: for (int i = 0; i < rules.size(); ++i) {
                LPGParser.rule r = rules.getruleAt(i);
                LPGParser.symWithAttrsList syms = r.getsymWithAttrsList();
                for (int symIdx = 0; symIdx < syms.size(); ++symIdx) {
                    LPGParser.IsymWithAttrs sym = syms.getsymWithAttrsAt(symIdx);
                    LPGParser.ASTNode node = symbolTable.lookup(sym.toString());
                    if (!sym.toString().equals("$empty") && !this.fEpsilonSet.contains(node)) continue block4;
                }
                this.fEpsilonSet.add(nt);
                workList.push(nt);
            }
        }
        return this.fEpsilonSet;
    }

    private void dumpTerms(Set<LPGParser.IASTNodeToken> tokSet, String headerMsg) {
        System.out.println(headerMsg);
        for (LPGParser.IASTNodeToken tok : tokSet) {
            System.out.println(tok);
        }
    }

    private LPGParser.JikesPG getAST(UniversalEditor editor) {
        IParseController parseController = editor.getParseController();
        return (LPGParser.JikesPG)parseController.getCurrentAst();
    }

    private LPGParser.ASTNode findNode(UniversalEditor editor) {
        Point sel = editor.getSelection();
        IParseController parseController = editor.getParseController();
        ISourcePositionLocator locator = parseController.getNodeLocator();
        return (LPGParser.ASTNode)locator.findNode((Object)this.fRoot, sel.x);
    }
}

