/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.compare;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

class ASTLabelProvider
implements ILabelProvider {
    private Set fListeners = new HashSet();
    private static ImageRegistry sImageRegistry = LPGRuntimePlugin.getInstance().getImageRegistry();
    private static Image DEFAULT_IMAGE = sImageRegistry.get("default_ast");

    ASTLabelProvider() {
    }

    public Image getImage(Object element) {
        LPGParser.ASTNode n = (LPGParser.ASTNode)element;
        return ASTLabelProvider.getImageFor(n);
    }

    public static Image getImageFor(LPGParser.ASTNode n) {
        return DEFAULT_IMAGE;
    }

    public String getText(Object element) {
        LPGParser.ASTNode n = (LPGParser.ASTNode)element;
        return ASTLabelProvider.getLabelFor(n);
    }

    public static String getLabelFor(LPGParser.ASTNode n) {
        if (n == null) {
            return "<grammar file>";
        }
        if (n instanceof LPGParser.JikesPG) {
            return "grammar";
        }
        if (n instanceof LPGParser.option_specList) {
            return "options";
        }
        if (n instanceof LPGParser.AliasSeg) {
            return "aliases";
        }
        if (n instanceof LPGParser.DefineSeg) {
            return "defines";
        }
        if (n instanceof LPGParser.GlobalsSeg) {
            return "globals";
        }
        if (n instanceof LPGParser.HeadersSeg) {
            return "headers";
        }
        if (n instanceof LPGParser.ImportSeg) {
            return "imports";
        }
        if (n instanceof LPGParser.IncludeSeg) {
            return "includes";
        }
        if (n instanceof LPGParser.RulesSeg) {
            return "rules";
        }
        if (n instanceof LPGParser.TerminalsSeg) {
            return "terminals";
        }
        if (n instanceof LPGParser.defineSpec) {
            return ((LPGParser.defineSpec)n).getmacro_name_symbol().toString();
        }
        if (n instanceof LPGParser.nonTerm) {
            return ((LPGParser.nonTerm)n).getruleNameWithAttributes().getSYMBOL().toString();
        }
        if (n instanceof LPGParser.terminal) {
            return ((LPGParser.terminal)n).getterminal_symbol().toString();
        }
        return "<???>";
    }

    public void addListener(ILabelProviderListener listener) {
        this.fListeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.fListeners.remove(listener);
    }
}

