/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.compare;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.IViewerCreator;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.imp.lpg.compare.LPGStructureNode;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.lpg.parser.ParseController;
import org.eclipse.imp.utils.StreamUtils;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class StructureMergeViewerCreator
implements IViewerCreator {
    public Viewer createViewer(Composite parent, CompareConfiguration config) {
        return new JikesPGStructureDiffViewer(parent, config);
    }

    private static final class JikesPGStructureDiffViewer
    extends StructureDiffViewer {
        private IStructureCreator fStructureCreator;

        private JikesPGStructureDiffViewer(Composite parent, CompareConfiguration config) {
            super(parent, config);
            this.fStructureCreator = new JikesPGStructureCreator(config);
            this.setStructureCreator(this.fStructureCreator);
        }
    }

    private static class JikesPGStructureCreator
    implements IStructureCreator {
        private final CompareConfiguration fConfig;

        public JikesPGStructureCreator(CompareConfiguration config) {
            this.fConfig = config;
        }

        public String getName() {
            return "JikesPG Grammar Structure Compare";
        }

        public IStructureComparator getStructure(Object input) {
            try {
                IResource res = null;
                IDocument doc = CompareUI.getDocument((Object)input);
                if (!(input instanceof IResourceProvider)) {
                    return null;
                }
                res = ((IResourceProvider)input).getResource();
                if (!(input instanceof IStreamContentAccessor)) {
                    return null;
                }
                IStreamContentAccessor sca = (IStreamContentAccessor)input;
                if (doc == null) {
                    String contents = StreamUtils.readStreamContents((IStreamContentAccessor)sca);
                    char[] buffer = null;
                    if (contents != null) {
                        int n = contents.length();
                        buffer = new char[n];
                        contents.getChars(0, n, buffer, 0);
                        doc = new Document(contents);
                        CompareUI.registerDocument((Object)input, (IDocument)doc);
                    }
                }
                return new LPGStructureNode(this.parseStream(sca, res.getFullPath()), doc, 0, "root");
            }
            catch (IOException io) {
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return null;
        }

        private LPGParser.ASTNode parseStream(IStreamContentAccessor sca, IPath path) throws IOException, CoreException {
            String contents = StreamUtils.readStreamContents((IStreamContentAccessor)sca);
            return this.parseContents(contents, path);
        }

        private LPGParser.ASTNode parseContents(String contents, IPath path) {
            ParseController parser = new ParseController();
            return (LPGParser.ASTNode)parser.parse(contents, false, (IProgressMonitor)new NullProgressMonitor());
        }

        public IStructureComparator locate(Object path, Object input) {
            LPGStructureNode inputAST = (LPGStructureNode)((Object)input);
            return null;
        }

        public String getContents(Object node, boolean ignoreWhitespace) {
            LPGStructureNode wrapper = (LPGStructureNode)((Object)node);
            LPGParser.ASTNode astNode = wrapper.getASTNode();
            return astNode != null ? astNode.toString() : "";
        }

        public void save(IStructureComparator node, Object input) {
            if (node instanceof LPGStructureNode && input instanceof IEditableContent) {
                byte[] bytes;
                IDocument document = ((LPGStructureNode)node).getDocument();
                IEditableContent bca = (IEditableContent)input;
                String contents = document.get();
                String encoding = null;
                if (input instanceof IEncodedStreamContentAccessor) {
                    try {
                        encoding = ((IEncodedStreamContentAccessor)input).getCharset();
                    }
                    catch (CoreException e1) {
                        // empty catch block
                    }
                }
                if (encoding == null) {
                    encoding = ResourcesPlugin.getEncoding();
                }
                try {
                    bytes = contents.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    bytes = contents.getBytes();
                }
                bca.setContent(bytes);
            }
        }
    }
}

