/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.docBuilder;

import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import lpg.runtime.IToken;
import lpg.runtime.PrsStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.builder.BuilderBase;
import org.eclipse.imp.builder.BuilderUtils;
import org.eclipse.imp.builder.MarkerCreator;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.imp.lpg.parser.ASTUtils;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.lpg.parser.ParseController;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.runtime.PluginBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LPGDocBuilder
extends BuilderBase {
    public static final String BUILDER_ID = "org.eclipse.imp.lpg.runtime.docBuilder";
    public static final String PROBLEM_MARKER_ID = "org.eclipse.imp.lpg.runtime.docBuilder.problem";
    public static final String LANGUAGE_NAME = "LPG";
    public static final Language LANGUAGE = LanguageRegistry.findLanguage((String)"LPG");
    private LPGParser.JikesPG fASTRoot;
    private final String NL = System.getProperty("line.separator");

    protected PluginBase getPlugin() {
        return LPGRuntimePlugin.getInstance();
    }

    protected String getErrorMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getWarningMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getInfoMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected boolean isSourceFile(IFile file) {
        IPath path = file.getRawLocation();
        if (path == null) {
            return false;
        }
        String pathString = path.toString();
        if (pathString.indexOf("/bin/") != -1) {
            return false;
        }
        return LANGUAGE.hasExtension(path.getFileExtension());
    }

    protected boolean isNonRootSourceFile(IFile resource) {
        return false;
    }

    protected void collectDependencies(IFile file) {
        String fromPath = file.getFullPath().toString();
        this.getPlugin().writeInfoMsg("Collecting dependencies from ${LANG_NAME} file: " + file.getName());
    }

    protected boolean isOutputFolder(IResource resource) {
        return resource.getFullPath().lastSegment().equals("bin");
    }

    protected void compile(IFile file, IProgressMonitor monitor) {
        try {
            String fileName = file.getName();
            this.getPlugin().writeInfoMsg("Building documentation for LPG file: " + fileName);
            this.parseSourceFile(file, monitor);
            List<LPGParser.nonTerm> nonTerms = ASTUtils.getNonTerminals(this.fASTRoot);
            StringBuilder sb = new StringBuilder();
            PrsStream parseStream = this.fASTRoot.getEnvironment().getParseStream();
            HashMap<String, LPGParser.nonTerm> nonTermMap = new HashMap<String, LPGParser.nonTerm>();
            for (LPGParser.nonTerm nt : nonTerms) {
                nonTermMap.put(nt.getruleNameWithAttributes().getSYMBOL().toString(), nt);
            }
            TreeSet<LPGParser.nonTerm> sortedNonTerms = new TreeSet<LPGParser.nonTerm>(new Comparator<LPGParser.nonTerm>(){

                @Override
                public int compare(LPGParser.nonTerm o1, LPGParser.nonTerm o2) {
                    String n1 = o1.getruleNameWithAttributes().getSYMBOL().toString();
                    String n2 = o2.getruleNameWithAttributes().getSYMBOL().toString();
                    return n1.compareTo(n2);
                }
            });
            sortedNonTerms.addAll(nonTerms);
            this.generateDocHeader(sb, fileName);
            for (LPGParser.nonTerm nt : sortedNonTerms) {
                this.generateNonTermDoc(nt, sb, nonTermMap, parseStream);
            }
            this.generateDocFooter(sb);
            String htmlFileName = fileName.substring(0, fileName.lastIndexOf(46)) + ".html";
            IFile htmlFile = file.getParent().getFile((IPath)new Path(htmlFileName));
            StringBufferInputStream sbis = new StringBufferInputStream(sb.toString());
            if (htmlFile.exists()) {
                htmlFile.setContents((InputStream)sbis, 1, monitor);
            } else {
                htmlFile.create((InputStream)sbis, true, monitor);
            }
            this.doRefresh((IResource)file.getParent());
        }
        catch (Exception e) {
            this.getPlugin().logException(e.getMessage(), (Throwable)e);
        }
    }

    private void generateDocHeader(StringBuilder sb, String fileName) {
        sb.append("<html>");
        sb.append(this.NL);
        sb.append("<body>");
        sb.append(this.NL);
        sb.append("<h1>Syntax for ");
        sb.append(fileName);
        sb.append(" Language</h1>");
        sb.append(this.NL);
        sb.append("<hr>");
        sb.append(this.NL);
        IToken[] adjAfterOptions = this.fASTRoot.getoptions_segment().getRightIToken().getFollowingAdjuncts();
        for (int i = 0; i < adjAfterOptions.length; ++i) {
            String adjStr = adjAfterOptions[i].toString();
            if (!adjStr.startsWith("--**")) continue;
            String text = adjStr.substring(4);
            if (text.trim().length() == 0) {
                sb.append("<p>");
                sb.append(this.NL);
                continue;
            }
            sb.append(text);
        }
        sb.append("<hr>");
        sb.append(this.NL);
        sb.append("<table border=1 width=\"100%\" cellpadding=\"3\" cellspacing=\"0\">");
        sb.append(this.NL);
        String[] cols = new String[]{"Non-terminal", "Description", "Rules"};
        sb.append("    <thead><tr bgcolor=\"#ccccff\">");
        for (int i = 0; i < cols.length; ++i) {
            sb.append("<td><b>");
            sb.append(cols[i]);
            sb.append("</b></td>");
        }
        sb.append("</tr></thead>");
        sb.append(this.NL);
        sb.append("  <tbody>");
        sb.append(this.NL);
    }

    private void generateDocFooter(StringBuilder sb) {
        sb.append("  </tbody>");
        sb.append(this.NL);
        sb.append("</table>");
        sb.append(this.NL);
        sb.append("</body>");
        sb.append(this.NL);
        sb.append("</html>");
        sb.append(this.NL);
    }

    private void generateNonTermDoc(LPGParser.nonTerm nonTerm2, StringBuilder sb, Map<String, LPGParser.nonTerm> nonTermMap, PrsStream parseStream) {
        String ntName = nonTerm2.getruleNameWithAttributes().getSYMBOL().toString();
        String ntDoc = this.findNonTermDocComment(nonTerm2, parseStream);
        sb.append("  <tr>");
        sb.append(this.NL);
        sb.append("    <td width=\"10%\">");
        this.emitAnchor(ntName, "<b>" + ntName + "</b>", sb);
        sb.append(this.NL);
        sb.append("    </td>");
        sb.append(this.NL);
        sb.append("    <td width=\"50%\">");
        sb.append(this.NL);
        if (ntDoc != null) {
            sb.append("      ");
            sb.append(ntDoc);
            sb.append(this.NL);
        }
        sb.append("    </td>");
        sb.append(this.NL);
        sb.append("    <td width=\"40%\">");
        sb.append(this.NL);
        LPGParser.ruleList rules = nonTerm2.getruleList();
        for (int i = 0; i < rules.size(); ++i) {
            LPGParser.symWithAttrsList rhsSyms = rules.getruleAt(i).getsymWithAttrsList();
            sb.append("      <p>");
            for (int j = 0; j < rhsSyms.size(); ++j) {
                LPGParser.IsymWithAttrs sym = rhsSyms.getsymWithAttrsAt(j);
                if (j > 0) {
                    sb.append(' ');
                }
                if (sym instanceof LPGParser.symWithAttrs0) {
                    sb.append("%empty");
                    continue;
                }
                String symName = ((LPGParser.symWithAttrs1)sym).getSYMBOL().toString();
                if (nonTermMap.containsKey(symName)) {
                    this.emitRef(symName, symName, sb);
                    continue;
                }
                this.emitEscaped(symName, sb);
            }
            sb.append("</p>");
            sb.append(this.NL);
        }
        sb.append("    </td>");
        sb.append(this.NL);
        sb.append("  </tr>");
        sb.append(this.NL);
    }

    private void emitEscaped(String text, StringBuilder sb) {
        sb.append(text.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;"));
    }

    private void emitRef(String text, String ref, StringBuilder sb) {
        sb.append("<a href=\"#");
        sb.append(ref);
        sb.append("\">");
        sb.append(text);
        sb.append("</a>");
    }

    private void emitAnchor(String anchorName, String text, StringBuilder sb) {
        sb.append("<a name=\"");
        sb.append(anchorName);
        sb.append("\">");
        sb.append(text);
        sb.append("</a>");
    }

    private String findNonTermDocComment(LPGParser.nonTerm nonTerm2, PrsStream parseStream) {
        IToken[] precAdjuncts = parseStream.getPrecedingAdjuncts(nonTerm2.getLeftIToken().getTokenIndex());
        for (int i = 0; i < precAdjuncts.length; ++i) {
            String adjStr = precAdjuncts[i].toString();
            if (!adjStr.startsWith("--**")) continue;
            return adjStr.substring(4);
        }
        return null;
    }

    protected void parseSourceFile(IFile file, IProgressMonitor monitor) {
        try {
            ParseController parseController = new ParseController();
            MarkerCreator markerCreator = new MarkerCreator(file, (IParseController)parseController, PROBLEM_MARKER_ID);
            parseController.getAnnotationTypeInfo().addProblemMarkerType(this.getErrorMarkerID());
            ISourceProject sourceProject = ModelFactory.open((IProject)file.getProject());
            parseController.initialize(file.getProjectRelativePath(), sourceProject, (IMessageHandler)markerCreator);
            String contents = BuilderUtils.getFileContents((IFile)file);
            this.fASTRoot = (LPGParser.JikesPG)parseController.parse(contents, false, monitor);
        }
        catch (ModelFactory.ModelException e) {
            this.getPlugin().logException("Example builder returns without parsing due to a ModelException", (Throwable)e);
        }
    }
}

