/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.editor;

import java.util.HashMap;
import java.util.List;
import lpg.runtime.ILexStream;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.services.base.FolderBase;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldingUpdater
extends FolderBase {
    public void sendVisitorToAST(HashMap<Annotation, Position> newAnnotations, List<Annotation> annotations, Object ast) {
        LPGParser.ASTNode theAST = (LPGParser.ASTNode)ast;
        FoldingVisitor foldingVisitor = new FoldingVisitor();
        theAST.accept(foldingVisitor);
    }

    private class FoldingVisitor
    extends LPGParser.AbstractVisitor {
        private FoldingVisitor() {
        }

        public void unimplementedVisitor(String s) {
        }

        private void makeAnnotation(LPGParser.ASTNode n) {
            int start = n.getLeftIToken().getStartOffset();
            int len = n.getRightIToken().getEndOffset() - start + 1;
            if (len <= 0) {
                return;
            }
            ILexStream ls = n.getLeftIToken().getIPrsStream().getILexStream();
            while (start + len < ls.getStreamLength() && (ls.getCharValue(start + len) == ' ' || ls.getCharValue(start + len) == '\t')) {
                ++len;
            }
            if (start + len < ls.getStreamLength() && (ls.getCharValue(start + len) == '\n' || ls.getCharValue(start + len) == '\r')) {
                ++len;
            }
            FoldingUpdater.this.makeAnnotation(start, len);
        }

        public boolean visit(LPGParser.option_specList n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.AliasSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.DefineSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.ExportSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.GlobalsSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.HeadersSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.IdentifierSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.ImportSeg n) {
            this.makeAnnotation(n);
            return true;
        }

        public boolean visit(LPGParser.drop_command0 n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.drop_command1 n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.IncludeSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.KeywordsSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.NoticeSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.RulesSeg n) {
            this.makeAnnotation(n);
            return true;
        }

        public boolean visit(LPGParser.rule n) {
            LPGParser.action_segment optAction = n.getopt_action_segment();
            if (optAction != null) {
                ILexStream lexStream = optAction.getIToken().getIPrsStream().getILexStream();
                int start = optAction.getLeftIToken().getStartOffset();
                int len = optAction.getRightIToken().getEndOffset() - start + 3;
                while (Character.isWhitespace(lexStream.getCharValue(start - 1))) {
                    --start;
                    ++len;
                }
                while (Character.isWhitespace(lexStream.getCharValue(start + len - 1))) {
                    ++len;
                }
                FoldingUpdater.this.makeAnnotation(start, --len);
            }
            return false;
        }

        public boolean visit(LPGParser.TerminalsSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.TrailersSeg n) {
            this.makeAnnotation(n);
            return false;
        }

        public boolean visit(LPGParser.TypesSeg n) {
            this.makeAnnotation(n);
            return false;
        }
    }
}

