/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.editor;

import java.util.ArrayList;
import java.util.HashSet;
import lpg.runtime.IToken;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.ISourceFormatter;

public class LPGFormatter
implements ILanguageService,
ISourceFormatter {
    private int fIndentSize = 6;
    private String fIndentString;
    private boolean fIndentProducesToWidestNonTerm = false;

    public void formatterStarts(String initialIndentation) {
        this.fIndentSize = 4;
        StringBuffer buff = new StringBuffer(this.fIndentSize);
        for (int i = 0; i < this.fIndentSize; ++i) {
            buff.append(' ');
        }
        this.fIndentString = buff.toString();
        this.fIndentProducesToWidestNonTerm = false;
    }

    public String format(IParseController parseController, String content, boolean isLineStart, String indentation, int[] positions) {
        final StringBuffer fBuff = new StringBuffer();
        final HashSet fAdjunctTokens = new HashSet();
        final LPGParser.ASTNode[] fAdjunctNode = new LPGParser.ASTNode[1];
        final ArrayList fFollowingAdjuncts = new ArrayList();
        LPGParser.JikesPG root = (LPGParser.JikesPG)parseController.getCurrentAst();
        root.accept(new LPGParser.AbstractVisitor(){
            private int prodCount;
            private int prodIndent;

            public void unimplementedVisitor(String s) {
                System.out.println("Unhandled node type: " + s);
            }

            public boolean preVisit(LPGParser.ASTNode n) {
                IToken left = n.getLeftIToken();
                IToken[] precAdjuncts = left.getPrecedingAdjuncts();
                for (int i = 0; i < precAdjuncts.length; ++i) {
                    IToken adjunct = precAdjuncts[i];
                    if (!fAdjunctTokens.contains(adjunct)) {
                        fBuff.append(adjunct);
                        fBuff.append('\n');
                    }
                    fAdjunctTokens.add(adjunct);
                }
                if (fFollowingAdjuncts.size() == 0) {
                    IToken right = n.getRightIToken();
                    IToken[] follAdjuncts = right.getFollowingAdjuncts();
                    for (int i = 0; i < follAdjuncts.length; ++i) {
                        IToken adjunct = follAdjuncts[i];
                        if (fAdjunctTokens.contains(adjunct)) continue;
                        fFollowingAdjuncts.add(adjunct);
                        fAdjunctTokens.add(adjunct);
                    }
                    fAdjunctNode[0] = n;
                }
                return true;
            }

            public void postVisit(LPGParser.ASTNode n) {
                if (n == fAdjunctNode[0]) {
                    for (IToken adjunct : fFollowingAdjuncts) {
                        fBuff.append(adjunct);
                        fBuff.append('\n');
                    }
                    fFollowingAdjuncts.clear();
                }
            }

            public boolean visit(LPGParser.option_spec n) {
                fBuff.append("%options ");
                return true;
            }

            public boolean visit(LPGParser.optionList n) {
                for (int i = 0; i < n.size(); ++i) {
                    if (i > 0) {
                        fBuff.append(", ");
                    }
                    LPGParser.option opt = n.getoptionAt(i);
                    opt.accept(this);
                }
                return false;
            }

            public void endVisit(LPGParser.option_spec n) {
                fBuff.append('\n');
            }

            public boolean visit(LPGParser.option n) {
                fBuff.append(n.getSYMBOL());
                return true;
            }

            public boolean visit(LPGParser.option_value0 n) {
                fBuff.append("=" + n.getSYMBOL());
                return false;
            }

            public boolean visit(LPGParser.option_value1 n) {
                fBuff.append('(');
                LPGParser.SYMBOLList symList = n.getsymbol_list();
                for (int i = 0; i < symList.size(); ++i) {
                    if (i > 0) {
                        fBuff.append(',');
                    }
                    fBuff.append(symList.getSYMBOLAt(i));
                }
                fBuff.append(')');
                return false;
            }

            public boolean visit(LPGParser.NoticeSeg n) {
                fBuff.append("$Notice\n");
                return true;
            }

            public void endVisit(LPGParser.NoticeSeg n) {
                fBuff.append("$End\n\n");
            }

            public boolean visit(LPGParser.GlobalsSeg n) {
                fBuff.append("$Globals\n");
                return true;
            }

            public void endVisit(LPGParser.GlobalsSeg n) {
                fBuff.append("$End\n\n");
            }

            public boolean visit(LPGParser.HeadersSeg n) {
                fBuff.append("$Headers\n");
                return true;
            }

            public void endVisit(LPGParser.HeadersSeg n) {
                fBuff.append("$End\n\n");
            }

            public boolean visit(LPGParser.IdentifierSeg n) {
                fBuff.append("$Identifier\n");
                return true;
            }

            public void endVisit(LPGParser.IdentifierSeg n) {
                fBuff.append("$End\n\n");
            }

            public boolean visit(LPGParser.EofSeg n) {
                fBuff.append("$EOF\n");
                return true;
            }

            public void endVisit(LPGParser.EofSeg n) {
                fBuff.append("$End\n\n");
            }

            public boolean visit(LPGParser.terminal_symbol0 n) {
                fBuff.append(LPGFormatter.this.fIndentString);
                fBuff.append(n.getSYMBOL());
                fBuff.append('\n');
                return false;
            }

            public boolean visit(LPGParser.DefineSeg n) {
                fBuff.append("$Define\n");
                return true;
            }

            public void endVisit(LPGParser.DefineSeg n) {
                fBuff.append("$End\n\n");
            }

            public void endVisit(LPGParser.defineSpec n) {
                fBuff.append(LPGFormatter.this.fIndentString);
                fBuff.append(n.getmacro_name_symbol());
                fBuff.append(' ');
                fBuff.append(n.getmacro_segment());
                fBuff.append('\n');
            }

            public boolean visit(LPGParser.TerminalsSeg n) {
                fBuff.append("$Terminals\n");
                return true;
            }

            public void endVisit(LPGParser.TerminalsSeg n) {
                fBuff.append("$End\n\n");
            }

            public boolean visit(LPGParser.terminal n) {
                fBuff.append(LPGFormatter.this.fIndentString + n.getterminal_symbol());
                if (n.getoptTerminalAlias() != null) {
                    fBuff.append(" ::= " + n.getoptTerminalAlias().getname());
                }
                fBuff.append('\n');
                return false;
            }

            public boolean visit(LPGParser.StartSeg n) {
                fBuff.append("$Start\n");
                return true;
            }

            public void endVisit(LPGParser.StartSeg n) {
                fBuff.append("$End\n\n");
            }

            public boolean visit(LPGParser.start_symbol0 n) {
                fBuff.append(LPGFormatter.this.fIndentString);
                fBuff.append(n.getSYMBOL());
                fBuff.append('\n');
                return false;
            }

            public boolean visit(LPGParser.start_symbol1 n) {
                fBuff.append(n.getMACRO_NAME());
                return false;
            }

            public boolean visit(LPGParser.RulesSeg n) {
                fBuff.append("$Rules\n");
                if (LPGFormatter.this.fIndentProducesToWidestNonTerm) {
                    LPGParser.rules_segment rulesSegment = n.getrules_segment();
                    LPGParser.nonTermList nonTermList2 = rulesSegment.getnonTermList();
                    int maxLHSSymWid = 0;
                    for (int i = 0; i < nonTermList2.size(); ++i) {
                        int lhsSymWid = nonTermList2.getElementAt(i).getLeftIToken().toString().length();
                        if (lhsSymWid <= maxLHSSymWid) continue;
                        maxLHSSymWid = lhsSymWid;
                    }
                    this.prodIndent = LPGFormatter.this.fIndentSize + maxLHSSymWid + 1;
                }
                return true;
            }

            public void endVisit(LPGParser.RulesSeg n) {
                fBuff.append("$End\n");
            }

            public boolean visit(LPGParser.nonTerm n) {
                fBuff.append(LPGFormatter.this.fIndentString);
                fBuff.append(n.getruleNameWithAttributes().getSYMBOL());
                if (LPGFormatter.this.fIndentProducesToWidestNonTerm) {
                    for (int i = n.getruleNameWithAttributes().getSYMBOL().toString().length() + LPGFormatter.this.fIndentSize + 1; i <= this.prodIndent; ++i) {
                        fBuff.append(' ');
                    }
                } else {
                    fBuff.append(' ');
                }
                fBuff.append(n.getproduces());
                this.prodCount = 0;
                if (!LPGFormatter.this.fIndentProducesToWidestNonTerm) {
                    this.prodIndent = LPGFormatter.this.fIndentSize + n.getruleNameWithAttributes().getSYMBOL().toString().length() + 1;
                }
                return true;
            }

            public boolean visit(LPGParser.RuleName n) {
                fBuff.append(n.getSYMBOL());
                return true;
            }

            public void endVisit(LPGParser.nonTerm n) {
                fBuff.append('\n');
            }

            public boolean visit(LPGParser.rule n) {
                if (this.prodCount > 0) {
                    fBuff.append('\n');
                    for (int i = 0; i < this.prodIndent; ++i) {
                        fBuff.append(' ');
                    }
                    fBuff.append("|  ");
                }
                ++this.prodCount;
                return true;
            }

            public boolean visit(LPGParser.action_segment n) {
                fBuff.append(n.getBLOCK());
                fBuff.append('\n');
                return false;
            }

            public boolean visit(LPGParser.symWithAttrs0 n) {
                fBuff.append(' ');
                fBuff.append(n.getEMPTY_KEY());
                return false;
            }

            public boolean visit(LPGParser.symWithAttrs1 n) {
                fBuff.append(' ');
                fBuff.append(n.getSYMBOL());
                return false;
            }

            public boolean visit(LPGParser.symAttrs n) {
                fBuff.append(' ');
                fBuff.append(n.getMACRO_NAME());
                return false;
            }
        });
        return fBuff.toString();
    }

    public void formatterStops() {
    }
}

