/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.editor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.preferences.PreferencesService;
import org.eclipse.imp.services.ILabelProvider;
import org.eclipse.imp.utils.MarkerUtils;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class LPGLabelProvider
implements ILabelProvider {
    private Set<ILabelProviderListener> fListeners = new HashSet<ILabelProviderListener>();
    private static ImageRegistry sImageRegistry = LPGRuntimePlugin.getInstance().getImageRegistry();
    private static Image DEFAULT_IMAGE = sImageRegistry.get("default_ast");
    private static Image GRAMMAR_FILE_IMAGE = sImageRegistry.get("grammarfile");
    private static Image GRAMMAR_FILE_ERROR_IMAGE = sImageRegistry.get("grammarfile-error");
    private static Image GRAMMAR_FILE_WARNING_IMAGE = sImageRegistry.get("grammarfile-warning");

    public Image getImage(Object element) {
        if (element instanceof ISourceEntity) {
            ISourceEntity entity = (ISourceEntity)element;
            return this.getImageFor(entity.getResource());
        }
        if (element instanceof IResource) {
            return this.getImageFor((IResource)element);
        }
        LPGParser.ASTNode n = element instanceof ModelTreeNode ? (LPGParser.ASTNode)((ModelTreeNode)element).getASTNode() : (LPGParser.ASTNode)element;
        return LPGLabelProvider.getImageFor(n);
    }

    private Image getImageFor(IResource res) {
        if (res instanceof IFile) {
            IFile file = (IFile)res;
            PreferencesService preferencesService = LPGRuntimePlugin.getInstance().getPreferencesService();
            if (!preferencesService.getStringPreference("SourceFileExtensions").contains(file.getLocation().getFileExtension()) && !preferencesService.getStringPreference("IncludeFileExtensions").contains(file.getLocation().getFileExtension())) {
                return null;
            }
            int sev = MarkerUtils.getMaxProblemMarkerSeverity((IResource)file, (int)1);
            switch (sev) {
                case 2: {
                    return GRAMMAR_FILE_ERROR_IMAGE;
                }
                case 1: {
                    return GRAMMAR_FILE_WARNING_IMAGE;
                }
            }
            return GRAMMAR_FILE_IMAGE;
        }
        return null;
    }

    public static Image getImageFor(LPGParser.ASTNode n) {
        return DEFAULT_IMAGE;
    }

    public String getText(Object element) {
        LPGParser.ASTNode n = element instanceof ModelTreeNode ? (LPGParser.ASTNode)((ModelTreeNode)element).getASTNode() : (LPGParser.ASTNode)element;
        return LPGLabelProvider.getLabelFor(n);
    }

    public static String getLabelFor(LPGParser.ASTNode n) {
        if (n instanceof LPGParser.JikesPG) {
            return "grammar";
        }
        if (n instanceof LPGParser.option_specList) {
            return "options";
        }
        if (n instanceof LPGParser.AliasSeg) {
            return "aliases";
        }
        if (n instanceof LPGParser.DefineSeg) {
            return "defines";
        }
        if (n instanceof LPGParser.ExportSeg) {
            return "export";
        }
        if (n instanceof LPGParser.GlobalsSeg) {
            return "globals";
        }
        if (n instanceof LPGParser.HeadersSeg) {
            return "headers";
        }
        if (n instanceof LPGParser.IdentifierSeg) {
            return "identifiers";
        }
        if (n instanceof LPGParser.ImportSeg) {
            return "imports";
        }
        if (n instanceof LPGParser.IncludeSeg) {
            return "includes";
        }
        if (n instanceof LPGParser.JikesPG_itemList) {
            return "item list";
        }
        if (n instanceof LPGParser.KeywordsSeg) {
            return "keywords";
        }
        if (n instanceof LPGParser.NoticeSeg) {
            return "notice";
        }
        if (n instanceof LPGParser.StartSeg) {
            return "start symbol";
        }
        if (n instanceof LPGParser.RulesSeg) {
            return "rules";
        }
        if (n instanceof LPGParser.TerminalsSeg) {
            return "terminals";
        }
        if (n instanceof LPGParser.TrailersSeg) {
            return "trailers";
        }
        if (n instanceof LPGParser.TypesSeg) {
            return "types";
        }
        if (n instanceof LPGParser.option_spec) {
            return "option spec";
        }
        if (n instanceof LPGParser.optionList) {
            return "%option " + ((LPGParser.optionList)n).getoptionAt(0).getSYMBOL() + "...";
        }
        if (n instanceof LPGParser.nonTermList) {
            return "non-terminals";
        }
        if (n instanceof LPGParser.option) {
            LPGParser.option o = (LPGParser.option)n;
            return o.getSYMBOL().toString() + (o.getoption_value() != null ? o.getoption_value().toString() : "");
        }
        if (n instanceof LPGParser.defineSpecList) {
            return "defines";
        }
        if (n instanceof LPGParser.defineSpec) {
            return ((LPGParser.defineSpec)n).getmacro_name_symbol().toString();
        }
        if (n instanceof LPGParser.nonTerm) {
            return ((LPGParser.nonTerm)n).getruleNameWithAttributes().getSYMBOL().toString();
        }
        if (n instanceof LPGParser.terminal) {
            return ((LPGParser.terminal)n).getterminal_symbol().toString();
        }
        if (n instanceof LPGParser.include_segment) {
            return ((LPGParser.include_segment)n).getSYMBOL().toString();
        }
        if (n instanceof LPGParser.action_segmentList) {
            return "actions";
        }
        if (n instanceof LPGParser.action_segment) {
            return ((LPGParser.action_segment)n).getBLOCK().toString();
        }
        if (n instanceof LPGParser.terminalList) {
            return "terminals";
        }
        if (n instanceof LPGParser.start_symbol0) {
            return ((LPGParser.start_symbol0)n).getSYMBOL().toString();
        }
        if (n instanceof LPGParser.drop_commandList) {
            return "drop";
        }
        if (n instanceof LPGParser.drop_command0) {
            return "drop symbols";
        }
        if (n instanceof LPGParser.drop_command1) {
            return "drop rules";
        }
        if (n instanceof LPGParser.drop_rule) {
            return ((LPGParser.drop_rule)n).getSYMBOL().toString();
        }
        if (n instanceof LPGParser.drop_ruleList) {
            return "rules";
        }
        if (n instanceof LPGParser.rule) {
            LPGParser.rule r = (LPGParser.rule)n;
            LPGParser.nonTerm nt = (LPGParser.nonTerm)r.getParent().getParent();
            String nonTermName = nt.getruleNameWithAttributes().getSYMBOL().toString();
            return nonTermName + " " + nt.getproduces() + " " + r.getsymWithAttrsList().toString();
        }
        if (n instanceof LPGParser.symWithAttrsList) {
            return ((LPGParser.symWithAttrsList)n).toString();
        }
        if (n instanceof LPGParser.keywordSpecList) {
            return "keywords";
        }
        if (n instanceof LPGParser.keywordSpec) {
            LPGParser.keywordSpec kspec = (LPGParser.keywordSpec)n;
            return kspec.getterminal_symbol().toString() + (kspec.getname() != null ? " ::= " + kspec.getname().toString() : "");
        }
        if (n instanceof LPGParser.rules_segment) {
            return "rules";
        }
        if (n instanceof LPGParser.SYMBOLList) {
            return n.toString();
        }
        if (n instanceof LPGParser.type_declarationsList) {
            return "types";
        }
        if (n instanceof LPGParser.type_declarations) {
            return ((LPGParser.type_declarations)n).getSYMBOL().toString();
        }
        if (n instanceof LPGParser.import_segment) {
            return "import " + ((LPGParser.import_segment)n).getSYMBOL().toString();
        }
        if (n instanceof LPGParser.ASTNodeToken) {
            return ((LPGParser.ASTNodeToken)n).toString();
        }
        return "<???>";
    }

    public void addListener(ILabelProviderListener listener) {
        this.fListeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.fListeners.remove(listener);
    }
}

