/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.editor;

import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.services.base.OutlinerBase;
import org.eclipse.swt.graphics.Image;

public class Outliner
extends OutlinerBase {
    private static final Image sTreeItemImage = LPGRuntimePlugin.getInstance().getImageRegistry().get("outline_item");

    public String producesImage(LPGParser.Iproduces produces) {
        if (produces instanceof LPGParser.produces0) {
            return ((LPGParser.produces0)produces).getLeftIToken().toString();
        }
        if (produces instanceof LPGParser.produces1) {
            return ((LPGParser.produces1)produces).getLeftIToken().toString();
        }
        if (produces instanceof LPGParser.produces2) {
            return ((LPGParser.produces2)produces).getLeftIToken().toString();
        }
        if (produces instanceof LPGParser.produces3) {
            return ((LPGParser.produces3)produces).getLeftIToken().toString();
        }
        return "<???>";
    }

    public String nameImage(LPGParser.Iname name) {
        if (name instanceof LPGParser.name0) {
            return ((LPGParser.name0)name).getLeftIToken().toString();
        }
        if (name instanceof LPGParser.name1) {
            return ((LPGParser.name1)name).getLeftIToken().toString();
        }
        if (name instanceof LPGParser.name2) {
            return "$empty";
        }
        if (name instanceof LPGParser.name3) {
            return "$error";
        }
        if (name instanceof LPGParser.name4) {
            return "$eol";
        }
        if (name instanceof LPGParser.name5) {
            return ((LPGParser.name5)name).getLeftIToken().toString();
        }
        return "<???>";
    }

    private String symbolImage(LPGParser.IASTNodeToken symbol) {
        return symbol.getLeftIToken().toString();
    }

    private String symbolListImage(LPGParser.Isymbol_list symbols) {
        LPGParser.SYMBOLList symbolList = (LPGParser.SYMBOLList)symbols;
        StringBuffer buff = new StringBuffer();
        buff.append('(');
        for (int i = 0; i < symbolList.size(); ++i) {
            if (i > 0) {
                buff.append(',');
            }
            buff.append(this.symbolImage(symbolList.getSYMBOLAt(i)));
        }
        buff.append(')');
        return buff.toString();
    }

    private String blockImage(LPGParser.ASTNodeToken block) {
        return block.getLeftIToken().toString();
    }

    protected void sendVisitorToAST(Object node) {
        LPGParser.ASTNode root = (LPGParser.ASTNode)node;
        root.accept(new OutlineVisitor());
    }

    private final class OutlineVisitor
    extends LPGParser.AbstractVisitor {
        private StringBuffer fRHSLabel;

        private OutlineVisitor() {
        }

        public void unimplementedVisitor(String s) {
        }

        public boolean visit(LPGParser.JikesPG n) {
            return true;
        }

        public void endVisit(LPGParser.JikesPG n) {
        }

        public boolean visit(LPGParser.option_specList n) {
            Outliner.this.pushTopItem("Options", n);
            return true;
        }

        public void endVisit(LPGParser.option_specList n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.option n) {
            LPGParser.Ioption_value value = n.getoption_value();
            if (value != null) {
                if (value instanceof LPGParser.option_value0) {
                    Outliner.this.createSubItem(Outliner.this.symbolImage(n.getSYMBOL()) + " = " + Outliner.this.symbolImage(((LPGParser.option_value0)value).getSYMBOL()), n);
                } else if (value instanceof LPGParser.option_value1) {
                    Outliner.this.createSubItem(Outliner.this.symbolImage(n.getSYMBOL()) + " = " + Outliner.this.symbolListImage(((LPGParser.option_value1)value).getsymbol_list()), n);
                }
            } else {
                Outliner.this.createSubItem(Outliner.this.symbolImage(n.getSYMBOL()), n);
            }
            return true;
        }

        public boolean visit(LPGParser.import_segment n) {
            Outliner.this.pushTopItem("Import", n);
            return false;
        }

        public void endVisit(LPGParser.import_segment n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.NoticeSeg n) {
            Outliner.this.pushTopItem("Notice", n);
            return false;
        }

        public void endVisit(LPGParser.NoticeSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.AliasSeg n) {
            Outliner.this.pushTopItem("Alias", n);
            return true;
        }

        public void endVisit(LPGParser.AliasSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.DefineSeg n) {
            Outliner.this.pushTopItem("Define", n);
            return true;
        }

        public void endVisit(LPGParser.DefineSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.defineSpec n) {
            Outliner.this.createSubItem(Outliner.this.symbolImage(n.getmacro_name_symbol()), (LPGParser.ASTNode)((Object)n.getmacro_name_symbol()));
            return true;
        }

        public boolean visit(LPGParser.EofSeg n) {
            Outliner.this.pushTopItem("EOF", n);
            return true;
        }

        public void endVisit(LPGParser.EofSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.ExportSeg n) {
            Outliner.this.pushTopItem("Export", n);
            return true;
        }

        public void endVisit(LPGParser.ExportSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.terminal_symbol1 n) {
            Outliner.this.createSubItem(n.getMACRO_NAME().toString(), (LPGParser.ASTNode)n.getMACRO_NAME());
            return false;
        }

        public boolean visit(LPGParser.GlobalsSeg n) {
            Outliner.this.pushTopItem("Globals", n);
            return true;
        }

        public void endVisit(LPGParser.GlobalsSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.HeadersSeg n) {
            Outliner.this.pushTopItem("Headers", n);
            return true;
        }

        public void endVisit(LPGParser.HeadersSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.TrailersSeg n) {
            Outliner.this.pushTopItem("Trailers", n);
            return true;
        }

        public void endVisit(LPGParser.TrailersSeg n) {
            Outliner.this.popSubItem();
        }

        public void endVisit(LPGParser.include_segment n) {
            Outliner.this.createTopItem("Include " + n.getSYMBOL(), n);
        }

        public boolean visit(LPGParser.IdentifierSeg n) {
            Outliner.this.pushTopItem("Identifiers", n);
            return true;
        }

        public void endVisit(LPGParser.IdentifierSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.KeywordsSeg n) {
            Outliner.this.pushTopItem("Keywords", n);
            return true;
        }

        public void endVisit(LPGParser.KeywordsSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.StartSeg n) {
            Outliner.this.pushTopItem("Start", n);
            return true;
        }

        public void endVisit(LPGParser.StartSeg n) {
            Outliner.this.popSubItem();
        }

        public void endVisit(LPGParser.start_symbol0 n) {
            Outliner.this.createSubItem(Outliner.this.symbolImage(n), n);
        }

        public void endVisit(LPGParser.start_symbol1 n) {
            Outliner.this.createSubItem("Start = " + Outliner.this.symbolImage(n), n);
        }

        public boolean visit(LPGParser.TerminalsSeg n) {
            Outliner.this.pushTopItem("Terminals", n);
            return true;
        }

        public void endVisit(LPGParser.TerminalsSeg n) {
            Outliner.this.popSubItem();
        }

        public void endVisit(LPGParser.terminal n) {
            String label;
            LPGParser.Iterminal_symbol symbol = n.getterminal_symbol();
            LPGParser.optTerminalAlias alias = n.getoptTerminalAlias();
            if (alias != null) {
                LPGParser.Iproduces prod = alias.getproduces();
                LPGParser.Iname name = alias.getname();
                label = Outliner.this.nameImage(name) + " " + Outliner.this.producesImage(prod) + " " + Outliner.this.symbolImage(symbol);
            } else {
                label = Outliner.this.symbolImage(symbol);
            }
            Outliner.this.createSubItem(label, (LPGParser.ASTNode)((Object)symbol));
        }

        public boolean visit(LPGParser.AstSeg n) {
            Outliner.this.pushTopItem("Ast", n);
            return true;
        }

        public void endVisit(LPGParser.AstSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.RulesSeg n) {
            Outliner.this.pushTopItem("Rules", n);
            return true;
        }

        public void endVisit(LPGParser.RulesSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.nonTerm n) {
            if (n.getruleList().size() > 1) {
                Outliner.this.pushSubItem(Outliner.this.symbolImage(n.getruleNameWithAttributes().getSYMBOL()), n);
            }
            return true;
        }

        public void endVisit(LPGParser.nonTerm n) {
            if (n.getruleList().size() > 1) {
                Outliner.this.popSubItem();
            }
        }

        public boolean visit(LPGParser.rule n) {
            this.fRHSLabel = new StringBuffer();
            LPGParser.nonTerm parentNonTerm = (LPGParser.nonTerm)n.getParent().getParent();
            if (parentNonTerm.getruleList().size() == 1) {
                this.fRHSLabel.append(parentNonTerm.getruleNameWithAttributes().getSYMBOL());
                this.fRHSLabel.append(" ::= ");
            }
            return true;
        }

        public void endVisit(LPGParser.rule n) {
            Outliner.this.createSubItem(this.fRHSLabel.toString(), n);
        }

        public void endVisit(LPGParser.symWithAttrs0 n) {
            this.fRHSLabel.append(' ');
            this.fRHSLabel.append(n.getIToken().toString());
        }

        public void endVisit(LPGParser.symWithAttrs1 n) {
            this.fRHSLabel.append(' ');
            this.fRHSLabel.append(n.getSYMBOL().toString());
        }

        public boolean visit(LPGParser.TypesSeg n) {
            Outliner.this.pushTopItem("Types", n);
            return true;
        }

        public void endVisit(LPGParser.TypesSeg n) {
            Outliner.this.popSubItem();
        }

        public boolean visit(LPGParser.type_declarations n) {
            Outliner.this.pushSubItem(Outliner.this.symbolImage(n.getSYMBOL()), n);
            return true;
        }

        public void endVisit(LPGParser.type_declarations n) {
            Outliner.this.popSubItem();
        }
    }
}

