/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lpg.runtime.IAst;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.IPathEntry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.preferences.PreferencesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTUtils {
    private ASTUtils() {
    }

    public static LPGParser.JikesPG getRoot(IAst node) {
        while (node != null && !(node instanceof LPGParser.JikesPG)) {
            node = node.getParent();
        }
        return (LPGParser.JikesPG)node;
    }

    public static List<LPGParser.Imacro_name_symbol> getMacros(LPGParser.JikesPG root) {
        LPGParser.SymbolTable st = root.symbolTable;
        return st.allDefsOfType(LPGParser.Imacro_name_symbol.class);
    }

    public static List<LPGParser.nonTerm> getNonTerminals(LPGParser.JikesPG root) {
        LPGParser.SymbolTable st = root.symbolTable;
        return st.allDefsOfType(LPGParser.nonTerm.class);
    }

    public static List<LPGParser.terminal> getTerminals(LPGParser.JikesPG root) {
        LPGParser.SymbolTable st = root.symbolTable;
        return st.allDefsOfType(LPGParser.terminal.class);
    }

    public static List<LPGParser.ASTNode> findItemOfType(LPGParser.JikesPG root, Class ofType) {
        LPGParser.JikesPG_itemList itemList = root.getJikesPG_INPUT();
        ArrayList<LPGParser.ASTNode> result = new ArrayList<LPGParser.ASTNode>();
        for (int i = 0; i < itemList.size(); ++i) {
            LPGParser.IJikesPG_item item = itemList.getJikesPG_itemAt(i);
            if (!ofType.isInstance(item)) continue;
            result.add((LPGParser.ASTNode)((Object)item));
        }
        return result;
    }

    public static String stripName(String rawId) {
        int idx = rawId.indexOf(36);
        return idx >= 0 ? rawId.substring(0, idx) : rawId;
    }

    protected static List<String> collectIncludedFiles(LPGParser.JikesPG root) {
        ArrayList<String> result = new ArrayList<String>();
        LPGParser.option_specList optSeg = root.getoptions_segment();
        for (int i = 0; i < optSeg.size(); ++i) {
            LPGParser.option_spec optSpec = optSeg.getoption_specAt(i);
            LPGParser.optionList optList = optSpec.getoption_list();
            for (int o = 0; o < optList.size(); ++o) {
                LPGParser.Ioption_value optValue;
                LPGParser.option opt = optList.getoptionAt(o);
                LPGParser.ASTNodeToken sym = opt.getSYMBOL();
                String optName = ((Object)sym).toString();
                if (!optName.equals("import_terminals") && !optName.equals("template") && !optName.equals("filter") || !((optValue = opt.getoption_value()) instanceof LPGParser.option_value0)) continue;
                result.add(((LPGParser.option_value0)optValue).getSYMBOL().toString());
            }
        }
        return result;
    }

    public static Object findDefOf(LPGParser.IASTNodeToken s, LPGParser.JikesPG root, ICompilationUnit refUnit, IProgressMonitor monitor) {
        String id = ASTUtils.stripName(s.toString());
        List<String> includedFiles = ASTUtils.collectIncludedFiles(root);
        for (String fileName : includedFiles) {
            LPGParser.ASTNode decl;
            LPGParser.JikesPG includedRoot = (LPGParser.JikesPG)ASTUtils.findAndParseSourceFile(refUnit.getProject(), refUnit.getPath(), fileName, monitor);
            if (includedRoot == null || (decl = includedRoot.symbolTable.lookup(id)) == null) continue;
            return decl;
        }
        return null;
    }

    public static Object findDefOf(LPGParser.IASTNodeToken s, LPGParser.JikesPG root, IParseController parseController) {
        Object def;
        String id = ASTUtils.stripName(s.toString());
        LPGParser.ASTNode decl = root.symbolTable.lookup(id);
        if (((LPGParser.ASTNodeToken)s).parent == decl && (def = ASTUtils.findDefOf(s, root, ModelFactory.open((IPath)parseController.getPath(), (ISourceProject)parseController.getProject()), (IProgressMonitor)new NullProgressMonitor())) != null) {
            return def;
        }
        if (decl == null) {
            LPGParser.ASTNode node = (LPGParser.ASTNode)((Object)s);
            LPGParser.ASTNode parent = (LPGParser.ASTNode)node.getParent();
            LPGParser.ASTNode grandParent = (LPGParser.ASTNode)parent.getParent();
            if (grandParent instanceof LPGParser.option) {
                LPGParser.option opt = (LPGParser.option)grandParent;
                String optName = opt.getSYMBOL().toString();
                if (optName.equals("import_terminals") || optName.equals("template") || optName.equals("filter")) {
                    return ASTUtils.lookupImportedFile(parseController.getProject(), parseController.getPath(), id);
                }
            } else if (parent instanceof LPGParser.IncludeSeg) {
                LPGParser.IncludeSeg iseg = (LPGParser.IncludeSeg)parent;
                String includeFile = iseg.getinclude_segment().getSYMBOL().toString();
                return ASTUtils.lookupImportedFile(parseController.getProject(), parseController.getPath(), includeFile);
            }
        }
        return decl;
    }

    public static ICompilationUnit lookupImportedFile(ISourceProject srcProject, IPath refFile, String fileName) {
        IPath refPath = refFile.removeLastSegments(1);
        IProject project = srcProject.getRawProject();
        if (project.getFile(refPath.append(fileName)).exists()) {
            return ModelFactory.open((IPath)refPath.append(fileName), (ISourceProject)srcProject);
        }
        if (project.getFile(fileName).exists()) {
            return ModelFactory.open((IPath)new Path(fileName), (ISourceProject)srcProject);
        }
        List buildPath = srcProject.getBuildPath();
        for (IPathEntry entry : buildPath) {
            IPath candidatePath = project.getLocation().append(entry.getPath()).append(fileName);
            if (!project.getFile(candidatePath).exists()) continue;
            return ModelFactory.open((IPath)candidatePath, (ISourceProject)srcProject);
        }
        PreferencesService prefService = new PreferencesService(project, LPGRuntimePlugin.getInstance().getLanguageID());
        String includeSearchPath = prefService.getStringPreference("IncludePathToUse");
        String[] includeDirs = includeSearchPath.split(";");
        for (int i = 0; i < includeDirs.length; ++i) {
            Path includeDirPath = new Path(includeDirs[i]);
            IPath includeFile = includeDirPath.append(fileName);
            if (!new File(includeFile.toOSString()).exists()) continue;
            return ModelFactory.open((IPath)includeFile, (ISourceProject)srcProject);
        }
        return null;
    }

    public static ICompilationUnit lookupSourceFile(ISourceProject project, IPath refLocation, String filePath) {
        ICompilationUnit icu = ModelFactory.open((IFile)project.getRawProject().getFile(refLocation.removeFirstSegments(1).removeLastSegments(1).append(filePath)), (ISourceProject)project);
        if (icu == null) {
            icu = ModelFactory.open((IPath)new Path(filePath), (ISourceProject)project);
        }
        return icu;
    }

    public static Object findAndParseSourceFile(ISourceProject project, IPath refLocation, String fileName, IProgressMonitor monitor) {
        ICompilationUnit unit = ASTUtils.lookupSourceFile(project, refLocation, fileName);
        if (unit != null) {
            return unit.getAST(null, monitor);
        }
        return null;
    }

    public static List<LPGParser.ASTNode> findRefsOf(LPGParser.nonTerm nonTerm2) {
        final ArrayList<LPGParser.ASTNode> result = new ArrayList<LPGParser.ASTNode>();
        LPGParser.JikesPG root = ASTUtils.getRoot(nonTerm2);
        List<LPGParser.nonTerm> nonTerms = ASTUtils.getNonTerminals(root);
        for (int i = 0; i < nonTerms.size(); ++i) {
            LPGParser.nonTerm nt = nonTerms.get(i);
            final String nonTermName = nonTerm2.getruleNameWithAttributes().getSYMBOL().toString();
            nt.accept(new LPGParser.AbstractVisitor(){

                public void unimplementedVisitor(String s) {
                }

                public boolean visit(LPGParser.symWithAttrs1 n) {
                    if (n.getSYMBOL().toString().equals(nonTermName)) {
                        result.add(n);
                    }
                    return super.visit(n);
                }
            });
        }
        return result;
    }

    public static List<LPGParser.ASTNode> findRefsOf(LPGParser.terminal term) {
        final ArrayList<LPGParser.ASTNode> result = new ArrayList<LPGParser.ASTNode>();
        LPGParser.JikesPG root = ASTUtils.getRoot(term);
        List<LPGParser.nonTerm> nonTerms = ASTUtils.getNonTerminals(root);
        for (int i = 0; i < nonTerms.size(); ++i) {
            LPGParser.nonTerm nt = nonTerms.get(i);
            final String symbolName = term.toString();
            nt.accept(new LPGParser.AbstractVisitor(){

                public void unimplementedVisitor(String s) {
                }

                public boolean visit(LPGParser.symWithAttrs1 n) {
                    if (n.getSYMBOL().toString().equals(symbolName)) {
                        result.add(n);
                    }
                    return super.visit(n);
                }
            });
        }
        return result;
    }
}

