/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.parser;

import lpg.runtime.IAst;
import lpg.runtime.IToken;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.lpg.parser.ParseController;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.parser.ISourcePositionLocator;

public class NodeLocator
implements ISourcePositionLocator {
    private IAst fResult = null;
    private final ParseController fParseController;

    public NodeLocator(ParseController controller) {
        this.fParseController = controller;
    }

    public Object findNode(Object ast, int offset) {
        LPGParser.ASTNode root = (LPGParser.ASTNode)ast;
        if (root == null) {
            return null;
        }
        root.accept(new LocatingVisitor(offset));
        return this.fResult;
    }

    public Object findNode(Object ast, int startOffset, int endOffset) {
        LPGParser.ASTNode root = (LPGParser.ASTNode)ast;
        root.accept(new LocatingVisitor(startOffset, endOffset));
        return this.fResult;
    }

    public int getStartOffset(Object entity) {
        if (entity instanceof IAst) {
            IAst n = (IAst)entity;
            return n.getLeftIToken().getStartOffset();
        }
        if (entity instanceof ICompilationUnit) {
            ICompilationUnit icu = (ICompilationUnit)entity;
            return 0;
        }
        if (entity instanceof IToken) {
            IToken t = (IToken)entity;
            return t.getStartOffset();
        }
        return 0;
    }

    public int getEndOffset(Object entity) {
        if (entity instanceof IAst) {
            IAst n = (IAst)entity;
            return n.getRightIToken().getEndOffset();
        }
        if (entity instanceof ICompilationUnit) {
            return 0;
        }
        if (entity instanceof IToken) {
            IToken t = (IToken)entity;
            return t.getEndOffset();
        }
        return 0;
    }

    public int getLength(Object entity) {
        if (entity instanceof ICompilationUnit) {
            return 0;
        }
        return this.getEndOffset(entity) - this.getStartOffset(entity) + 1;
    }

    public IPath getPath(Object node) {
        if (node instanceof LPGParser.ASTNode) {
            LPGParser.ASTNode n = (LPGParser.ASTNode)node;
            return new Path(this.fParseController.getProject().getRawProject().getName() + "/" + n.leftIToken.getIPrsStream().getFileName());
        }
        if (node instanceof ICompilationUnit) {
            ICompilationUnit icu = (ICompilationUnit)node;
            if (icu.getPath().isAbsolute()) {
                if (icu.getPath().getDevice() == null) {
                    IWorkspaceRoot wsRoot = icu.getProject().getRawProject().getWorkspace().getRoot();
                    return wsRoot.getLocation().append(icu.getPath());
                }
                return icu.getPath();
            }
            return icu.getProject().getRawProject().getFullPath().append(icu.getPath());
        }
        return null;
    }

    private class LocatingVisitor
    extends LPGParser.AbstractVisitor {
        private final int fStartOffset;
        private final int fEndOffset;

        public LocatingVisitor(int offset) {
            this(offset, offset);
        }

        public LocatingVisitor(int startOffset, int endOffset) {
            this.fStartOffset = startOffset;
            this.fEndOffset = endOffset;
        }

        public IAst getResult() {
            return NodeLocator.this.fResult;
        }

        public void unimplementedVisitor(String s) {
        }

        public void postVisit(IAst n) {
            if (NodeLocator.this.fResult == null) {
                IToken symLeftTok = n.getLeftIToken();
                IToken symRightTok = n.getRightIToken();
                if (this.fStartOffset >= symLeftTok.getStartOffset() && this.fEndOffset <= symRightTok.getEndOffset() + 1) {
                    NodeLocator.this.fResult = n;
                }
            }
        }
    }
}

