/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.refactoring;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.lpg.parser.ASTUtils;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class InlineNonTerminalRefactoring
extends Refactoring {
    private final IFile fGrammarFile;
    private final IParseController fParseController;
    private final LPGParser.ASTNode fNode;
    private LPGParser.nonTerm fNonTerm;
    private LPGParser.symWithAttrsList fRHS;
    private boolean fInlineAll;
    private boolean fDeleteOrig;

    public InlineNonTerminalRefactoring(UniversalEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.fGrammarFile = fileInput.getFile();
            this.fNode = this.findNode(editor);
        } else {
            this.fGrammarFile = null;
            this.fNode = null;
        }
        this.fInlineAll = false;
        this.fDeleteOrig = false;
        this.fParseController = editor.getParseController();
    }

    public boolean getDeleteOrig() {
        return this.fDeleteOrig;
    }

    public void setDeleteOrig(boolean deleteOrig) {
        this.fDeleteOrig = deleteOrig;
    }

    private LPGParser.ASTNode findNode(UniversalEditor editor) {
        Point sel = editor.getSelection();
        IParseController parseController = editor.getParseController();
        LPGParser.ASTNode root = (LPGParser.ASTNode)parseController.getCurrentAst();
        ISourcePositionLocator locator = parseController.getNodeLocator();
        return (LPGParser.ASTNode)locator.findNode((Object)root, sel.x);
    }

    public String getName() {
        return "Inline Non-Terminal";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fNode instanceof LPGParser.nonTerm) {
            this.fNonTerm = (LPGParser.nonTerm)this.fNode;
            this.fInlineAll = true;
        } else if (this.fNode instanceof LPGParser.IsymWithAttrs) {
            Object def = ASTUtils.findDefOf((LPGParser.IASTNodeToken)((Object)this.fNode), ASTUtils.getRoot(this.fNode), this.fParseController);
            if (!(def instanceof LPGParser.nonTerm)) {
                return RefactoringStatus.createFatalErrorStatus((String)"Inline Non-Terminal is only valid for non-terminal symbols");
            }
            this.fNonTerm = (LPGParser.nonTerm)def;
        } else {
            if (!(this.fNode instanceof LPGParser.IASTNodeToken)) return RefactoringStatus.createFatalErrorStatus((String)"Inline Non-Terminal is only valid for non-terminal symbols");
            if (!(this.fNode.getParent() instanceof LPGParser.nonTerm)) return RefactoringStatus.createFatalErrorStatus((String)"Inline Non-Terminal is only valid for non-terminal symbols");
            this.fNonTerm = (LPGParser.nonTerm)this.fNode.getParent();
            this.fInlineAll = true;
        }
        LPGParser.ruleList rules = this.fNonTerm.getruleList();
        if (rules.size() != 1) {
            return RefactoringStatus.createFatalErrorStatus((String)"Inline Non-Terminal is only valid for non-terminals with a single production");
        }
        LPGParser.rule rule2 = (LPGParser.rule)rules.getElementAt(0);
        if (rule2.getopt_action_segment() != null) {
            return RefactoringStatus.createFatalErrorStatus((String)"Non-terminal to be inlined cannot have an action block");
        }
        this.fRHS = rule2.getsymWithAttrsList();
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        List<LPGParser.ASTNode> refs = this.fInlineAll ? ASTUtils.findRefsOf(this.fNonTerm) : Collections.singletonList(this.fNode);
        StringBuffer buff = new StringBuffer();
        int N = this.fRHS.size();
        for (int i = 0; i < N; ++i) {
            if (i > 0) {
                buff.append(' ');
            }
            buff.append(this.fRHS.getElementAt(i).toString());
        }
        String nonTermString = buff.toString();
        TextFileChange tfc = new TextFileChange("Inline Non-Terminal", this.fGrammarFile);
        tfc.setEdit((TextEdit)new MultiTextEdit());
        for (LPGParser.IsymWithAttrs isymWithAttrs : refs) {
            int startOffset = isymWithAttrs.getLeftIToken().getStartOffset();
            int endOffset = isymWithAttrs.getLeftIToken().getEndOffset();
            tfc.addEdit((TextEdit)new ReplaceEdit(startOffset, endOffset - startOffset + 1, nonTermString));
        }
        if (this.fDeleteOrig) {
            int startOffset = this.fNonTerm.getLeftIToken().getStartOffset();
            int n = this.fNonTerm.getRightIToken().getEndOffset();
            tfc.addEdit((TextEdit)new DeleteEdit(startOffset, n - startOffset + 1));
        }
        return tfc;
    }

    public boolean getInlineAll() {
        return this.fInlineAll;
    }

    public void setInlineAll(boolean inlineAll) {
        this.fInlineAll = inlineAll;
    }
}

