/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class MakeNonEmptyRefactoring
extends Refactoring {
    private final IFile fGrammarFile;
    private final LPGParser.ASTNode fNode;

    public MakeNonEmptyRefactoring(UniversalEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.fGrammarFile = fileInput.getFile();
            this.fNode = this.findNode(editor);
        } else {
            this.fGrammarFile = null;
            this.fNode = null;
        }
    }

    private LPGParser.ASTNode findNode(UniversalEditor editor) {
        Point sel = editor.getSelection();
        IParseController parseController = editor.getParseController();
        LPGParser.ASTNode root = (LPGParser.ASTNode)parseController.getCurrentAst();
        ISourcePositionLocator locator = parseController.getNodeLocator();
        return (LPGParser.ASTNode)locator.findNode((Object)root, sel.x);
    }

    public String getName() {
        return "Make Non-Empty";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!(this.fNode instanceof LPGParser.nonTerm)) {
            return RefactoringStatus.createFatalErrorStatus((String)"Make Non-Empty is only valid for non-terminals");
        }
        LPGParser.nonTerm nt = (LPGParser.nonTerm)this.fNode;
        LPGParser.ruleList rhSides = nt.getruleList();
        if (rhSides.size() != 2) {
            return RefactoringStatus.createFatalErrorStatus((String)"Make Non-Empty is only valid for non-terminals with 2 productions");
        }
        LPGParser.rule rhs1 = (LPGParser.rule)rhSides.getElementAt(0);
        LPGParser.rule rhs2 = (LPGParser.rule)rhSides.getElementAt(1);
        LPGParser.symWithAttrsList rhs1Syms = rhs1.getsymWithAttrsList();
        LPGParser.symWithAttrsList rhs2Syms = rhs2.getsymWithAttrsList();
        if (rhs2Syms.size() == 1 && rhs2Syms.getElementAt(0).toString().equals("$empty")) {
            LPGParser.rule tmp = rhs1;
            LPGParser.symWithAttrsList tmpList = rhs1Syms;
            rhs1 = rhs2;
            rhs2 = tmp;
            rhs1Syms = rhs2Syms;
            rhs2Syms = tmpList;
        } else if (rhs1Syms.size() != 1 || !rhs1Syms.getElementAt(0).toString().equals("$empty")) {
            return RefactoringStatus.createFatalErrorStatus((String)"Non-terminal must have the form 'a ::= $empty | a b'");
        }
        if (!rhs2Syms.getElementAt(0).toString().equals(nt.getruleNameWithAttributes().getSYMBOL().toString())) {
            return RefactoringStatus.createFatalErrorStatus((String)"Non-terminal must have the form 'a ::= $empty | a b'");
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        LPGParser.nonTerm nt = (LPGParser.nonTerm)this.fNode;
        LPGParser.ruleList rhSides = nt.getruleList();
        LPGParser.rule rhs1 = (LPGParser.rule)rhSides.getElementAt(0);
        LPGParser.rule rhs2 = (LPGParser.rule)rhSides.getElementAt(1);
        LPGParser.symWithAttrsList rhs1Syms = rhs1.getsymWithAttrsList();
        LPGParser.symWithAttrsList rhs2Syms = rhs2.getsymWithAttrsList();
        int N = rhs2Syms.size();
        if (rhs2Syms.size() == 1) {
            LPGParser.rule tmp = rhs1;
            LPGParser.symWithAttrsList tmpList = rhs1Syms;
            rhs1 = rhs2;
            rhs2 = tmp;
            rhs1Syms = rhs2Syms;
            rhs2Syms = tmpList;
        }
        LPGParser.ASTNode symToReplace = rhs1Syms.getElementAt(0);
        StringBuffer buff = new StringBuffer();
        for (int i = 1; i < N; ++i) {
            if (i > 1) {
                buff.append(' ');
            }
            buff.append(rhs2Syms.getElementAt(i));
        }
        TextFileChange tfc = new TextFileChange("Make Non-Empty", this.fGrammarFile);
        tfc.setEdit((TextEdit)new MultiTextEdit());
        tfc.addEdit((TextEdit)new ReplaceEdit(symToReplace.getLeftIToken().getStartOffset(), symToReplace.getRightIToken().getEndOffset() - symToReplace.getLeftIToken().getStartOffset() + 1, buff.toString()));
        return tfc;
    }
}

