/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.search;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.imp.lpg.search.LPGSearchResult;
import org.eclipse.imp.lpg.search.LPGSearchScope;
import org.eclipse.imp.utils.StreamUtils;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class LPGSearchQuery
implements ISearchQuery {
    private String fEntityRegexp;
    private boolean fIsNonTerm;
    private LPGSearchResult fResult;
    private LPGSearchScope fScope;

    public LPGSearchQuery(String entityRegexp, boolean isNonTerm, LPGSearchScope scope) {
        this.fEntityRegexp = entityRegexp;
        this.fIsNonTerm = isNonTerm;
        this.fScope = scope;
        this.fResult = new LPGSearchResult(this);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        final Pattern pat = Pattern.compile(this.fEntityRegexp);
        for (IProject p : this.fScope.getProjects()) {
            try {
                p.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        IFile file;
                        String exten;
                        if (resource instanceof IFile && (exten = (file = (IFile)resource).getFileExtension()) != null && (exten.equals("g") || exten.equals("gi"))) {
                            String contents = StreamUtils.readStreamContents((InputStream)file.getContents(), (String)ResourcesPlugin.getEncoding());
                            Matcher matcher = pat.matcher(contents);
                            while (matcher.find()) {
                                Match m = new Match((Object)file, matcher.start(), matcher.end() - matcher.start());
                                LPGSearchQuery.this.fResult.addMatch(m);
                            }
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return new Status(0, "org.eclipse.imp.lpg.runtime", 0, "Search complete", null);
    }

    public String getLabel() {
        return (this.fIsNonTerm ? "non-terminal '" : "terminal '") + this.fEntityRegexp + "'";
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }

    public LPGSearchScope getScope() {
        return this.fScope;
    }
}

