/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.impl.BoolValue;
import org.eclipse.imp.pdb.facts.impl.IntegerValue;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RealValue
extends Value
implements IReal {
    private static final int ONE_PAGE_OF_DIGITS = 6400;
    private static final MathContext MATHCONTEXT_FOR_DIVISION = new MathContext(6400, RoundingMode.HALF_UP);
    private final BigDecimal fValue;

    RealValue(double value) {
        super(TypeFactory.getInstance().realType());
        this.fValue = BigDecimal.valueOf(value);
    }

    RealValue(float value) {
        super(TypeFactory.getInstance().realType());
        this.fValue = BigDecimal.valueOf(value);
    }

    RealValue(BigDecimal value) {
        super(TypeFactory.getInstance().realType());
        this.fValue = value;
    }

    @Override
    public IReal negate() {
        return new RealValue(this.fValue.negate());
    }

    @Override
    public IReal add(IReal other) {
        return new RealValue(this.fValue.add(((RealValue)other).fValue));
    }

    @Override
    public IReal subtract(IReal other) {
        return new RealValue(this.fValue.subtract(((RealValue)other).fValue));
    }

    @Override
    public IReal multiply(IReal other) {
        return new RealValue(this.fValue.multiply(((RealValue)other).fValue));
    }

    @Override
    public IReal divide(IReal other) {
        return new RealValue(this.fValue.divide(((RealValue)other).fValue, MATHCONTEXT_FOR_DIVISION));
    }

    @Override
    public IReal round() {
        return new RealValue(this.fValue.setScale(0, RoundingMode.HALF_UP));
    }

    @Override
    public IReal floor() {
        return new RealValue(this.fValue.setScale(0, RoundingMode.FLOOR));
    }

    @Override
    public IInteger toInteger() {
        return new IntegerValue(this.fValue.toBigInteger());
    }

    @Override
    public IBool less(IReal other) {
        return new BoolValue(this.compare(other) < 0);
    }

    @Override
    public IBool lessEqual(IReal other) {
        return new BoolValue(this.compare(other) <= 0);
    }

    @Override
    public IBool greater(IReal other) {
        return new BoolValue(this.compare(other) > 0);
    }

    @Override
    public IBool greaterEqual(IReal other) {
        return new BoolValue(this.compare(other) >= 0);
    }

    @Override
    public int compare(IReal other) {
        return this.fValue.compareTo(((RealValue)other).fValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            return this.fValue.equals(((RealValue)o).fValue);
        }
        return false;
    }

    public int hashCode() {
        return this.fValue.hashCode();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitReal(this);
    }

    @Override
    public String getStringRepresentation() {
        return this.fValue.toString();
    }

    @Override
    public double doubleValue() {
        return this.fValue.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.fValue.floatValue();
    }

    @Override
    public int precision() {
        return this.fValue.precision();
    }

    @Override
    public int scale() {
        return this.fValue.scale();
    }

    @Override
    public IInteger unscaled() {
        return new IntegerValue(this.fValue.unscaledValue());
    }
}

