/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.reference;

import java.util.Map;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedAnnotationTypeException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedChildTypeException;
import org.eclipse.imp.pdb.facts.impl.reference.Node;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeStore;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constructor
extends Node
implements IConstructor {
    Constructor(Type type, IValue[] children) {
        super(type.getName(), type, children);
    }

    Constructor(Type type) {
        this(type, new IValue[0]);
    }

    private Constructor(Constructor other, int childIndex, IValue newChild) {
        super((Node)other, childIndex, newChild);
    }

    private Constructor(Constructor constructor, String label, IValue value) {
        super((Node)constructor, label, value);
    }

    private Constructor(Constructor constructor, Map<String, IValue> annotations) {
        super((Node)constructor, annotations);
    }

    private Constructor(Constructor constructor) {
        super(constructor);
    }

    private Constructor(Constructor constructor, String key) {
        super((Node)constructor, key);
    }

    @Override
    public Type getType() {
        return this.fType.getAbstractDataType();
    }

    @Override
    public Type getConstructorType() {
        return this.fType;
    }

    @Override
    public IValue get(String label) {
        return super.get(this.fType.getFieldIndex(label));
    }

    @Override
    public Type getChildrenTypes() {
        return this.fType.getFieldTypes();
    }

    @Override
    public IConstructor set(int i, IValue newChild) throws IndexOutOfBoundsException {
        this.checkChildType(i, newChild);
        return new Constructor(this, i, newChild);
    }

    @Override
    public IConstructor set(String label, IValue newChild) throws FactTypeUseException {
        int childIndex = this.fType.getFieldIndex(label);
        this.checkChildType(childIndex, newChild);
        return new Constructor(this, childIndex, newChild);
    }

    private void checkChildType(int i, IValue newChild) {
        Type expectedType;
        Type type = newChild.getType();
        if (!type.isSubtypeOf(expectedType = this.getConstructorType().getFieldType(i))) {
            throw new UnexpectedChildTypeException(expectedType, type);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            Constructor other = (Constructor)obj;
            return this.fType.comparable(other.fType) && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 + ~super.hashCode();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitConstructor(this);
    }

    @Override
    public boolean declaresAnnotation(TypeStore store, String label) {
        return store.getAnnotationType(this.getType(), label) != null;
    }

    @Override
    public IConstructor setAnnotation(String label, IValue value) {
        Type expected;
        IValue previous = this.getAnnotation(label);
        if (previous != null && !(expected = previous.getType()).comparable(value.getType())) {
            throw new UnexpectedAnnotationTypeException(expected, value.getType());
        }
        return new Constructor(this, label, value);
    }

    @Override
    public IConstructor joinAnnotations(Map<String, IValue> annotations) {
        return new Constructor(this, annotations);
    }

    @Override
    public IConstructor setAnnotations(Map<String, IValue> annotations) {
        return this.removeAnnotations().joinAnnotations(annotations);
    }

    @Override
    public IConstructor removeAnnotations() {
        return new Constructor(this);
    }

    @Override
    public IConstructor removeAnnotation(String key) {
        return new Constructor(this, key);
    }
}

