/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.reference;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedElementTypeException;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.impl.Writer;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List
extends Value
implements IList {
    private final Type eltType;
    private final LinkedList<IValue> content;

    public List(Type eltType, LinkedList<IValue> listContent) {
        super(TypeFactory.getInstance().listType(eltType));
        this.eltType = eltType;
        this.content = listContent;
    }

    @Override
    public Type getElementType() {
        return this.eltType;
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.content.iterator();
    }

    @Override
    public int length() {
        return this.content.size();
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public IValue get(int i) {
        return this.content.get(i);
    }

    @Override
    public IList put(int i, IValue elem) throws IndexOutOfBoundsException {
        ListWriter w = new ListWriter(elem.getType().lub(this.getElementType()));
        w.appendAll(this);
        w.replaceAt(i, elem);
        return w.done();
    }

    @Override
    public IList insert(IValue elem) {
        ListWriter w = new ListWriter(elem.getType().lub(this.getElementType()));
        w.appendAll(this);
        w.insert(elem);
        return w.done();
    }

    @Override
    public IList append(IValue elem) {
        ListWriter w = new ListWriter(elem.getType().lub(this.getElementType()));
        w.appendAll(this);
        w.append(elem);
        return w.done();
    }

    @Override
    public boolean contains(IValue e) {
        return this.content.contains(e);
    }

    @Override
    public IList delete(IValue e) {
        ListWriter w = new ListWriter(this.getElementType());
        w.appendAll(this);
        w.delete(e);
        return w.done();
    }

    @Override
    public IList reverse() {
        ListWriter w = new ListWriter(this.getElementType());
        for (IValue e : this) {
            w.insert(e);
        }
        return w.done();
    }

    @Override
    public IList concat(IList other) {
        ListWriter w = new ListWriter(this.getElementType().lub(other.getElementType()));
        w.appendAll(this);
        w.appendAll(other);
        return w.done();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitList(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            List other = (List)o;
            return this.fType.comparable(other.fType) && this.content.equals(other.content);
        }
        return false;
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    static ListWriter createListWriter(Type eltType) {
        return new ListWriter(eltType);
    }

    private static void checkInsert(IValue elem, Type eltType) throws FactTypeUseException {
        Type type = elem.getType();
        if (!type.isSubtypeOf(eltType)) {
            throw new UnexpectedElementTypeException(eltType, type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListWriter
    extends Writer
    implements IListWriter {
        private final Type eltType;
        private final LinkedList<IValue> listContent;
        private List constructedList;

        public ListWriter(Type eltType) {
            this.eltType = eltType;
            this.listContent = new LinkedList();
            this.constructedList = null;
        }

        private void checkMutation() {
            if (this.constructedList != null) {
                throw new UnsupportedOperationException("Mutation of a finalized list is not supported.");
            }
        }

        private void put(int index, IValue elem) {
            List.checkInsert(elem, this.eltType);
            this.listContent.add(index, elem);
        }

        public void insert(IValue elem) throws FactTypeUseException {
            this.checkMutation();
            this.put(0, elem);
        }

        @Override
        public void insert(IValue[] elems, int start, int length) throws FactTypeUseException {
            this.checkMutation();
            this.checkBounds(elems, start, length);
            for (int i = start + length - 1; i >= start; --i) {
                this.put(0, elems[i]);
            }
        }

        @Override
        public void replaceAt(int index, IValue elem) throws FactTypeUseException, IndexOutOfBoundsException {
            this.checkMutation();
            List.checkInsert(elem, this.eltType);
            this.listContent.set(index, elem);
        }

        @Override
        public void insert(IValue ... elems) throws FactTypeUseException {
            this.insert(elems, 0, elems.length);
        }

        public void insert(int index, IValue elem) throws FactTypeUseException {
            this.checkMutation();
            this.put(index, elem);
        }

        @Override
        public void insertAt(int index, IValue[] elems, int start, int length) throws FactTypeUseException {
            this.checkMutation();
            this.checkBounds(elems, start, length);
            for (int i = start + length - 1; i >= start; --i) {
                this.put(index, elems[i]);
            }
        }

        @Override
        public void insertAt(int index, IValue ... elems) throws FactTypeUseException {
            this.insertAt(index, elems, 0, 0);
        }

        public void append(IValue elem) throws FactTypeUseException {
            this.checkMutation();
            this.put(this.listContent.size(), elem);
        }

        @Override
        public void append(IValue ... elems) throws FactTypeUseException {
            this.checkMutation();
            for (IValue elem : elems) {
                this.put(this.listContent.size(), elem);
            }
        }

        @Override
        public void appendAll(Iterable<? extends IValue> collection) throws FactTypeUseException {
            this.checkMutation();
            for (IValue iValue : collection) {
                this.put(this.listContent.size(), iValue);
            }
        }

        @Override
        public IList done() {
            if (this.constructedList == null) {
                this.constructedList = new List(this.eltType, this.listContent);
            }
            return this.constructedList;
        }

        private void checkBounds(IValue[] elems, int start, int length) {
            if (start < 0) {
                throw new ArrayIndexOutOfBoundsException("start < 0");
            }
            if (start + length > elems.length) {
                throw new ArrayIndexOutOfBoundsException("(start + length) > elems.length");
            }
        }

        @Override
        public void delete(IValue elem) {
            this.checkMutation();
            this.listContent.remove(elem);
        }
    }
}

