/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.reference;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedAnnotationTypeException;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends Value
implements INode {
    protected static final HashMap<String, IValue> EMPTY_ANNOTATIONS = new HashMap();
    protected final IValue[] fChildren;
    protected final String fName;
    protected final HashMap<String, IValue> fAnnotations;

    Node(String name, IValue[] children) {
        super(TypeFactory.getInstance().nodeType());
        this.fName = name;
        this.fChildren = new IValue[children.length];
        System.arraycopy(children, 0, this.fChildren, 0, children.length);
        this.fAnnotations = EMPTY_ANNOTATIONS;
    }

    protected Node(String name, Type type, IValue[] children) {
        super(type);
        this.fName = name;
        this.fChildren = new IValue[children.length];
        System.arraycopy(children, 0, this.fChildren, 0, children.length);
        this.fAnnotations = EMPTY_ANNOTATIONS;
    }

    protected Node(Node other, String label, IValue anno) {
        super(other.fType);
        this.fName = other.fName;
        this.fChildren = new IValue[other.fChildren.length];
        System.arraycopy(other.fChildren, 0, this.fChildren, 0, other.fChildren.length);
        this.fAnnotations = (HashMap)other.fAnnotations.clone();
        this.fAnnotations.put(label, anno);
    }

    protected Node(Node other, String label) {
        super(other.fType);
        this.fName = other.fName;
        this.fChildren = new IValue[other.fChildren.length];
        System.arraycopy(other.fChildren, 0, this.fChildren, 0, other.fChildren.length);
        this.fAnnotations = (HashMap)other.fAnnotations.clone();
        this.fAnnotations.remove(label);
    }

    protected Node(Node other) {
        super(other.fType);
        this.fName = other.fName;
        this.fChildren = new IValue[other.fChildren.length];
        System.arraycopy(other.fChildren, 0, this.fChildren, 0, other.fChildren.length);
        this.fAnnotations = EMPTY_ANNOTATIONS;
    }

    Node(String name) {
        this(name, new IValue[0]);
    }

    protected Node(Node other, int index, IValue newChild) {
        super(other);
        this.fName = other.fName;
        this.fChildren = (IValue[])other.fChildren.clone();
        this.fChildren[index] = newChild;
        this.fAnnotations = (HashMap)other.fAnnotations.clone();
    }

    public Node(Node other, Map<String, IValue> annotations) {
        super(other);
        this.fName = other.fName;
        this.fChildren = (IValue[])other.fChildren.clone();
        this.fAnnotations = (HashMap)other.fAnnotations.clone();
        this.fAnnotations.putAll(annotations);
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitNode(this);
    }

    @Override
    public int arity() {
        return this.fChildren.length;
    }

    @Override
    public IValue get(int i) throws IndexOutOfBoundsException {
        try {
            return this.fChildren[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Node node does not have child at pos " + i);
        }
    }

    @Override
    public Iterable<IValue> getChildren() {
        return this;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public INode set(int i, IValue newChild) throws IndexOutOfBoundsException {
        try {
            return new Node(this, i, newChild);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Node node does not have child at pos " + i);
        }
    }

    @Override
    public Iterator<IValue> iterator() {
        return new Iterator<IValue>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Node.this.fChildren.length;
            }

            @Override
            public IValue next() {
                return Node.this.fChildren[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            Node other = (Node)obj;
            if (!this.fType.comparable(other.fType)) {
                return false;
            }
            if (this.fChildren.length != other.fChildren.length) {
                return false;
            }
            if (this.fName == other.fName || this.fName != null && this.fName.equals(other.fName)) {
                for (int i = 0; i < this.fChildren.length; ++i) {
                    if (((Object)this.fChildren[i]).equals(other.fChildren[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.fName != null ? this.fName.hashCode() : 0;
        for (int i = 0; i < this.fChildren.length; ++i) {
            hash = hash << 1 ^ hash >> 1 ^ this.fChildren[i].hashCode();
        }
        return hash;
    }

    @Override
    public boolean hasAnnotation(String label) {
        return this.fAnnotations.containsKey(label);
    }

    @Override
    public INode setAnnotation(String label, IValue value) {
        Type expected;
        IValue previous = this.getAnnotation(label);
        if (previous != null && !(expected = previous.getType()).comparable(value.getType())) {
            throw new UnexpectedAnnotationTypeException(expected, value.getType());
        }
        return new Node(this, label, value);
    }

    @Override
    public IValue getAnnotation(String label) throws FactTypeUseException {
        return this.fAnnotations.get(label);
    }

    @Override
    public Map<String, IValue> getAnnotations() {
        return Collections.unmodifiableMap(this.fAnnotations);
    }

    @Override
    public boolean hasAnnotations() {
        return this.fAnnotations != null && !this.fAnnotations.isEmpty();
    }

    @Override
    public INode joinAnnotations(Map<String, IValue> annotations) {
        return new Node(this, annotations);
    }

    @Override
    public INode setAnnotations(Map<String, IValue> annotations) {
        return this.removeAnnotations().joinAnnotations(annotations);
    }

    @Override
    public INode removeAnnotation(String key) {
        return new Node(this, key);
    }

    @Override
    public INode removeAnnotations() {
        return new Node(this);
    }
}

