/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.FieldLabelMismatchException;
import org.eclipse.imp.pdb.facts.exceptions.IllegalOperationException;
import org.eclipse.imp.pdb.facts.exceptions.UndeclaredFieldException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TupleType
extends Type
implements Iterable<Type> {
    protected final Type[] fFieldTypes;
    protected final String[] fFieldNames;
    protected int fHashcode = -1;

    TupleType(int len, int start, Type[] fieldTypes) {
        if (fieldTypes == null || len < 0) {
            throw new IllegalArgumentException("Null array of field types or non-positive length passed to TupleType ctor!");
        }
        this.fFieldTypes = new Type[len];
        this.fFieldNames = null;
        System.arraycopy(fieldTypes, start, this.fFieldTypes, 0, len);
    }

    TupleType(int len, int start, Type[] fieldTypes, String[] fieldNames) {
        if (fieldTypes == null || len < 0) {
            throw new IllegalArgumentException("Null array of field types or non-positive length passed to TupleType ctor!");
        }
        this.fFieldTypes = new Type[len];
        System.arraycopy(fieldTypes, start, this.fFieldTypes, 0, len);
        if (fieldNames != null && len >= 0 && fieldTypes.length == fieldNames.length) {
            if (len == 0) {
                this.fFieldNames = null;
            } else {
                this.fFieldNames = new String[len];
                System.arraycopy(fieldNames, start, this.fFieldNames, 0, len);
            }
        } else {
            throw new FieldLabelMismatchException(fieldTypes.length, fieldNames.length);
        }
    }

    @Override
    public boolean hasFieldNames() {
        return this.fFieldNames != null;
    }

    @Override
    public boolean isTupleType() {
        return true;
    }

    @Override
    public Type getFieldType(int i) {
        return this.fFieldTypes[i];
    }

    @Override
    public Type getFieldType(String fieldName) {
        return this.getFieldType(this.getFieldIndex(fieldName));
    }

    @Override
    public int getFieldIndex(String fieldName) throws FactTypeUseException {
        if (this.fFieldNames != null) {
            for (int i = 0; i < this.fFieldNames.length; ++i) {
                if (!this.fFieldNames[i].equals(fieldName)) continue;
                return i;
            }
        }
        throw new UndeclaredFieldException(this, fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        try {
            return this.getFieldIndex(fieldName) != -1;
        }
        catch (FactTypeUseException e) {
            return false;
        }
    }

    @Override
    public int getArity() {
        return this.fFieldTypes.length;
    }

    @Override
    public Type compose(Type other) {
        if (other.isVoidType()) {
            return other;
        }
        if (this.getArity() != 2 || other.getArity() != 2) {
            throw new IllegalOperationException("compose", this, other);
        }
        if (!this.getFieldType(1).comparable(other.getFieldType(0))) {
            throw new IllegalOperationException("compose", this, other);
        }
        TypeFactory tf = TypeFactory.getInstance();
        if (this.hasFieldNames() && other.hasFieldNames()) {
            return tf.tupleType(this.getFieldType(0), this.getFieldName(0), other.getFieldType(1), other.getFieldName(1));
        }
        return tf.tupleType(this.getFieldType(0), other.getFieldType(1));
    }

    @Override
    public Type carrier() {
        Type lub = TypeFactory.getInstance().voidType();
        for (Type field : this) {
            lub = lub.lub(field);
        }
        return TypeFactory.getInstance().setType(lub);
    }

    @Override
    public boolean isSubtypeOf(Type o) {
        if (o == this) {
            return true;
        }
        if (o.isTupleType() && this.getArity() == o.getArity()) {
            for (int i = 0; i < this.getArity(); ++i) {
                if (this.getFieldType(i).isSubtypeOf(o.getFieldType(i))) continue;
                return false;
            }
            return true;
        }
        return super.isSubtypeOf(o);
    }

    private Type lubTupleTypes(Type t1, Type t2) {
        int N = t1.getArity();
        Type[] fieldTypes = new Type[N];
        String[] fieldNames = new String[N];
        for (int i = 0; i < N; ++i) {
            fieldTypes[i] = t1.getFieldType(i).lub(t2.getFieldType(i));
            if (t1.hasFieldNames()) {
                fieldNames[i] = t1.getFieldName(i);
                continue;
            }
            if (!t1.hasFieldNames()) continue;
            fieldNames[i] = t2.getFieldName(i);
        }
        return TypeFactory.getInstance().tupleType(fieldTypes);
    }

    private Type lubNamedTupleTypes(Type t1, Type t2) {
        int N = t1.getArity();
        Object[] fieldTypes = new Object[N * 2];
        boolean first = t1.hasFieldNames();
        int i = 0;
        int j = 0;
        while (i < N) {
            fieldTypes[j++] = t1.getFieldType(i).lub(t2.getFieldType(i));
            fieldTypes[j] = first ? t1.getFieldName(i) : t2.getFieldName(i);
            ++i;
            ++j;
        }
        return TypeFactory.getInstance().tupleType(fieldTypes);
    }

    @Override
    public Type lub(Type o) {
        if (o.isTupleType() && this.getArity() == o.getArity()) {
            if (this.hasFieldNames() || o.hasFieldNames()) {
                return this.lubNamedTupleTypes(this, o);
            }
            return this.lubTupleTypes(this, o);
        }
        return super.lub(o);
    }

    public int hashCode() {
        if (this.fHashcode == -1) {
            this.fHashcode = 55501;
            for (Type elemType : this.fFieldTypes) {
                this.fHashcode = this.fHashcode * 44927 + elemType.hashCode();
            }
        }
        return this.fHashcode;
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof TupleType)) {
            return false;
        }
        TupleType other = (TupleType)obj;
        if (this.fFieldTypes.length != other.fFieldTypes.length) {
            return false;
        }
        for (i = 0; i < this.fFieldTypes.length; ++i) {
            if (this.fFieldTypes[i] == other.fFieldTypes[i]) continue;
            return false;
        }
        if (this.fFieldNames != null) {
            if (other.fFieldNames == null) {
                return false;
            }
            for (i = 0; i < this.fFieldNames.length; ++i) {
                if (this.fFieldNames[i].equals(other.fFieldNames[i])) continue;
                return false;
            }
        } else if (other.fFieldNames != null) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tuple[");
        int idx = 0;
        for (Type elemType : this.fFieldTypes) {
            if (idx++ > 0) {
                sb.append(",");
            }
            sb.append(elemType.toString());
            if (!this.hasFieldNames()) continue;
            sb.append(" " + this.fFieldNames[idx - 1]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<Type> iterator() {
        return new Iterator<Type>(){
            private int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < TupleType.this.fFieldTypes.length;
            }

            @Override
            public Type next() {
                return TupleType.this.fFieldTypes[this.cursor++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitTuple(this);
    }

    @Override
    public IValue make(IValueFactory f) {
        return f.tuple();
    }

    @Override
    public IValue make(IValueFactory f, IValue ... elems) {
        return f.tuple(elems);
    }

    @Override
    public String getFieldName(int i) {
        return this.fFieldNames != null ? this.fFieldNames[i] : null;
    }

    @Override
    public void match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        super.match(matched, bindings);
        for (int i = 0; i < this.getArity(); ++i) {
            this.getFieldType(i).match(matched.getFieldType(i), bindings);
        }
    }

    @Override
    public Type instantiate(TypeStore store, Map<Type, Type> bindings) {
        if (this.hasFieldNames()) {
            Type[] fTypes = new Type[this.getArity()];
            String[] fLabels = new String[this.getArity()];
            for (int i = 0; i < fTypes.length; ++i) {
                fTypes[i] = this.getFieldType(i).instantiate(store, bindings);
                fLabels[i] = this.getFieldName(i);
            }
            return TypeFactory.getInstance().tupleType(fTypes, fLabels);
        }
        Type[] fChildren = new Type[this.getArity()];
        for (int i = 0; i < fChildren.length; ++i) {
            fChildren[i] = this.getFieldType(i).instantiate(store, bindings);
        }
        return TypeFactory.getInstance().tupleType(fChildren);
    }

    @Override
    public Type select(int ... fields) {
        int width = fields.length;
        if (width == 0) {
            return TypeFactory.getInstance().voidType();
        }
        if (width == 1) {
            return this.getFieldType(fields[0]);
        }
        if (!this.hasFieldNames()) {
            Type[] fieldTypes = new Type[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                fieldTypes[i] = this.getFieldType(fields[i]);
            }
            return TypeFactory.getInstance().tupleType(fieldTypes);
        }
        Type[] fieldTypes = new Type[fields.length];
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldTypes[i] = this.getFieldType(fields[i]);
            fieldNames[i] = this.getFieldName(fields[i]);
        }
        return TypeFactory.getInstance().tupleType(fieldTypes, fieldNames);
    }

    @Override
    public Type select(String ... names) {
        int[] indexes = new int[names.length];
        int i = 0;
        for (String name : names) {
            indexes[i] = this.getFieldIndex(name);
        }
        return this.select(indexes);
    }
}

