/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.visitors;

import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.IRelationWriter;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorAdapter;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BottomUpTransformer
extends VisitorAdapter<IValue> {
    protected IValueFactory fFactory;

    public BottomUpTransformer(IValueVisitor<IValue> visitor, IValueFactory factory) {
        super(visitor);
        this.fFactory = factory;
    }

    @Override
    public IValue visitNode(INode o) throws VisitorException {
        for (int i = 0; i < o.arity(); ++i) {
            o = o.set(i, o.get(i).accept(this));
        }
        return (IValue)this.fVisitor.visitNode(o);
    }

    @Override
    public IValue visitConstructor(IConstructor o) throws VisitorException {
        for (int i = 0; i < o.arity(); ++i) {
            o = o.set(i, o.get(i).accept(this));
        }
        return (IValue)this.fVisitor.visitConstructor(o);
    }

    @Override
    public IValue visitList(IList o) throws VisitorException {
        IListWriter w = this.fFactory.listWriter(o.getElementType());
        for (IValue elem : o) {
            w.append(elem.accept(this));
        }
        return (IValue)this.fVisitor.visitList(w.done());
    }

    @Override
    public IValue visitSet(ISet o) throws VisitorException {
        ISetWriter w = this.fFactory.setWriter(o.getElementType());
        for (IValue elem : o) {
            w.insert(elem.accept(this));
        }
        return (IValue)this.fVisitor.visitSet(w.done());
    }

    @Override
    public IValue visitMap(IMap o) throws VisitorException {
        IMapWriter w = this.fFactory.mapWriter(o.getKeyType(), o.getValueType());
        for (IValue elem : o) {
            w.put(elem.accept(this), o.get(elem).accept(this));
        }
        return (IValue)this.fVisitor.visitMap(w.done());
    }

    @Override
    public IValue visitRelation(IRelation o) throws VisitorException {
        IRelationWriter w = this.fFactory.relationWriter(o.getFieldTypes());
        for (IValue tuple : o) {
            w.insert((ITuple)tuple.accept(this));
        }
        return (IValue)this.fVisitor.visitRelation((IRelation)w.done());
    }

    @Override
    public IValue visitTuple(ITuple o) throws VisitorException {
        for (int i = 0; i < o.arity(); ++i) {
            o.set(i, o.get(i).accept(this));
        }
        return (IValue)this.fVisitor.visitTuple(o);
    }
}

