/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.xform.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IASTFindReplaceTarget;
import org.eclipse.imp.xform.XformPlugin;
import org.eclipse.imp.xform.pattern.matching.IASTMatcher;
import org.eclipse.imp.xform.pattern.matching.MatchResult;
import org.eclipse.imp.xform.pattern.matching.Matcher;
import org.eclipse.imp.xform.pattern.parser.ASTPatternLexer;
import org.eclipse.imp.xform.pattern.parser.ASTPatternParser;
import org.eclipse.imp.xform.pattern.parser.Ast.Pattern;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ASTFindReplaceDialog
extends Dialog {
    private static final int HISTORY_SIZE = 5;
    private IASTFindReplaceTarget fTarget = null;
    private Shell fParentShell = null;
    private Shell fActiveShell;
    private final ActivationListener fActivationListener = new ActivationListener();
    private final ModifyListener fFindModifyListener = new FindModifyListener();
    private Point fLocation;
    private Point fIncrementalBaseLocation;
    private boolean fWrapInit = false;
    private boolean fForwardInit = true;
    private boolean fGlobalInit = true;
    private boolean fIncrementalInit = false;
    private boolean fNeedsInitialFindBeforeReplace;
    private boolean fIsTargetEditable;
    private boolean fUseSelectedLines;
    private ContentAssistHandler fFindContentAssistHandler;
    private ContentAssistHandler fReplaceContentAssistHandler;
    private Rectangle fDialogPositionInit = null;
    private List fFindHistory = new ArrayList(4);
    private List fReplaceHistory = new ArrayList(4);
    private IRegion fOldScope;
    private Label fReplaceLabel;
    private Label fStatusLabel;
    private Button fForwardRadioButton;
    private Button fGlobalRadioButton;
    private Button fSelectedRangeRadioButton;
    private Button fWrapCheckBox;
    private Button fIncrementalCheckBox;
    private Button fReplaceSelectionButton;
    private Button fReplaceFindButton;
    private Button fFindNextButton;
    private Button fReplaceAllButton;
    private Combo fFindField;
    private Combo fReplaceField;
    private boolean fGiveFocusToFindField = true;
    private Color fProposalPopupBackgroundColor;
    private Color fProposalPopupForegroundColor;
    private IDialogSettings fDialogSettings;
    private IASTMatcher fASTAdapter;
    private Pattern fPattern;

    public ASTFindReplaceDialog(Shell parentShell) {
        super(parentShell);
        this.readConfiguration();
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
        ASTPatternParser.setASTAdapter(this.fASTAdapter);
    }

    public Shell getParentShell() {
        return super.getParentShell();
    }

    private void storeSettings() {
        this.fDialogPositionInit = this.getDialogBoundaries();
        this.fWrapInit = this.isWrapSearch();
        this.fIncrementalInit = this.isIncrementalSearch();
        this.fForwardInit = this.isForwardSearch();
        this.writeConfiguration();
    }

    private void setGridData(Control component, int horizontalAlignment, boolean grabExcessHorizontalSpace, int verticalAlignment, boolean grabExcessVerticalSpace) {
        GridData gd = new GridData();
        gd.horizontalAlignment = horizontalAlignment;
        gd.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        gd.verticalAlignment = verticalAlignment;
        gd.grabExcessVerticalSpace = grabExcessVerticalSpace;
        component.setLayoutData((Object)gd);
    }

    private IEditorStatusLine getStatusLineManager() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
        IEditorStatusLine statusLine = this.getStatusLineManager();
        if (statusLine != null) {
            statusLine.setMessage(error, message, null);
        }
        if (error) {
            this.getShell().getDisplay().beep();
        }
    }

    private void statusError(String message) {
        this.statusMessage(true, message);
    }

    private void statusMessage(String message) {
        this.statusMessage(false, message);
    }

    private void updateButtonState() {
        this.updateButtonState(false);
    }

    private void updateButtonState(boolean disableReplace) {
        if (this.okToUse((Control)this.getShell()) && this.okToUse((Control)this.fFindNextButton)) {
            boolean selection = false;
            if (this.fTarget != null) {
                String selectedText = this.fTarget.getSelectionText();
                selection = selectedText != null && selectedText.length() > 0;
            }
            boolean enable = this.fTarget != null && (this.fActiveShell == this.fParentShell || this.fActiveShell == this.getShell());
            String str = this.getFindString();
            boolean findString = str != null && str.length() > 0;
            this.fFindNextButton.setEnabled(enable && findString);
            this.fReplaceSelectionButton.setEnabled(!disableReplace && enable && this.isEditable() && selection && !this.fNeedsInitialFindBeforeReplace);
            this.fReplaceFindButton.setEnabled(!disableReplace && enable && this.isEditable() && findString && selection && !this.fNeedsInitialFindBeforeReplace);
            this.fReplaceAllButton.setEnabled(enable && this.isEditable() && findString);
        }
    }

    private boolean okToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    private Composite createConfigPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        Composite directionGroup = this.createDirectionGroup(panel);
        this.setGridData((Control)directionGroup, 4, true, 4, false);
        Composite scopeGroup = this.createScopeGroup(panel);
        this.setGridData((Control)scopeGroup, 4, true, 4, false);
        Composite optionsGroup = this.createOptionsGroup(panel);
        this.setGridData((Control)optionsGroup, 4, true, 4, false);
        GridData data = (GridData)optionsGroup.getLayoutData();
        data.horizontalSpan = 2;
        optionsGroup.setLayoutData((Object)data);
        return panel;
    }

    private Composite createOptionsGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 32);
        group.setText("Options");
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        groupLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(1808));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ASTFindReplaceDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fWrapCheckBox = new Button((Composite)group, 16416);
        this.fWrapCheckBox.setText("Wr&ap Search");
        this.setGridData((Control)this.fWrapCheckBox, 1, false, 2, false);
        this.fWrapCheckBox.setSelection(this.fWrapInit);
        this.fWrapCheckBox.addSelectionListener(selectionListener);
        this.fIncrementalCheckBox = new Button((Composite)group, 16416);
        this.fIncrementalCheckBox.setText("&Incremental");
        this.setGridData((Control)this.fIncrementalCheckBox, 1, false, 2, false);
        this.fIncrementalCheckBox.setSelection(this.fIncrementalInit);
        this.fIncrementalCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ASTFindReplaceDialog.this.isIncrementalSearch()) {
                    ASTFindReplaceDialog.this.initIncrementalBaseLocation();
                }
                ASTFindReplaceDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fIncrementalCheckBox.setSelection(false);
        this.fIncrementalCheckBox.setEnabled(false);
        return panel;
    }

    private void initIncrementalBaseLocation() {
        this.fIncrementalBaseLocation = this.fTarget != null && this.isIncrementalSearch() ? this.fTarget.getSelection() : new Point(0, 0);
    }

    private Composite createDirectionGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText("Direction");
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(1808));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ASTFindReplaceDialog.this.isIncrementalSearch()) {
                    ASTFindReplaceDialog.this.initIncrementalBaseLocation();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fForwardRadioButton = new Button((Composite)group, 16400);
        this.fForwardRadioButton.setText("F&orward");
        this.setGridData((Control)this.fForwardRadioButton, 1, false, 2, false);
        this.fForwardRadioButton.addSelectionListener(selectionListener);
        Button backwardRadioButton = new Button((Composite)group, 16400);
        backwardRadioButton.setText("&Backward");
        this.setGridData((Control)backwardRadioButton, 1, false, 2, false);
        backwardRadioButton.addSelectionListener(selectionListener);
        backwardRadioButton.setSelection(!this.fForwardInit);
        this.fForwardRadioButton.setSelection(this.fForwardInit);
        return panel;
    }

    private Composite createScopeGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText("Scope");
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(1808));
        this.fGlobalRadioButton = new Button((Composite)group, 16400);
        this.fGlobalRadioButton.setText("All");
        this.setGridData((Control)this.fGlobalRadioButton, 1, false, 2, false);
        this.fGlobalRadioButton.setSelection(this.fGlobalInit);
        this.fGlobalRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ASTFindReplaceDialog.this.fGlobalRadioButton.getSelection() || !ASTFindReplaceDialog.this.fUseSelectedLines) {
                    return;
                }
                ASTFindReplaceDialog.this.fUseSelectedLines = false;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fSelectedRangeRadioButton = new Button((Composite)group, 16400);
        this.fSelectedRangeRadioButton.setText("Selected lines");
        this.setGridData((Control)this.fSelectedRangeRadioButton, 1, false, 2, false);
        this.fSelectedRangeRadioButton.setSelection(!this.fGlobalInit);
        this.fUseSelectedLines = !this.fGlobalInit;
        this.fSelectedRangeRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ASTFindReplaceDialog.this.fSelectedRangeRadioButton.getSelection() || ASTFindReplaceDialog.this.fUseSelectedLines) {
                    return;
                }
                ASTFindReplaceDialog.this.fUseSelectedLines = true;
                ASTFindReplaceDialog.this.useSelectedLines(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return panel;
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.addShellListener((ShellListener)this.fActivationListener);
        if (this.fLocation != null) {
            shell.setLocation(this.fLocation);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.find_replace_dialog_context");
        this.fFindField.removeModifyListener(this.fFindModifyListener);
        this.updateCombo(this.fFindField, this.fFindHistory);
        this.fFindField.addModifyListener(this.fFindModifyListener);
        this.updateCombo(this.fReplaceField, this.fReplaceHistory);
        this.initFindString();
        if (this.fDialogPositionInit != null) {
            shell.setBounds(this.fDialogPositionInit);
        }
        shell.setText("AST Find/Replace");
    }

    private void initFindString() {
        if (this.fTarget != null && this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener(this.fFindModifyListener);
            if ("".equals(this.fFindField.getText())) {
                if (this.fFindHistory.size() > 0) {
                    this.fFindField.setText((String)this.fFindHistory.get(0));
                } else {
                    this.fFindField.setText("");
                }
            }
            this.fFindField.setSelection(new Point(0, this.fFindField.getText().length()));
            this.fFindField.addModifyListener(this.fFindModifyListener);
            this.fPattern = this.parsePattern(this.getFindString());
        }
    }

    private void useSelectedLines(boolean selectedLines) {
        if (this.isIncrementalSearch()) {
            this.initIncrementalBaseLocation();
        }
        if (this.fTarget == null || !(this.fTarget instanceof IFindReplaceTargetExtension)) {
            return;
        }
        IFindReplaceTargetExtension extensionTarget = (IFindReplaceTargetExtension)this.fTarget;
        if (selectedLines) {
            IRegion scope;
            if (this.fOldScope == null) {
                Point lineSelection = extensionTarget.getLineSelection();
                scope = new Region(lineSelection.x, lineSelection.y);
            } else {
                scope = this.fOldScope;
                this.fOldScope = null;
            }
            int offset = this.isForwardSearch() ? scope.getOffset() : scope.getOffset() + scope.getLength();
            extensionTarget.setSelection(offset, 0);
            extensionTarget.setScope(scope);
        } else {
            this.fOldScope = extensionTarget.getScope();
            extensionTarget.setScope(null);
        }
    }

    private void updateCombo(Combo combo, List content) {
        combo.removeAll();
        for (int i = 0; i < content.size(); ++i) {
            combo.add(content.get(i).toString());
        }
    }

    protected Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        Composite inputPanel = this.createInputPanel(panel);
        this.setGridData((Control)inputPanel, 4, true, 2, false);
        Composite configPanel = this.createConfigPanel(panel);
        this.setGridData((Control)configPanel, 4, true, 2, true);
        Composite buttonPanelB = this.createButtonSection(panel);
        this.setGridData((Control)buttonPanelB, 4, true, 2, false);
        Composite statusBar = this.createStatusAndCloseButton(panel);
        this.setGridData((Control)statusBar, 4, true, 2, false);
        this.updateButtonState();
        ASTFindReplaceDialog.applyDialogFont((Control)panel);
        return panel;
    }

    private Button makeButton(Composite parent, String label, int id, boolean dfltButton, SelectionListener listener) {
        Button b = this.createButton(parent, id, label, dfltButton);
        b.addSelectionListener(listener);
        return b;
    }

    private Composite createButtonSection(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = -2;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        this.fFindNextButton = this.makeButton(panel, "Find &Next", 102, true, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ASTFindReplaceDialog.this.isIncrementalSearch()) {
                    ASTFindReplaceDialog.this.initIncrementalBaseLocation();
                }
                ASTFindReplaceDialog.this.fNeedsInitialFindBeforeReplace = false;
                ASTFindReplaceDialog.this.performSearch();
                ASTFindReplaceDialog.this.updateFindHistory();
                ASTFindReplaceDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fFindNextButton, 4, true, 4, false);
        this.fReplaceFindButton = this.makeButton(panel, "Replace/Fin&d", 103, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ASTFindReplaceDialog.this.fNeedsInitialFindBeforeReplace) {
                    ASTFindReplaceDialog.this.performSearch();
                }
                if (ASTFindReplaceDialog.this.performReplaceSelection()) {
                    ASTFindReplaceDialog.this.performSearch();
                }
                ASTFindReplaceDialog.this.updateFindAndReplaceHistory();
                ASTFindReplaceDialog.this.fReplaceFindButton.setFocus();
            }
        });
        this.setGridData((Control)this.fReplaceFindButton, 4, true, 4, false);
        this.fReplaceSelectionButton = this.makeButton(panel, "&Replace", 104, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ASTFindReplaceDialog.this.fNeedsInitialFindBeforeReplace) {
                    ASTFindReplaceDialog.this.performSearch();
                }
                ASTFindReplaceDialog.this.performReplaceSelection();
                ASTFindReplaceDialog.this.updateFindAndReplaceHistory();
                ASTFindReplaceDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fReplaceSelectionButton, 4, true, 4, false);
        this.fReplaceAllButton = this.makeButton(panel, "Replace &All", 105, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASTFindReplaceDialog.this.performReplaceAll();
                ASTFindReplaceDialog.this.updateFindAndReplaceHistory();
                ASTFindReplaceDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fReplaceAllButton, 4, true, 4, false);
        this.fReplaceAllButton.setEnabled(this.isEditable());
        return panel;
    }

    private Composite createInputPanel(Composite parent) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ASTFindReplaceDialog.this.updateButtonState();
            }
        };
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label findLabel = new Label(panel, 16384);
        findLabel.setText("&Find:");
        this.setGridData((Control)findLabel, 1, false, 2, false);
        this.fFindField = new Combo(panel, 2052);
        this.setGridData((Control)this.fFindField, 4, true, 2, false);
        this.fFindField.addModifyListener(this.fFindModifyListener);
        this.fReplaceLabel = new Label(panel, 16384);
        this.fReplaceLabel.setText("Replace &with:");
        this.setGridData((Control)this.fReplaceLabel, 1, false, 2, false);
        this.fReplaceField = new Combo(panel, 2052);
        this.setGridData((Control)this.fReplaceField, 4, true, 2, false);
        this.fReplaceField.addModifyListener(listener);
        return panel;
    }

    private Composite createStatusAndCloseButton(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        this.fStatusLabel = new Label(panel, 16384);
        this.setGridData((Control)this.fStatusLabel, 4, true, 2, false);
        String label = "Close";
        Button closeButton = this.createButton(panel, 101, label, false);
        this.setGridData((Control)closeButton, 3, false, 3, false);
        return panel;
    }

    protected void buttonPressed(int buttonID) {
        if (buttonID == 101) {
            this.close();
        }
    }

    private void updateFindAndReplaceHistory() {
        this.updateFindHistory();
        if (this.okToUse((Control)this.fReplaceField)) {
            this.updateHistory(this.fReplaceField, this.fReplaceHistory);
        }
    }

    private void updateFindHistory() {
        if (this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener(this.fFindModifyListener);
            this.updateHistory(this.fFindField, this.fFindHistory);
            this.fFindField.addModifyListener(this.fFindModifyListener);
        }
    }

    private void updateHistory(Combo combo, List history) {
        String findString = combo.getText();
        int index = history.indexOf(findString);
        if (index != 0) {
            if (index != -1) {
                history.remove(index);
            }
            history.add(0, findString);
            this.updateCombo(combo, history);
            combo.setText(findString);
        }
    }

    private boolean isEditable() {
        boolean isEditable = this.fTarget == null ? false : this.fTarget.isEditable();
        return this.fIsTargetEditable && isEditable;
    }

    private boolean isForwardSearch() {
        if (this.okToUse((Control)this.fForwardRadioButton)) {
            return this.fForwardRadioButton.getSelection();
        }
        return this.fForwardInit;
    }

    private boolean isWrapSearch() {
        if (this.okToUse((Control)this.fWrapCheckBox)) {
            return this.fWrapCheckBox.getSelection();
        }
        return this.fWrapInit;
    }

    private boolean isIncrementalSearch() {
        if (this.okToUse((Control)this.fIncrementalCheckBox)) {
            return this.fIncrementalCheckBox.getSelection();
        }
        return this.fIncrementalInit;
    }

    private Rectangle getDialogBoundaries() {
        if (this.okToUse((Control)this.getShell())) {
            return this.getShell().getBounds();
        }
        return this.fDialogPositionInit;
    }

    private List getFindHistory() {
        return this.fFindHistory;
    }

    private String getFindString() {
        if (this.okToUse((Control)this.fFindField)) {
            return this.fFindField.getText();
        }
        return "";
    }

    private List getReplaceHistory() {
        return this.fReplaceHistory;
    }

    private String getReplaceString() {
        if (this.okToUse((Control)this.fReplaceField)) {
            return this.fReplaceField.getText();
        }
        return "";
    }

    private void performSearch() {
        this.performSearch(this.isIncrementalSearch());
    }

    private void performSearch(boolean incremental) {
        IParseController parseController = this.fTarget.getParseController();
        Object srcAST = parseController.getCurrentAst();
        Point curSel = this.fTarget.getSelection();
        Matcher matcher = new Matcher(this.fPattern);
        int endSelPos = curSel.x + curSel.y;
        MatchResult m = this.fASTAdapter.findNextMatch(matcher, srcAST, endSelPos);
        if (m == null && this.isWrapSearch()) {
            m = this.fASTAdapter.findNextMatch(matcher, srcAST, -1);
        }
        if (m != null) {
            int matchPos = this.fASTAdapter.getOffset(m.getMatchNode());
            int matchLen = this.fASTAdapter.getLength(m.getMatchNode());
            this.fStatusLabel.setText("Found match at " + matchPos);
            ((ITextEditor)this.fTarget).selectAndReveal(matchPos, matchLen);
        } else {
            this.fStatusLabel.setText("No match");
        }
    }

    private Pattern parsePattern(String patternStr) {
        ASTPatternLexer lexer = new ASTPatternLexer(patternStr.toCharArray(), "__PATTERN__");
        ASTPatternParser parser = new ASTPatternParser(lexer.getLexStream());
        lexer.lexer(parser.getIPrsStream());
        return (Pattern)parser.parser();
    }

    protected void performReplaceAll() {
    }

    protected boolean performReplaceSelection() {
        return false;
    }

    private void findAndSelect(int offset, String string, boolean b) {
    }

    private void setContentAssistsEnablement(boolean enable) {
        if (enable) {
            if (this.fFindContentAssistHandler == null) {
                this.fFindContentAssistHandler = ContentAssistHandler.createHandlerForCombo((Combo)this.fFindField, (SubjectControlContentAssistant)this.createContentAssistant(true));
                this.fReplaceContentAssistHandler = ContentAssistHandler.createHandlerForCombo((Combo)this.fReplaceField, (SubjectControlContentAssistant)this.createContentAssistant(false));
            }
            this.fFindContentAssistHandler.setEnabled(true);
            this.fReplaceContentAssistHandler.setEnabled(true);
        } else {
            if (this.fFindContentAssistHandler == null) {
                return;
            }
            this.fFindContentAssistHandler.setEnabled(false);
            this.fReplaceContentAssistHandler.setEnabled(false);
        }
    }

    private SubjectControlContentAssistant createContentAssistant(boolean isFind) {
        SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
        contentAssistant.setRestoreCompletionProposalSize(this.getSettings("FindReplaceDialog.completion_proposal_size"));
        contentAssistant.enableAutoActivation(true);
        contentAssistant.setProposalSelectorBackground(this.fProposalPopupBackgroundColor);
        contentAssistant.setProposalSelectorForeground(this.fProposalPopupForegroundColor);
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        return contentAssistant;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = XformPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        String[] replaceHistory;
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.fLocation = new Point(x, y);
        }
        catch (NumberFormatException e) {
            this.fLocation = null;
        }
        this.fWrapInit = s.getBoolean("wrap");
        this.fIncrementalInit = s.getBoolean("incremental");
        String[] findHistory = s.getArray("findhistory");
        if (findHistory != null) {
            List history = this.getFindHistory();
            history.clear();
            for (int i = 0; i < findHistory.length; ++i) {
                history.add(findHistory[i]);
            }
        }
        if ((replaceHistory = s.getArray("replacehistory")) != null) {
            List history = this.getReplaceHistory();
            history.clear();
            for (int i = 0; i < replaceHistory.length; ++i) {
                history.add(replaceHistory[i]);
            }
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        s.put("wrap", this.fWrapInit);
        s.put("incremental", this.fIncrementalInit);
        List history = this.getFindHistory();
        while (history.size() > 8) {
            history.remove(8);
        }
        String[] names = new String[history.size()];
        history.toArray(names);
        s.put("findhistory", names);
        history = this.getReplaceHistory();
        while (history.size() > 8) {
            history.remove(8);
        }
        names = new String[history.size()];
        history.toArray(names);
        s.put("replacehistory", names);
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings pluginDialogSettings = XformPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = pluginDialogSettings.getSection(sectionName);
        if (settings == null) {
            settings = pluginDialogSettings.addNewSection(sectionName);
        }
        return settings;
    }

    public void updateTarget(IASTFindReplaceTarget target, boolean isTargetEditable, boolean initializeFindString) {
        this.fIsTargetEditable = isTargetEditable;
        this.fNeedsInitialFindBeforeReplace = true;
        if (target != this.fTarget) {
            if (this.fTarget != null && this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).endSession();
            }
            this.fTarget = target;
            if (this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).beginSession();
                this.fGlobalInit = true;
                this.fGlobalRadioButton.setSelection(this.fGlobalInit);
                this.fSelectedRangeRadioButton.setSelection(!this.fGlobalInit);
                this.fUseSelectedLines = !this.fGlobalInit;
            } else if (this.fTarget == null) {
                this.updateButtonState();
            }
        }
        if (this.fTarget != null) {
            IEditorInput editorInput = ((ITextEditor)this.fTarget).getEditorInput();
            TextFileDocumentProvider tfdp = new TextFileDocumentProvider();
            this.fASTAdapter = (IASTMatcher)ServiceFactory.getInstance().getASTAdapter(LanguageRegistry.findLanguage((IEditorInput)editorInput, (IDocumentProvider)tfdp));
            ASTPatternParser.setASTAdapter(this.fASTAdapter);
        }
        if (this.okToUse((Control)this.fReplaceLabel)) {
            this.fReplaceLabel.setEnabled(this.isEditable());
            this.fReplaceField.setEnabled(this.isEditable());
            if (initializeFindString) {
                this.initFindString();
                this.fGiveFocusToFindField = true;
            }
            this.initIncrementalBaseLocation();
            this.updateButtonState();
        }
        this.setContentAssistsEnablement(true);
    }

    private class FindModifyListener
    implements ModifyListener {
        private FindModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ASTFindReplaceDialog.this.fPattern = ASTFindReplaceDialog.this.parsePattern(ASTFindReplaceDialog.this.getFindString());
            if (ASTFindReplaceDialog.this.fPattern == null) {
                ASTFindReplaceDialog.this.statusError("Invalid AST pattern");
                return;
            }
            ASTFindReplaceDialog.this.statusMessage("");
            if (ASTFindReplaceDialog.this.isIncrementalSearch()) {
                if (ASTFindReplaceDialog.this.fFindField.getText().equals("") && ASTFindReplaceDialog.this.fTarget != null) {
                    int offset = ((ASTFindReplaceDialog)ASTFindReplaceDialog.this).fIncrementalBaseLocation.x;
                    if (ASTFindReplaceDialog.this.isForwardSearch() && !ASTFindReplaceDialog.this.fNeedsInitialFindBeforeReplace || !ASTFindReplaceDialog.this.isForwardSearch() && ASTFindReplaceDialog.this.fNeedsInitialFindBeforeReplace) {
                        offset += ((ASTFindReplaceDialog)ASTFindReplaceDialog.this).fIncrementalBaseLocation.y;
                    }
                    ASTFindReplaceDialog.this.fNeedsInitialFindBeforeReplace = false;
                    ASTFindReplaceDialog.this.findAndSelect(offset, "", ASTFindReplaceDialog.this.isForwardSearch());
                } else {
                    ASTFindReplaceDialog.this.performSearch(false);
                }
            }
            ASTFindReplaceDialog.this.updateButtonState(!ASTFindReplaceDialog.this.isIncrementalSearch());
        }
    }

    class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent e) {
            ASTFindReplaceDialog.this.fActiveShell = (Shell)e.widget;
            ASTFindReplaceDialog.this.updateButtonState();
            if (ASTFindReplaceDialog.this.fGiveFocusToFindField && ASTFindReplaceDialog.this.getShell() == ASTFindReplaceDialog.this.fActiveShell && ASTFindReplaceDialog.this.okToUse((Control)ASTFindReplaceDialog.this.fFindField)) {
                ASTFindReplaceDialog.this.fFindField.setFocus();
            }
        }

        public void shellDeactivated(ShellEvent e) {
            ASTFindReplaceDialog.this.fGiveFocusToFindField = false;
            ASTFindReplaceDialog.this.storeSettings();
            ASTFindReplaceDialog.this.fGlobalRadioButton.setSelection(true);
            ASTFindReplaceDialog.this.fSelectedRangeRadioButton.setSelection(false);
            ASTFindReplaceDialog.this.fUseSelectedLines = false;
            ASTFindReplaceDialog.this.fOldScope = null;
            ASTFindReplaceDialog.this.fActiveShell = null;
            ASTFindReplaceDialog.this.updateButtonState();
        }
    }
}

