/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.imp.builder.MarkerCreator;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.prefspecs.PrefspecsPlugin;
import org.eclipse.imp.prefspecs.compiler.codegen.PreferencesFactory;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteBooleanFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteColorFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteComboFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteDirListFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteDoubleFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteFileFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteFontFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteIntFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteRadioFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.ConcreteStringFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.PreferencesPageInfo;
import org.eclipse.imp.prefspecs.pageinfo.PreferencesTabInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualBooleanFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualColorFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualComboFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualDirListFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualDoubleFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualFileFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualFontFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualIntFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualRadioFieldInfo;
import org.eclipse.imp.prefspecs.pageinfo.VirtualStringFieldInfo;
import org.eclipse.imp.prefspecs.parser.Ast.ASTNode;
import org.eclipse.imp.prefspecs.parser.Ast.ASTNodeToken;
import org.eclipse.imp.prefspecs.parser.Ast.AbstractVisitor;
import org.eclipse.imp.prefspecs.parser.Ast.IbooleanValue;
import org.eclipse.imp.prefspecs.parser.Ast.IfontStyle;
import org.eclipse.imp.prefspecs.parser.Ast.IsignedNumber;
import org.eclipse.imp.prefspecs.parser.Ast.IstringEmptySpec;
import org.eclipse.imp.prefspecs.parser.Ast.ItypeOrValuesSpec;
import org.eclipse.imp.prefspecs.parser.Ast.booleanDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.booleanFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.booleanFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.booleanSpecialSpec;
import org.eclipse.imp.prefspecs.parser.Ast.colorDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.colorFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.colorFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.columnsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.comboCustomSpec;
import org.eclipse.imp.prefspecs.parser.Ast.comboDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.comboFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.comboFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.comboSpecificSpec;
import org.eclipse.imp.prefspecs.parser.Ast.conditionType0;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalSpec0;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalSpec1;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalSpecs0;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalSpecs1;
import org.eclipse.imp.prefspecs.parser.Ast.configurationTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.customRule;
import org.eclipse.imp.prefspecs.parser.Ast.defaultTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.dirListFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.dirlistFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.doubleDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.doubleFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.doubleFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.doubleRangeSpec;
import org.eclipse.imp.prefspecs.parser.Ast.doubleSpecificSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fileFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.fileFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fontDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fontFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.fontFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fontStyle0;
import org.eclipse.imp.prefspecs.parser.Ast.fontStyle1;
import org.eclipse.imp.prefspecs.parser.Ast.fontStyle2;
import org.eclipse.imp.prefspecs.parser.Ast.generalSpecs;
import org.eclipse.imp.prefspecs.parser.Ast.instanceTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intCustomSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.intFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intRangeSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intSpecialSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intSpecificSpec;
import org.eclipse.imp.prefspecs.parser.Ast.isEditableSpec;
import org.eclipse.imp.prefspecs.parser.Ast.isRemovableSpec;
import org.eclipse.imp.prefspecs.parser.Ast.labelledStringValue;
import org.eclipse.imp.prefspecs.parser.Ast.labelledStringValueList;
import org.eclipse.imp.prefspecs.parser.Ast.optConditionalSpec;
import org.eclipse.imp.prefspecs.parser.Ast.optDetailsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.optLabelSpec;
import org.eclipse.imp.prefspecs.parser.Ast.optPackageSpec;
import org.eclipse.imp.prefspecs.parser.Ast.optToolTipSpec;
import org.eclipse.imp.prefspecs.parser.Ast.pageSpec;
import org.eclipse.imp.prefspecs.parser.Ast.projectTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.radioCustomSpec;
import org.eclipse.imp.prefspecs.parser.Ast.radioDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.radioFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.radioFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.radioSpecificSpec;
import org.eclipse.imp.prefspecs.parser.Ast.sign1;
import org.eclipse.imp.prefspecs.parser.Ast.signedNumber0;
import org.eclipse.imp.prefspecs.parser.Ast.signedNumber1;
import org.eclipse.imp.prefspecs.parser.Ast.stringCustomSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringEmptySpec0;
import org.eclipse.imp.prefspecs.parser.Ast.stringEmptySpec1;
import org.eclipse.imp.prefspecs.parser.Ast.stringFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.stringFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringSpecialSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringSpecificSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringValidatorSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringValue;
import org.eclipse.imp.prefspecs.parser.Ast.typeOrValuesSpec0;
import org.eclipse.imp.prefspecs.parser.Ast.typeOrValuesSpec1;
import org.eclipse.imp.prefspecs.parser.Ast.typeSpec;
import org.eclipse.imp.prefspecs.parser.PrefspecsParseController;
import org.eclipse.imp.prefspecs.parser.PrefspecsParser;
import org.eclipse.imp.wizards.CodeServiceWizard;
import org.eclipse.imp.wizards.ExtensionPointEnabler;
import org.eclipse.imp.wizards.ExtensionPointWizard;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.plugin.ImpPluginElement;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefspecsCompiler {
    protected IProject fProject = null;
    protected String fProjectName = null;
    protected String fLanguageName = null;
    protected List<PreferencesPageInfo> fPages = new ArrayList<PreferencesPageInfo>();
    protected PreferencesPageInfo fPageInfo = null;
    protected IFile fPageInfoFile = null;
    protected String fPageClassNameBase = null;
    protected String fPageId = null;
    protected String fAlternativeMessage = null;
    protected String fPageName = null;
    protected String fPageMenuItem = null;
    protected String fPagePackageName = null;
    protected boolean fNoDetails = false;
    private IFile fSpecFile;
    private Map<String, LabelledValueDescriptor> fTypeMap = new HashMap<String, LabelledValueDescriptor>();
    private final MessageConsoleStream fConsoleStream;
    public static String PROBLEM_MARKER_ID = "org.eclipse.imp.prefspecs.problem";

    public PrefspecsCompiler(String problem_marker_id, MessageConsoleStream messageConsoleStream) {
        PROBLEM_MARKER_ID = problem_marker_id;
        this.fConsoleStream = messageConsoleStream;
    }

    public List<PreferencesPageInfo> getPreferencesPageInfos(IFile specFile) {
        this.computePreferencesPageInfo(specFile);
        return this.fPages;
    }

    protected void computePreferencesPageInfo(IFile specFile) {
        IProject project;
        if (specFile == null) {
            this.fConsoleStream.println("PrefspecsCompiler.computePreferencesPageInfo(..):  returning null");
        }
        if ((project = specFile.getProject()) == null) {
            this.fConsoleStream.println("PrefspecsCompiler.computePreferencesPageInfo(..):  Project is null; returning null");
        }
        ISourceProject sourceProject = null;
        try {
            sourceProject = ModelFactory.open((IProject)project);
        }
        catch (ModelFactory.ModelException me) {
            this.fConsoleStream.println("PrefspecsCompiler.computePreferencesPageInfo(..):  Model exception:\n" + me.getMessage() + "\nReturning null");
        }
        PrefspecsParseController parseController = new PrefspecsParseController();
        MarkerCreator markerCreator = new MarkerCreator(specFile, (IParseController)parseController, PROBLEM_MARKER_ID);
        parseController.getAnnotationTypeInfo().addProblemMarkerType(PROBLEM_MARKER_ID);
        parseController.initialize(specFile.getProjectRelativePath(), sourceProject, (IMessageHandler)markerCreator);
        parseController.parse(this.getFileContents(specFile), false, (IProgressMonitor)new NullProgressMonitor());
        ASTNode currentAst = (ASTNode)parseController.getCurrentAst();
        if (currentAst == null) {
            this.fConsoleStream.println("PrefspecsCompiler.computePreferencesPageInfo:  current AST is null (parse errors?); unable to compute page info.");
            return;
        }
        TranslatorVisitor visitor = new TranslatorVisitor();
        currentAst.accept(visitor);
    }

    public boolean findClass(String validatorQualClass) {
        IJavaProject javaProj = JavaCore.create((IProject)this.fProject);
        String validatorPathSuffix = validatorQualClass.replace('.', File.separatorChar);
        try {
            return javaProj.findElement(new Path(validatorPathSuffix).addFileExtension("java")) != null;
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    private List<IClasspathEntry> getSourceCPEntries(IJavaProject javaProj) {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] cpEntries = javaProj.getResolvedClasspath(true);
            for (int i = 0; i < cpEntries.length; ++i) {
                if (cpEntries[i].getEntryKind() != 3) continue;
                result.add(cpEntries[i]);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return result;
    }

    public String getFileContents(IFile file) {
        char[] buf = null;
        try {
            File javaFile = new File(file.getLocation().toOSString());
            FileReader fileReader = new FileReader(javaFile);
            int len = (int)javaFile.length();
            buf = new char[len];
            fileReader.read(buf, 0, len);
            return new String(buf);
        }
        catch (FileNotFoundException fnf) {
            this.fConsoleStream.println(fnf.getMessage());
            return "";
        }
        catch (IOException io) {
            this.fConsoleStream.println(io.getMessage());
            return "";
        }
    }

    public PreferencesPageInfo compile(IFile file, IProgressMonitor mon) {
        this.performGeneration(file, mon);
        return null;
    }

    public boolean performGeneration(final IFile specFile, final IProgressMonitor mon) {
        this.fSpecFile = specFile;
        IWorkspaceRunnable wsop = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                BundlePluginModel bpm;
                IBundleModel bm;
                IProject project;
                IPluginModel pluginModel;
                PrefspecsCompiler.this.getGenerationParameters(specFile);
                PrefspecsCompiler.this.collectCodeParms(specFile);
                if (PrefspecsCompiler.this.fPageId == null) {
                    PrefspecsCompiler.this.fPageId = PrefspecsCompiler.this.fPagePackageName;
                }
                if ((pluginModel = ExtensionPointEnabler.getPluginModel((IProject)(project = specFile.getProject()))) instanceof BundlePluginModel && (bm = (bpm = (BundlePluginModel)pluginModel).getBundleModel()) instanceof WorkspaceBundleModel) {
                    ((WorkspaceBundleModel)bm).setEditable(true);
                }
                ExtensionPointEnabler.loadImpExtensionsModel((IPluginModel)pluginModel, (IProject)project);
                IExtensions pmExtensions = pluginModel.getExtensions();
                IPluginExtension[] pluginExtensions = pmExtensions.getExtensions();
                for (int i = 0; i < pluginExtensions.length; ++i) {
                    IPluginExtension pluginExtension = pluginExtensions[i];
                    if (pluginExtension == null || pluginExtension.getPoint() == null) continue;
                    String point = "org.eclipse.ui.preferencePages";
                    if (pluginExtension.getPoint() == null || !pluginExtension.getPoint().equals(point)) continue;
                    IPluginObject[] children = pluginExtension.getChildren();
                    for (int j = 0; j < children.length; ++j) {
                        ImpPluginElement ipe;
                        IPluginAttribute pa;
                        if (!children[j].getName().equals("page") || (pa = (ipe = (ImpPluginElement)children[j]).getAttribute("id")) == null || !pa.getValue().startsWith(PrefspecsCompiler.this.fPageId)) continue;
                        pmExtensions.remove(pluginExtension);
                    }
                }
                ExtensionPointEnabler.saveAndRefresh((IPluginModel)pluginModel);
                PrefspecsCompiler.this.generateCodeStubs(specFile, mon);
                for (PreferencesPageInfo pageInfo : PrefspecsCompiler.this.fPages) {
                    String pageName2 = pageInfo.getPageName();
                    int lastCompIdx = pageName2.indexOf(46) > 0 ? pageName2.lastIndexOf(46) + 1 : 0;
                    String pageParent = lastCompIdx > 0 ? PrefspecsCompiler.this.fPageId + "." + pageName2.substring(0, lastCompIdx - 1) : "";
                    String pageLabel = pageName2.substring(lastCompIdx);
                    ExtensionPointEnabler.enable((IProject)specFile.getProject(), (String)"org.eclipse.ui", (String)"preferencePages", (String[][])new String[][]{{"page:id", PrefspecsCompiler.this.fPageId + "." + pageName2}, {"page:name", pageLabel}, {"page:class", PrefspecsCompiler.this.fPagePackageName + "." + pageName2.replaceAll("\\.", "") + "PreferencePage"}, {"page:category", pageParent}}, (boolean)false, PrefspecsCompiler.this.getPluginDependencies(), (IProgressMonitor)monitor);
                }
            }
        };
        try {
            wsop.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ErrorHandler.reportError((String)"PrefspecsCompiler.performGeneration:  CoreException:  ", (Throwable)e);
        }
        return true;
    }

    protected void collectCodeParms(IFile file) {
        this.fProject = file.getProject();
        this.fProjectName = this.fProject.getName();
        IPath filePath = file.getLocation();
        IPath projectPath = file.getProject().getLocation();
        IPath packagePath = filePath.removeFirstSegments(projectPath.segmentCount() + this.getProjectSourceLocationPath().segmentCount());
        packagePath = packagePath.removeLastSegments(1);
        this.fPagePackageName = packagePath.toString();
        this.fPagePackageName = this.fPagePackageName.substring(this.fPagePackageName.indexOf(58) + 1);
        this.fPagePackageName = this.fPagePackageName.replace('\\', '.');
        this.fPagePackageName = this.fPagePackageName.replace('/', '.');
        this.fLanguageName = CodeServiceWizard.discoverProjectLanguage((IProject)file.getProject());
    }

    protected void getGenerationParameters(IFile file) throws CoreException {
        IFile genParamsFile = null;
        IContainer parent = file.getParent();
        IResource[] siblings = parent.members();
        for (int i = 0; i < siblings.length; ++i) {
            if (!siblings[i].getName().endsWith(".genparams")) continue;
            genParamsFile = (IFile)siblings[i];
            break;
        }
        if (genParamsFile == null) {
            this.fConsoleStream.println("PrefspecsCompiler.getGenerationParameters:  no parameters file found located with specification file = " + file.getName());
            return;
        }
        try {
            String line;
            File f = new File(genParamsFile.getLocation().toOSString());
            BufferedReader rdr = new BufferedReader(new FileReader(f));
            while ((line = rdr.readLine()) != null) {
                if (line.endsWith("\n")) {
                    line = line.substring(0, line.length() - 1);
                }
                int valStart = line.indexOf("=") + 1;
                if (line.startsWith("PageClassNameBase")) {
                    this.fPageClassNameBase = line.substring(valStart);
                } else if (line.startsWith("PageName")) {
                    this.fPageName = line.substring(valStart);
                }
                if (line.startsWith("PageId")) {
                    this.fPageId = line.substring(valStart);
                }
                if (line.startsWith("PageMenuItem")) {
                    this.fPageMenuItem = line.substring(valStart);
                    if (this.fPageMenuItem.equals("TOP")) {
                        this.fPageMenuItem = "";
                    }
                }
                if (!line.startsWith("AlternativeMessage")) continue;
                this.fAlternativeMessage = line.substring(valStart);
            }
        }
        catch (FileNotFoundException e) {
            this.logError(e);
            e.printStackTrace();
        }
        catch (IOException e) {
            this.logError(e);
            e.printStackTrace();
        }
    }

    public void generateCodeStubs(IFile specFile, IProgressMonitor mon) throws CoreException {
        IProject fProject = specFile.getProject();
        Map<String, String> subs = this.getStandardSubstitutions(fProject);
        subs.put("$PREFS_CLASS_NAME$", this.fPageClassNameBase);
        List<PreferencesPageInfo> pageInfos = this.getPreferencesPageInfos(specFile);
        if (specFile.findMarkers(PROBLEM_MARKER_ID, true, 0).length > 0) {
            return;
        }
        this.fPageClassNameBase = pageInfos.get(0).getPageName();
        String constantsClassName = this.fPageClassNameBase + "Constants";
        String initializerClassName = this.fPageClassNameBase + "Initializer";
        ISourceProject sourceProject = null;
        try {
            sourceProject = ModelFactory.open((IProject)fProject);
        }
        catch (ModelFactory.ModelException me) {
            this.fConsoleStream.println("PrefspecsCompiler.generateCodeStubs(..): Model exception:\n" + me.getMessage() + "\nReturning without parsing");
            return;
        }
        subs.put("$PREFS_PACKAGE_NAME$", this.fPagePackageName);
        PreferencesFactory prefFactory = new PreferencesFactory(this.fConsoleStream);
        String projectSourceLoc = ExtensionPointWizard.getProjectSourceLocation((IProject)fProject);
        String pluginPkgName = this.getPluginPackageName(fProject, null);
        String pluginClassName = this.getPluginClassName(fProject, null);
        prefFactory.generatePreferencesConstants(pageInfos, sourceProject, projectSourceLoc, this.fPagePackageName, constantsClassName, mon);
        prefFactory.generatePreferencesInitializers(pageInfos, pluginPkgName, pluginClassName, constantsClassName, sourceProject, projectSourceLoc, this.fPagePackageName, this.fPageClassNameBase + "Initializer", mon);
        subs.put("$PREFS_INIT_CLASS_NAME$", this.fPageClassNameBase + "Initializer");
        for (PreferencesPageInfo pageInfo : pageInfos) {
            String javaPageName = pageInfo.getPageName().replaceAll("\\.", "");
            subs.put("$PREFS_CLASS_NAME$", javaPageName);
            prefFactory.generatePreferencesPage(pageInfo, pluginPkgName, pluginClassName, constantsClassName, initializerClassName, sourceProject, projectSourceLoc, this.fPagePackageName, javaPageName + "PreferencePage", mon);
            if (pageInfo.getTabInfo("default").getIsUsed()) {
                prefFactory.generateDefaultTab(pageInfo, pluginPkgName, pluginClassName, constantsClassName, initializerClassName, sourceProject, projectSourceLoc, this.fPagePackageName, javaPageName + "DefaultTab", mon);
            }
            if (pageInfo.getTabInfo("configuration").getIsUsed()) {
                prefFactory.generateConfigurationTab(pageInfo, pluginPkgName, pluginClassName, constantsClassName, sourceProject, projectSourceLoc, this.fPagePackageName, javaPageName + "ConfigurationTab", mon);
            }
            if (pageInfo.getTabInfo("instance").getIsUsed()) {
                prefFactory.generateInstanceTab(pageInfo, pluginPkgName, pluginClassName, constantsClassName, sourceProject, projectSourceLoc, this.fPagePackageName, javaPageName + "InstanceTab", mon);
            }
            if (!pageInfo.getTabInfo("project").getIsUsed()) continue;
            prefFactory.generateProjectTab(pageInfo, pluginPkgName, pluginClassName, constantsClassName, sourceProject, projectSourceLoc, this.fPagePackageName, javaPageName + "ProjectTab", mon);
        }
    }

    public String getPluginPackageName(IProject project, String defaultName) {
        String result = defaultName;
        if (result == null) {
            result = this.fLanguageName;
        }
        if (project != null) {
            String activator = null;
            IPluginModel pm = ExtensionPointEnabler.getPluginModelForProject((IProject)project);
            if (pm != null) {
                WorkspaceBundleModel wbm = new WorkspaceBundleModel(project.getFile("META-INF/MANIFEST.MF"));
                activator = wbm.getBundle().getHeader("Bundle-Activator");
            }
            if (activator != null && !activator.equals("") && activator.lastIndexOf(".") >= 0) {
                result = activator.substring(0, activator.lastIndexOf("."));
            }
        }
        return result;
    }

    public String getPluginClassName(IProject project, String defaultName) {
        String result = defaultName;
        if (result == null) {
            result = this.fPageClassNameBase + "Plugin";
        }
        if (project != null) {
            String activator = null;
            IPluginModel pm = ExtensionPointEnabler.getPluginModelForProject((IProject)project);
            if (pm != null) {
                WorkspaceBundleModel wbm = new WorkspaceBundleModel(project.getFile("META-INF/MANIFEST.MF"));
                activator = wbm.getBundle().getHeader("Bundle-Activator");
            }
            if (activator != null) {
                result = activator.substring(activator.lastIndexOf(".") + 1);
            }
        }
        return result;
    }

    public String getPluginID(IProject project, String defaultID) {
        String result = defaultID;
        if (result == null) {
            this.getPluginPackageName(project, null);
        }
        if (project != null) {
            result = ExtensionPointEnabler.getPluginIDForProject((IProject)project);
        }
        return result;
    }

    public Map<String, String> getStandardSubstitutions(IProject project) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("$LANG_NAME$", this.fLanguageName);
        result.put("$CLASS_NAME_PREFIX$", this.fPageClassNameBase);
        result.put("$PACKAGE_NAME$", this.fPagePackageName);
        result.put("$PROJECT_NAME$", this.fProjectName);
        result.put("$PLUGIN_PACKAGE$", this.getPluginPackageName(null, null));
        result.put("$PLUGIN_CLASS$", this.getPluginClassName(null, null));
        result.put("$PLUGIN_ID$", this.getPluginID(null, null));
        result.remove("$PLUGIN_PACKAGE$");
        result.put("$PLUGIN_PACKAGE$", this.getPluginPackageName(project, null));
        result.remove("$PLUGIN_CLASS$");
        result.put("$PLUGIN_CLASS$", this.getPluginClassName(project, null));
        result.remove("$PLUGIN_ID$");
        result.put("$PLUGIN_ID$", this.getPluginID(project, null));
        return result;
    }

    public IPath getProjectSourceLocationPath() {
        return new Path(ExtensionPointWizard.getProjectSourceLocation((IProject)this.fProject));
    }

    protected List<String> getPluginDependencies() {
        return Arrays.asList("org.eclipse.core.runtime", "org.eclipse.core.resources", "org.eclipse.imp.runtime");
    }

    private void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.imp.prefspecs", 0, e.getMessage(), (Throwable)e);
        PrefspecsPlugin.getInstance().getLog().log((IStatus)status);
    }

    private final class TranslatorVisitor
    extends AbstractVisitor {
        PrefspecsParser.SymbolTable innerScope;
        String customTabName = null;
        PreferencesTabInfo customTabInfo = null;
        String customFieldName = null;
        ConcreteFieldInfo customFieldInfo = null;

        private TranslatorVisitor() {
        }

        public void unimplementedVisitor(String s) {
        }

        public boolean visit(optPackageSpec ps) {
            PrefspecsCompiler.this.fPagePackageName = ps.getpackageName().toString();
            return false;
        }

        public boolean visit(optDetailsSpec n) {
            PrefspecsCompiler.this.fNoDetails = n.getonOff().toString().equalsIgnoreCase("off");
            return false;
        }

        public boolean visit(pageSpec p) {
            String pageName2 = p.getpageName().toString();
            PrefspecsCompiler.this.fPageInfo = new PreferencesPageInfo(pageName2);
            PrefspecsCompiler.this.fPageInfo.setNoDetails(PrefspecsCompiler.this.fNoDetails);
            PrefspecsCompiler.this.fPages.add(PrefspecsCompiler.this.fPageInfo);
            if (p.getpageBody().gettabsSpec() == null) {
                this.createStandardTab("default", false);
                this.createStandardTab("configuration", true);
                this.createStandardTab("instance", true);
                this.createStandardTab("project", true);
            }
            return true;
        }

        private void createStandardTab(String level, boolean editableRemovable) {
            PreferencesTabInfo tab = new PreferencesTabInfo(PrefspecsCompiler.this.fPageInfo, level);
            tab.setIsEditable(editableRemovable);
            tab.setIsRemovable(editableRemovable);
            tab.setIsUsed(true);
        }

        public void endVisit(pageSpec p) {
            PrefspecsCompiler.this.fPageInfo.dump(PrefspecsCompiler.this.fConsoleStream);
        }

        public boolean visit(defaultTabSpec tabSpec) {
            isRemovableSpec removableSpec;
            PreferencesTabInfo tab = new PreferencesTabInfo(PrefspecsCompiler.this.fPageInfo, "default");
            generalSpecs propSpecs = tabSpec.getgeneralSpecs();
            isEditableSpec editableSpec = propSpecs.getisEditableSpec();
            if (editableSpec != null) {
                tab.setIsEditable(editableSpec.getbooleanValue().toString().equals("true"));
            }
            if ((removableSpec = propSpecs.getisRemovableSpec()) != null) {
                try {
                    tab.setIsRemovable(removableSpec.getbooleanValue().toString().equals("true"));
                }
                catch (IllegalArgumentException e) {
                    PrefspecsCompiler.this.fConsoleStream.println("PrefspecsCompiler.TranslatorVisitor.visit(defaultTabSpec:  \n\tattempt to set isRemovable to illegal value 'true'; substituting 'false'.");
                    tab.setIsRemovable(false);
                }
            }
            tab.setIsUsed(tabSpec.getinout().toString().equals("in"));
            return false;
        }

        public boolean visit(configurationTabSpec tabSpec) {
            isRemovableSpec removableSpec;
            PreferencesTabInfo tab = new PreferencesTabInfo(PrefspecsCompiler.this.fPageInfo, "configuration");
            generalSpecs propSpecs = tabSpec.getgeneralSpecs();
            isEditableSpec editableSpec = propSpecs.getisEditableSpec();
            if (editableSpec != null) {
                tab.setIsEditable(editableSpec.getbooleanValue().toString().equals("true"));
            }
            if ((removableSpec = propSpecs.getisRemovableSpec()) != null) {
                tab.setIsRemovable(removableSpec.getbooleanValue().toString().equals("true"));
            }
            tab.setIsUsed(tabSpec.getinout().toString().equals("in"));
            return false;
        }

        public boolean visit(instanceTabSpec tabSpec) {
            isRemovableSpec removableSpec;
            PreferencesTabInfo tab = new PreferencesTabInfo(PrefspecsCompiler.this.fPageInfo, "instance");
            generalSpecs propSpecs = tabSpec.getgeneralSpecs();
            isEditableSpec editableSpec = propSpecs.getisEditableSpec();
            if (editableSpec != null) {
                tab.setIsEditable(editableSpec.getbooleanValue().toString().equals("true"));
            }
            if ((removableSpec = propSpecs.getisRemovableSpec()) != null) {
                tab.setIsRemovable(removableSpec.getbooleanValue().toString().equals("true"));
            }
            tab.setIsUsed(tabSpec.getinout().toString().equals("in"));
            return false;
        }

        public boolean visit(projectTabSpec tabSpec) {
            isRemovableSpec removableSpec;
            PreferencesTabInfo tab = new PreferencesTabInfo(PrefspecsCompiler.this.fPageInfo, "project");
            generalSpecs propSpecs = tabSpec.getgeneralSpecs();
            isEditableSpec editableSpec = propSpecs.getisEditableSpec();
            if (editableSpec != null) {
                tab.setIsEditable(editableSpec.getbooleanValue().toString().equals("true"));
            }
            if ((removableSpec = propSpecs.getisRemovableSpec()) != null) {
                tab.setIsRemovable(removableSpec.getbooleanValue().toString().equals("true"));
            }
            tab.setIsUsed(tabSpec.getinout().toString().equals("in"));
            return false;
        }

        private String unquoteString(ASTNodeToken stringLit) {
            String text = stringLit.toString();
            return this.unquoteString(text);
        }

        private String unquoteString(String text) {
            return text.substring(1, text.length() - 1);
        }

        private String getLabel(optLabelSpec labelSpec) {
            return this.unquoteString(labelSpec.getSTRING_LITERAL());
        }

        private boolean getValueOf(IbooleanValue bv) {
            return bv.toString().equals("true");
        }

        private String getValueOf(stringValue sv) {
            return sv.getSTRING_LITERAL().toString();
        }

        private int getValueOf(IsignedNumber sn) {
            if (sn instanceof signedNumber0) {
                return Integer.parseInt(((signedNumber0)sn).getINTEGER().toString());
            }
            signedNumber1 sn1 = (signedNumber1)sn;
            int absVal = Integer.parseInt(sn1.getINTEGER().toString());
            return sn1.getsign() instanceof sign1 ? -absVal : absVal;
        }

        private int getValueOf(IfontStyle style) {
            if (style instanceof fontStyle0) {
                return 0;
            }
            if (style instanceof fontStyle1) {
                return 1;
            }
            if (style instanceof fontStyle2) {
                return 2;
            }
            return 0;
        }

        private VirtualBooleanFieldInfo findConditionalField(optConditionalSpec condSpec, String depFieldName) {
            String name = condSpec.getidentifier().getIDENTIFIER().toString();
            Iterator<VirtualFieldInfo> virtualFieldInfos = PrefspecsCompiler.this.fPageInfo.getVirtualFieldInfos();
            while (virtualFieldInfos.hasNext()) {
                VirtualFieldInfo next = virtualFieldInfos.next();
                String nextName = next.getName();
                if (!nextName.equals(name)) continue;
                if (next instanceof VirtualBooleanFieldInfo) {
                    return (VirtualBooleanFieldInfo)next;
                }
                this.createErrorMarker("A field can only be made conditional on a boolean field", condSpec);
            }
            this.createErrorMarker("Field " + depFieldName + " is conditional on a non-existent field", condSpec);
            return null;
        }

        private void createErrorMarker(String msg, ASTNode node) {
            try {
                int startLine = node.getLeftIToken().getLine();
                int startOffset = node.getLeftIToken().getStartOffset();
                int endOffset = node.getRightIToken().getEndOffset() + 1;
                IMarker m = PrefspecsCompiler.this.fSpecFile.createMarker(PROBLEM_MARKER_ID);
                String[] attributeNames = new String[]{"lineNumber", "charStart", "charEnd", "message", "priority", "severity"};
                Object[] values = new Object[]{startLine, startOffset, endOffset, msg, 2, 2};
                m.setAttributes(attributeNames, values);
            }
            catch (CoreException e) {
                PrefspecsPlugin.getInstance().logException("PrefspecsCompiler.createMarker: CoreException trying to create marker", e);
            }
            catch (Exception e) {
                PrefspecsPlugin.getInstance().logException("PrefspecsCompiler.createMarker: Exception trying to create marker", e);
            }
        }

        private void setVirtualProperties(VirtualFieldInfo vField, generalSpecs generalSpecs2, optConditionalSpec condSpec) {
            optToolTipSpec toolTipSpec;
            optLabelSpec labelSpec;
            isRemovableSpec removableSpec;
            isEditableSpec editableSpec = generalSpecs2.getisEditableSpec();
            if (editableSpec != null) {
                vField.setIsEditable(this.getValueOf(editableSpec.getbooleanValue()));
            }
            if ((removableSpec = generalSpecs2.getisRemovableSpec()) != null) {
                vField.setIsRemovable(this.getValueOf(removableSpec.getbooleanValue()));
            }
            if ((labelSpec = generalSpecs2.getoptLabelSpec()) != null) {
                vField.setLabel(this.unquoteString(labelSpec.getSTRING_LITERAL()));
            }
            if ((toolTipSpec = generalSpecs2.getoptToolTipSpec()) != null) {
                vField.setToolTipText(this.unquoteString(toolTipSpec.getSTRING_LITERAL()));
            }
            if (condSpec != null) {
                vField.setIsConditional(true);
                vField.setConditionalWith(condSpec.getconditionType() instanceof conditionType0);
                vField.setConditionField(this.findConditionalField(condSpec, vField.getName()));
            }
        }

        private void setConcreteProperties(VirtualFieldInfo vField, PreferencesTabInfo tab, ConcreteFieldInfo cField) {
            if (vField.hasEditableSpec()) {
                cField.setIsEditable(vField.getIsEditable());
            } else {
                cField.setIsEditable(tab.getIsEditable());
            }
            if (vField.hasRemovableSpec() && !tab.getName().equals("default")) {
                cField.setIsRemovable(vField.getIsRemovable());
            } else {
                cField.setIsRemovable(tab.getIsRemovable());
            }
            if (vField.getIsConditional()) {
                cField.setIsConditional(true);
                cField.setConditionalWith(vField.getConditionalWith());
                cField.setConditionField(vField.getConditionField());
            }
        }

        public boolean visit(booleanFieldSpec boolField) {
            VirtualBooleanFieldInfo vBool = new VirtualBooleanFieldInfo(PrefspecsCompiler.this.fPageInfo, boolField.getidentifier().toString());
            booleanFieldPropertySpecs propSpecs = boolField.getbooleanFieldPropertySpecs();
            if (propSpecs != null) {
                this.setVirtualProperties(vBool, propSpecs.getgeneralSpecs(), boolField.getoptConditionalSpec());
                booleanSpecialSpec specialSpec = propSpecs.getbooleanSpecificSpec().getbooleanCustomSpec();
                if (specialSpec != null) {
                    vBool.setHasSpecialValue(true);
                    vBool.setSpecialValue(this.getValueOf(specialSpec.getbooleanValue()));
                } else {
                    vBool.setHasSpecialValue(false);
                }
                booleanDefValueSpec defValueSpec = propSpecs.getbooleanSpecificSpec().getbooleanDefValueSpec();
                if (defValueSpec != null) {
                    vBool.setDefaultValue(this.getValueOf(defValueSpec.getbooleanValue()));
                }
            }
            Iterator<PreferencesTabInfo> tabs = PrefspecsCompiler.this.fPageInfo.getTabInfos();
            while (tabs.hasNext()) {
                PreferencesTabInfo tab = tabs.next();
                if (!tab.getIsUsed()) continue;
                ConcreteBooleanFieldInfo cBool = new ConcreteBooleanFieldInfo(vBool, tab);
                this.setConcreteProperties(vBool, tab, cBool);
                if (vBool.getHasSpecialValue()) {
                    cBool.setHasSpecialValue(true);
                    cBool.setSpecialValue(vBool.getSpecialValue());
                    continue;
                }
                cBool.setHasSpecialValue(false);
            }
            return false;
        }

        public boolean visit(dirListFieldSpec dirListField) {
            VirtualDirListFieldInfo vDirList = new VirtualDirListFieldInfo(PrefspecsCompiler.this.fPageInfo, dirListField.getidentifier().toString());
            dirlistFieldPropertySpecs propSpecs = dirListField.getdirlistFieldPropertySpecs();
            if (propSpecs != null) {
                IstringEmptySpec emptyValueSpec;
                this.setVirtualProperties(vDirList, propSpecs.getgeneralSpecs(), dirListField.getoptConditionalSpec());
                stringSpecialSpec specialSpec = propSpecs.getstringSpecificSpec().getstringCustomSpec().getstringSpecialSpec();
                if (specialSpec != null) {
                    vDirList.setHasSpecialValue(true);
                    vDirList.setSpecialValue(this.getValueOf(specialSpec.getstringValue()));
                } else {
                    vDirList.setHasSpecialValue(false);
                }
                stringDefValueSpec defValueSpec = propSpecs.getstringSpecificSpec().getstringDefValueSpec();
                if (defValueSpec != null) {
                    vDirList.setDefaultValue(this.getValueOf(defValueSpec.getstringValue()));
                }
                if ((emptyValueSpec = propSpecs.getstringSpecificSpec().getstringCustomSpec().getstringEmptySpec()) instanceof stringEmptySpec0) {
                    vDirList.setEmptyValueAllowed(false);
                    vDirList.setEmptyValue(null);
                } else if (emptyValueSpec instanceof stringEmptySpec1) {
                    stringEmptySpec1 ses1 = (stringEmptySpec1)emptyValueSpec;
                    vDirList.setEmptyValueAllowed(true);
                    vDirList.setEmptyValue(this.getValueOf(ses1.getstringValue()));
                }
            }
            Iterator<PreferencesTabInfo> tabs = PrefspecsCompiler.this.fPageInfo.getTabInfos();
            while (tabs.hasNext()) {
                PreferencesTabInfo tab = tabs.next();
                if (!tab.getIsUsed()) continue;
                ConcreteDirListFieldInfo cDirList = new ConcreteDirListFieldInfo(vDirList, tab);
                this.setConcreteProperties(vDirList, tab, cDirList);
                if (vDirList.getHasSpecialValue()) {
                    cDirList.setHasSpecialValue(true);
                    cDirList.setSpecialValue(vDirList.getSpecialValue());
                } else {
                    cDirList.setHasSpecialValue(false);
                }
                if (!vDirList.hasEmptyValueSpec()) continue;
                if (!vDirList.getEmptyValueAllowed()) {
                    cDirList.setEmptyValueAllowed(false);
                    cDirList.setEmptyValue(null);
                    continue;
                }
                cDirList.setEmptyValueAllowed(true);
                cDirList.setEmptyValue(vDirList.getEmptyValue());
            }
            return false;
        }

        public boolean visit(fileFieldSpec fileField) {
            VirtualFileFieldInfo vFile = new VirtualFileFieldInfo(PrefspecsCompiler.this.fPageInfo, fileField.getidentifier().toString());
            fileFieldPropertySpecs propSpecs = fileField.getfileFieldPropertySpecs();
            if (propSpecs != null) {
                IstringEmptySpec emptyValueSpec;
                this.setVirtualProperties(vFile, propSpecs.getgeneralSpecs(), fileField.getoptConditionalSpec());
                stringSpecialSpec specialSpec = propSpecs.getstringSpecificSpec().getstringCustomSpec().getstringSpecialSpec();
                if (specialSpec != null) {
                    vFile.setHasSpecialValue(true);
                    vFile.setSpecialValue(this.getValueOf(specialSpec.getstringValue()));
                } else {
                    vFile.setHasSpecialValue(false);
                }
                stringDefValueSpec defValueSpec = propSpecs.getstringSpecificSpec().getstringDefValueSpec();
                if (defValueSpec != null) {
                    vFile.setDefaultValue(this.getValueOf(defValueSpec.getstringValue()));
                }
                if ((emptyValueSpec = propSpecs.getstringSpecificSpec().getstringCustomSpec().getstringEmptySpec()) instanceof stringEmptySpec0) {
                    vFile.setEmptyValueAllowed(false);
                    vFile.setEmptyValue(null);
                } else if (emptyValueSpec instanceof stringEmptySpec1) {
                    stringEmptySpec1 ses1 = (stringEmptySpec1)emptyValueSpec;
                    vFile.setEmptyValueAllowed(true);
                    vFile.setEmptyValue(this.getValueOf(ses1.getstringValue()));
                }
            }
            Iterator<PreferencesTabInfo> tabs = PrefspecsCompiler.this.fPageInfo.getTabInfos();
            while (tabs.hasNext()) {
                PreferencesTabInfo tab = tabs.next();
                if (!tab.getIsUsed()) continue;
                ConcreteFileFieldInfo cFile = new ConcreteFileFieldInfo(vFile, tab);
                this.setConcreteProperties(vFile, tab, cFile);
                if (vFile.getHasSpecialValue()) {
                    cFile.setHasSpecialValue(true);
                    cFile.setSpecialValue(vFile.getSpecialValue());
                } else {
                    cFile.setHasSpecialValue(false);
                }
                if (!vFile.hasEmptyValueSpec()) continue;
                if (!vFile.getEmptyValueAllowed()) {
                    cFile.setEmptyValueAllowed(false);
                    cFile.setEmptyValue(null);
                    continue;
                }
                cFile.setEmptyValueAllowed(true);
                cFile.setEmptyValue(vFile.getEmptyValue());
            }
            return false;
        }

        public boolean visit(intFieldSpec intField) {
            VirtualIntFieldInfo vInt = new VirtualIntFieldInfo(PrefspecsCompiler.this.fPageInfo, intField.getidentifier().toString());
            intFieldPropertySpecs propSpecs = intField.getintFieldPropertySpecs();
            if (propSpecs != null) {
                this.setVirtualProperties(vInt, propSpecs.getgeneralSpecs(), intField.getoptConditionalSpec());
                intSpecificSpec specificSpec = propSpecs.getintSpecificSpec();
                intCustomSpec customSpec2 = specificSpec.getintCustomSpec();
                intSpecialSpec specialSpec = customSpec2.getintSpecialSpec();
                intRangeSpec rangeSpec = customSpec2.getintRangeSpec();
                intDefValueSpec defValueSpec = specificSpec.getintDefValueSpec();
                if (specialSpec != null) {
                    vInt.setHasSpecialValue(true);
                    vInt.setSpecialValue(this.getValueOf(specialSpec.getsignedNumber()));
                } else {
                    vInt.setHasSpecialValue(false);
                }
                if (defValueSpec != null) {
                    vInt.setDefaultValue(this.getValueOf(defValueSpec.getsignedNumber()));
                }
                if (rangeSpec != null) {
                    int lowValue = this.getValueOf(rangeSpec.getlow());
                    int hiValue = this.getValueOf(rangeSpec.gethigh());
                    vInt.setRange(lowValue, hiValue);
                }
            }
            Iterator<PreferencesTabInfo> tabs = PrefspecsCompiler.this.fPageInfo.getTabInfos();
            while (tabs.hasNext()) {
                PreferencesTabInfo tab = tabs.next();
                if (!tab.getIsUsed()) continue;
                ConcreteIntFieldInfo cInt = new ConcreteIntFieldInfo(vInt, tab);
                this.setConcreteProperties(vInt, tab, cInt);
                if (vInt.getHasSpecialValue()) {
                    cInt.setHasSpecialValue(true);
                    cInt.setSpecialValue(vInt.getSpecialValue());
                } else {
                    cInt.setHasSpecialValue(false);
                }
                if (!vInt.hasRangeSpec()) continue;
                cInt.setRangeLow(vInt.getRangeLow());
                cInt.setRangeHigh(vInt.getRangeHigh());
            }
            return false;
        }

        public boolean visit(doubleFieldSpec doubleField) {
            VirtualDoubleFieldInfo vDouble = new VirtualDoubleFieldInfo(PrefspecsCompiler.this.fPageInfo, doubleField.getidentifier().toString());
            doubleFieldPropertySpecs propSpecs = doubleField.getdoubleFieldPropertySpecs();
            if (propSpecs != null) {
                this.setVirtualProperties(vDouble, propSpecs.getgeneralSpecs(), doubleField.getoptConditionalSpec());
                doubleSpecificSpec specificSpec = propSpecs.getdoubleSpecificSpec();
                doubleRangeSpec rangeSpec = specificSpec.getdoubleCustomSpec();
                doubleDefValueSpec defValueSpec = specificSpec.getdoubleDefValueSpec();
                if (defValueSpec != null) {
                    vDouble.setDefaultValue(Double.parseDouble(defValueSpec.getDECIMAL().toString()));
                }
                if (rangeSpec != null) {
                    double lowValue = Double.parseDouble(rangeSpec.getlow().toString());
                    double hiValue = Double.parseDouble(rangeSpec.gethigh().toString());
                    vDouble.setRange(lowValue, hiValue);
                }
            }
            Iterator<PreferencesTabInfo> tabs = PrefspecsCompiler.this.fPageInfo.getTabInfos();
            while (tabs.hasNext()) {
                PreferencesTabInfo tab = tabs.next();
                if (!tab.getIsUsed()) continue;
                ConcreteDoubleFieldInfo cDouble = new ConcreteDoubleFieldInfo(vDouble, tab);
                this.setConcreteProperties(vDouble, tab, cDouble);
                if (!vDouble.hasRangeSpec()) continue;
                cDouble.setRangeLow(vDouble.getRangeLow());
                cDouble.setRangeHigh(vDouble.getRangeHigh());
            }
            return false;
        }

        public boolean visit(stringFieldSpec stringField) {
            VirtualStringFieldInfo vString = new VirtualStringFieldInfo(PrefspecsCompiler.this.fPageInfo, stringField.getidentifier().toString());
            stringFieldPropertySpecs propSpecs = stringField.getstringFieldPropertySpecs();
            if (propSpecs != null) {
                IstringEmptySpec emptyValueSpec;
                this.setVirtualProperties(vString, propSpecs.getgeneralSpecs(), stringField.getoptConditionalSpec());
                stringSpecificSpec stringSpecificSpec2 = propSpecs.getstringSpecificSpec();
                stringCustomSpec customSpec2 = stringSpecificSpec2.getstringCustomSpec();
                stringSpecialSpec specialSpec = customSpec2.getstringSpecialSpec();
                if (specialSpec != null) {
                    vString.setHasSpecialValue(true);
                    vString.setSpecialValue(this.getValueOf(specialSpec.getstringValue()));
                } else {
                    vString.setHasSpecialValue(false);
                }
                stringDefValueSpec defValueSpec = stringSpecificSpec2.getstringDefValueSpec();
                if (defValueSpec != null) {
                    vString.setDefaultValue(this.getValueOf(defValueSpec.getstringValue()));
                }
                if ((emptyValueSpec = customSpec2.getstringEmptySpec()) instanceof stringEmptySpec0) {
                    vString.setEmptyValueAllowed(false);
                    vString.setEmptyValue(null);
                } else if (emptyValueSpec instanceof stringEmptySpec1) {
                    stringEmptySpec1 ses1 = (stringEmptySpec1)emptyValueSpec;
                    vString.setEmptyValueAllowed(true);
                    vString.setEmptyValue(this.getValueOf(ses1.getstringValue()));
                }
                stringValidatorSpec validatorSpec = stringSpecificSpec2.getstringValidatorSpec();
                if (validatorSpec != null) {
                    String validatorQualClass = this.unquoteString(validatorSpec.getqualClassName().getSTRING_LITERAL().toString());
                    vString.setValidatorQualClass(validatorQualClass);
                    if (!PrefspecsCompiler.this.findClass(validatorQualClass)) {
                        this.createErrorMarker("Validator class " + validatorQualClass + " does not exist", validatorSpec);
                    }
                }
            }
            Iterator<PreferencesTabInfo> tabs = PrefspecsCompiler.this.fPageInfo.getTabInfos();
            while (tabs.hasNext()) {
                PreferencesTabInfo tab = tabs.next();
                if (!tab.getIsUsed()) continue;
                ConcreteStringFieldInfo cString = new ConcreteStringFieldInfo(vString, tab);
                this.setConcreteProperties(vString, tab, cString);
                if (vString.getHasSpecialValue()) {
                    cString.setHasSpecialValue(true);
                    cString.setSpecialValue(vString.getSpecialValue());
                } else {
                    cString.setHasSpecialValue(false);
                }
                if (!vString.hasEmptyValueSpec()) continue;
                if (!vString.getEmptyValueAllowed()) {
                    cString.setEmptyValueAllowed(false);
                    cString.setEmptyValue(null);
                    continue;
                }
                cString.setEmptyValueAllowed(true);
                cString.setEmptyValue(vString.getEmptyValue());
            }
            return false;
        }

        public boolean visit(colorFieldSpec colorField) {
            VirtualColorFieldInfo vColor = new VirtualColorFieldInfo(PrefspecsCompiler.this.fPageInfo, colorField.getidentifier().toString());
            colorFieldPropertySpecs propSpecs = colorField.getcolorFieldPropertySpecs();
            if (propSpecs != null) {
                this.setVirtualProperties(vColor, propSpecs.getgeneralSpecs(), colorField.getoptConditionalSpec());
                colorDefValueSpec defValueSpec = propSpecs.getcolorSpecificSpec();
                if (defValueSpec != null) {
                    int r = Integer.parseInt(defValueSpec.getred().toString());
                    int g = Integer.parseInt(defValueSpec.getgreen().toString());
                    int b = Integer.parseInt(defValueSpec.getblue().toString());
                    vColor.setDefaultColor(StringConverter.asString((RGB)new RGB(r, g, b)));
                }
            }
            Iterator<PreferencesTabInfo> tabs = PrefspecsCompiler.this.fPageInfo.getTabInfos();
            while (tabs.hasNext()) {
                PreferencesTabInfo tab = tabs.next();
                if (!tab.getIsUsed()) continue;
                ConcreteColorFieldInfo cColor = new ConcreteColorFieldInfo(vColor, tab);
                this.setConcreteProperties(vColor, tab, cColor);
            }
            return false;
        }

        public boolean visit(fontFieldSpec fontField) {
            VirtualFontFieldInfo vFont = new VirtualFontFieldInfo(PrefspecsCompiler.this.fPageInfo, fontField.getidentifier().toString());
            fontFieldPropertySpecs propSpecs = fontField.getfontFieldPropertySpecs();
            if (propSpecs != null) {
                this.setVirtualProperties(vFont, propSpecs.getgeneralSpecs(), fontField.getoptConditionalSpec());
                fontDefValueSpec defValueSpec = propSpecs.getfontSpecificSpec();
                if (defValueSpec != null) {
                    vFont.setDefaultName(this.getValueOf(defValueSpec.getname()));
                    vFont.setDefaultHeight(Integer.parseInt(defValueSpec.getheight().toString()));
                    vFont.setDefaultStyle(this.getValueOf(defValueSpec.getstyle()));
                }
            }
            Iterator<PreferencesTabInfo> tabs = PrefspecsCompiler.this.fPageInfo.getTabInfos();
            while (tabs.hasNext()) {
                PreferencesTabInfo tab = tabs.next();
                if (!tab.getIsUsed()) continue;
                ConcreteFontFieldInfo cFont = new ConcreteFontFieldInfo(vFont, tab);
                this.setConcreteProperties(vFont, tab, cFont);
            }
            return false;
        }

        public boolean visit(typeSpec n) {
            String typeName = n.getidentifier().getIDENTIFIER().toString();
            LabelledValueDescriptor vd = new LabelledValueDescriptor(n.getlabelledStringValueList());
            PrefspecsCompiler.this.fTypeMap.put(typeName, vd);
            return false;
        }

        public boolean visit(comboFieldSpec comboField) {
            VirtualComboFieldInfo vCombo = new VirtualComboFieldInfo(PrefspecsCompiler.this.fPageInfo, comboField.getidentifier().toString());
            comboFieldPropertySpecs propSpecs = comboField.getcomboFieldPropertySpecs();
            if (propSpecs != null) {
                LabelledValueDescriptor lvd;
                comboSpecificSpec comboSpecificSpec2 = propSpecs.getcomboSpecificSpec();
                comboDefValueSpec defValueSpec = comboSpecificSpec2.getcomboDefValueSpec();
                comboCustomSpec customSpec2 = comboSpecificSpec2.getcomboCustomSpec();
                ItypeOrValuesSpec tovSpec = customSpec2.gettypeOrValuesSpec();
                columnsSpec columnsSpec2 = customSpec2.getcolumnsSpec();
                if (tovSpec instanceof typeOrValuesSpec0) {
                    lvd = (LabelledValueDescriptor)PrefspecsCompiler.this.fTypeMap.get(((typeOrValuesSpec0)tovSpec).getidentifier().getIDENTIFIER().toString());
                } else {
                    typeOrValuesSpec1 tovs1 = (typeOrValuesSpec1)tovSpec;
                    lvd = new LabelledValueDescriptor(tovs1.getvaluesSpec().getlabelledStringValueList());
                }
                this.setVirtualProperties(vCombo, propSpecs.getgeneralSpecs(), comboField.getoptConditionalSpec());
                if (defValueSpec != null) {
                    vCombo.setDefaultValue(this.getValueOf(defValueSpec.getstringValue()));
                }
                List<String> valuesList = lvd.getValues();
                List<String> labelsList = lvd.getLabels();
                vCombo.setValuesAndLabels(valuesList, labelsList);
                if (columnsSpec2 != null) {
                    vCombo.setNumColumns(Integer.parseInt(columnsSpec2.getINTEGER().toString()));
                }
            }
            Iterator<PreferencesTabInfo> tabs = PrefspecsCompiler.this.fPageInfo.getTabInfos();
            while (tabs.hasNext()) {
                PreferencesTabInfo tab = tabs.next();
                if (!tab.getIsUsed()) continue;
                ConcreteComboFieldInfo cCombo = new ConcreteComboFieldInfo(vCombo, tab);
                this.setConcreteProperties(vCombo, tab, cCombo);
            }
            return false;
        }

        public boolean visit(radioFieldSpec radioField) {
            VirtualRadioFieldInfo vRadio = new VirtualRadioFieldInfo(PrefspecsCompiler.this.fPageInfo, radioField.getidentifier().toString());
            radioFieldPropertySpecs propSpecs = radioField.getradioFieldPropertySpecs();
            if (propSpecs != null) {
                LabelledValueDescriptor lvd;
                radioSpecificSpec radioSpecificSpec2 = propSpecs.getradioSpecificSpec();
                radioDefValueSpec defValueSpec = radioSpecificSpec2.getradioDefValueSpec();
                radioCustomSpec customSpec2 = radioSpecificSpec2.getradioCustomSpec();
                ItypeOrValuesSpec tovSpec = customSpec2.gettypeOrValuesSpec();
                columnsSpec columnsSpec2 = customSpec2.getcolumnsSpec();
                if (tovSpec instanceof typeOrValuesSpec0) {
                    lvd = (LabelledValueDescriptor)PrefspecsCompiler.this.fTypeMap.get(((typeOrValuesSpec0)tovSpec).getidentifier().getIDENTIFIER().toString());
                } else {
                    typeOrValuesSpec1 tovs1 = (typeOrValuesSpec1)tovSpec;
                    lvd = new LabelledValueDescriptor(tovs1.getvaluesSpec().getlabelledStringValueList());
                }
                this.setVirtualProperties(vRadio, propSpecs.getgeneralSpecs(), radioField.getoptConditionalSpec());
                if (defValueSpec != null) {
                    vRadio.setDefaultValue(defValueSpec.getidentifier().getIDENTIFIER().toString());
                }
                List<String> valuesList = lvd.getValues();
                List<String> labelsList = lvd.getLabels();
                vRadio.setValuesAndLabels(valuesList, labelsList);
                if (columnsSpec2 != null) {
                    vRadio.setNumColumns(Integer.parseInt(columnsSpec2.getINTEGER().toString()));
                }
            }
            Iterator<PreferencesTabInfo> tabs = PrefspecsCompiler.this.fPageInfo.getTabInfos();
            while (tabs.hasNext()) {
                PreferencesTabInfo tab = tabs.next();
                if (!tab.getIsUsed()) continue;
                ConcreteRadioFieldInfo cRadio = new ConcreteRadioFieldInfo(vRadio, tab);
                this.setConcreteProperties(vRadio, tab, cRadio);
            }
            return false;
        }

        public boolean visit(customRule custRule) {
            this.customTabName = custRule.gettab().toString();
            this.customFieldName = custRule.getidentifier().toString();
            this.customTabInfo = PrefspecsCompiler.this.fPageInfo.getTabInfo(this.customTabName);
            Iterator<ConcreteFieldInfo> concreteFields = this.customTabInfo.getConcreteFields();
            while (concreteFields.hasNext()) {
                ConcreteFieldInfo next = concreteFields.next();
                if (!next.getName().equals(this.customFieldName)) continue;
                this.customFieldInfo = next;
                break;
            }
            if (this.customFieldInfo == null) {
                PrefspecsCompiler.this.fConsoleStream.println("PrefspecsCompiler.TranslatorVisitor.visit(customRule):\n    found no field info corresponding to field name = '" + this.customFieldName + "';\n    continuing at your own risk");
            }
            return true;
        }

        public void endVisit(customRule custRule) {
            this.customTabName = null;
            this.customTabInfo = null;
            this.customFieldName = null;
            this.customFieldInfo = null;
        }

        public void endVisit(generalSpecs genSpecs) {
            if (this.customTabName != null) {
                if (genSpecs.getisEditableSpec() != null) {
                    this.customFieldInfo.setIsEditable(genSpecs.getisEditableSpec().getbooleanValue().toString().equals("true"));
                }
                try {
                    if (genSpecs.getisRemovableSpec() != null) {
                        this.customFieldInfo.setIsRemovable(genSpecs.getisRemovableSpec().getbooleanValue().toString().equals("true"));
                    }
                }
                catch (IllegalArgumentException e) {
                    PrefspecsCompiler.this.fConsoleStream.println("PrefspecsCompiler.TranslatorVisitor.visit(generalSpecs:  \n\tattempt to set isRemovable to illegal value 'true'; substituting 'false'.");
                    this.customFieldInfo.setIsRemovable(false);
                }
            }
        }

        public void endVisit(booleanSpecialSpec specialSpec) {
            if (this.customTabName != null) {
                ((ConcreteBooleanFieldInfo)this.customFieldInfo).setSpecialValue(specialSpec.getbooleanValue().toString().equals("true"));
            }
        }

        public void endVisit(stringSpecialSpec specialSpec) {
            if (this.customTabName != null) {
                ((ConcreteStringFieldInfo)this.customFieldInfo).setSpecialValue(specialSpec.getstringValue().getSTRING_LITERAL().toString());
            }
        }

        public boolean visit(conditionalSpec0 rule) {
            String conditionalFieldName = rule.getidentifier().toString();
            String conditionFieldName = rule.getidentifier3().toString();
            VirtualFieldInfo conditionalFieldInfo = null;
            VirtualFieldInfo conditionFieldInfo = null;
            Iterator<VirtualFieldInfo> virtualFieldInfos = PrefspecsCompiler.this.fPageInfo.getVirtualFieldInfos();
            while (virtualFieldInfos.hasNext()) {
                VirtualFieldInfo next = virtualFieldInfos.next();
                String nextName = next.getName();
                if (nextName.equals(conditionalFieldName)) {
                    conditionalFieldInfo = next;
                } else if (nextName.equals(conditionFieldName)) {
                    conditionFieldInfo = next;
                }
                if (conditionalFieldInfo == null || conditionFieldInfo == null) continue;
                break;
            }
            conditionalFieldInfo.setIsConditional(true);
            conditionalFieldInfo.setConditionalWith(true);
            conditionalFieldInfo.setConditionField((VirtualBooleanFieldInfo)conditionFieldInfo);
            return false;
        }

        public boolean visit(conditionalSpec1 rule) {
            String conditionalFieldName = rule.getidentifier().toString();
            String conditionFieldName = rule.getidentifier3().toString();
            VirtualFieldInfo conditionalFieldInfo = null;
            VirtualFieldInfo conditionFieldInfo = null;
            Iterator<VirtualFieldInfo> virtualFieldInfos = PrefspecsCompiler.this.fPageInfo.getVirtualFieldInfos();
            while (virtualFieldInfos.hasNext()) {
                VirtualFieldInfo next = virtualFieldInfos.next();
                String nextName = next.getName();
                if (nextName.equals(conditionalFieldName)) {
                    conditionalFieldInfo = next;
                } else if (nextName.equals(conditionFieldName)) {
                    conditionFieldInfo = next;
                }
                if (conditionalFieldInfo == null || conditionFieldInfo == null) continue;
                break;
            }
            conditionalFieldInfo.setIsConditional(true);
            conditionalFieldInfo.setConditionalWith(false);
            conditionalFieldInfo.setConditionField((VirtualBooleanFieldInfo)conditionFieldInfo);
            return false;
        }

        public void endVisit(conditionalSpecs0 spec) {
            this.propagateConditionsToConcreteSpecs();
        }

        public void endVisit(conditionalSpecs1 spec) {
            this.propagateConditionsToConcreteSpecs();
        }

        protected void propagateConditionsToConcreteSpecs() {
            Iterator<VirtualFieldInfo> vFieldInfos = PrefspecsCompiler.this.fPageInfo.getVirtualFieldInfos();
            while (vFieldInfos.hasNext()) {
                VirtualFieldInfo vInfo = vFieldInfos.next();
                if (!vInfo.getIsConditional()) continue;
                Iterator<ConcreteFieldInfo> cFieldInfos = vInfo.getConcreteFieldInfos();
                while (cFieldInfos.hasNext()) {
                    ConcreteFieldInfo cInfo = cFieldInfos.next();
                    cInfo.setIsConditional(true);
                    cInfo.setConditionalWith(vInfo.getConditionalWith());
                    cInfo.setConditionField(vInfo.getConditionField());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelledValueDescriptor {
        private final List<String> fValues = new ArrayList<String>();
        private final List<String> fLabels = new ArrayList<String>();

        public LabelledValueDescriptor(labelledStringValueList svList) {
            for (int i = 0; i < svList.size(); ++i) {
                labelledStringValue lsv = svList.getlabelledStringValueAt(i);
                stringValue sv = lsv.getoptLabel();
                this.fValues.add(lsv.getidentifier().getIDENTIFIER().toString());
                this.fLabels.add(sv != null ? sv.getSTRING_LITERAL().toString() : null);
            }
        }

        public int size() {
            return this.fValues.size();
        }

        public String getValue(int i) {
            return this.fValues.get(i);
        }

        public String getLabel(int i) {
            return this.fLabels.get(i);
        }

        public List<String> getValues() {
            return this.fValues;
        }

        public List<String> getLabels() {
            return this.fLabels;
        }
    }
}

