/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.parser;

import java.io.IOException;
import lpg.runtime.IPrsStream;
import lpg.runtime.Monitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.parser.ILexer;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.IParser;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.parser.MessageHandlerAdapter;
import org.eclipse.imp.parser.SimpleLPGParseController;
import org.eclipse.imp.prefspecs.parser.Ast.ASTNode;
import org.eclipse.imp.prefspecs.parser.PrefspecsASTNodeLocator;
import org.eclipse.imp.prefspecs.parser.PrefspecsLexer;
import org.eclipse.imp.prefspecs.parser.PrefspecsParser;
import org.eclipse.imp.prefspecs.parser.PrefspecsSyntaxProperties;
import org.eclipse.imp.services.ILanguageSyntaxProperties;

public class PrefspecsParseController
extends SimpleLPGParseController
implements IParseController {
    private PrefspecsParser parser;
    private PrefspecsLexer lexer;

    public PrefspecsParseController() {
        super("prefspecs");
    }

    public void initialize(IPath filePath, ISourceProject project, IMessageHandler handler) {
        super.initialize(filePath, project, handler);
        String fullFilePath = project.getRawProject().getLocation().toString() + "/" + filePath;
        this.createLexerAndParser(fullFilePath);
    }

    public IParser getParser() {
        return this.parser;
    }

    public ILexer getLexer() {
        return this.lexer;
    }

    public ISourcePositionLocator getNodeLocator() {
        return new PrefspecsASTNodeLocator();
    }

    private void createLexerAndParser(String filePath) {
        try {
            this.lexer = new PrefspecsLexer(filePath);
            this.parser = new PrefspecsParser(this.lexer.getLexStream());
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public ILanguageSyntaxProperties getSyntaxProperties() {
        return new PrefspecsSyntaxProperties();
    }

    public Object parse(String contents, boolean scanOnly, IProgressMonitor monitor) {
        SimpleLPGParseController.PMMonitor my_monitor = new SimpleLPGParseController.PMMonitor((SimpleLPGParseController)this, monitor);
        char[] contentsArray = contents.toCharArray();
        if (this.lexer == null) {
            this.lexer = new PrefspecsLexer();
        }
        this.lexer.reset(contentsArray, this.fFilePath.toPortableString());
        if (this.parser == null) {
            this.parser = new PrefspecsParser(this.lexer.getLexStream());
        }
        this.parser.reset(this.lexer.getLexStream());
        this.parser.getParseStream().setMessageHandler((lpg.runtime.IMessageHandler)new MessageHandlerAdapter(this.handler));
        IFile file = this.fProject.getRawProject().getFile(this.fFilePath);
        try {
            file.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            System.err.println("prefspecsParseController.parse:  caught CoreException while deleting problem markers; continuing to parse regardless");
        }
        this.lexer.lexer((Monitor)my_monitor, (IPrsStream)this.parser.getParseStream());
        if (my_monitor.isCancelled()) {
            return this.fCurrentAst;
        }
        this.fCurrentAst = this.parser.parser((Monitor)my_monitor, 0);
        this.parser.resolve((ASTNode)this.fCurrentAst);
        this.cacheKeywordsOnce();
        return this.fCurrentAst;
    }
}

