/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.reachingdefs;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.imp.analysis.reachingdefs.ConstraintTerm;
import org.eclipse.imp.analysis.reachingdefs.IConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintGraph {
    private boolean DEBUG_DECORATION = false;
    private boolean DEBUG_DUMP_RAW = false;
    private boolean DEBUG_DUMP_USEDIN = false;
    private final List<IConstraint> fConstraints;
    private final Set<ConstraintTerm> fAllVarbles = new LinkedHashSet<ConstraintTerm>();
    private Map<ConstraintTerm, List<IConstraint>> fUsedIn = new LinkedHashMap<ConstraintTerm, List<IConstraint>>();
    private VariableDecorator fVariableDecorator = new VariableDecorator();

    public ConstraintGraph(List<IConstraint> constraints) {
        this.fConstraints = constraints;
        this.initialize();
    }

    void clearAll() {
        this.fAllVarbles.clear();
        this.fUsedIn = new LinkedHashMap<ConstraintTerm, List<IConstraint>>();
    }

    void initialize() {
        this.decorateVarbles();
        if (this.DEBUG_DUMP_RAW) {
            this.dumpVariableList();
            this.dumpConstraints();
        }
        if (this.DEBUG_DUMP_USEDIN) {
            this.dumpUsedInLists(System.out);
        }
    }

    public List<IConstraint> getUsedIn(ConstraintTerm v) {
        return this.fUsedIn.get(v);
    }

    public List<IConstraint> getConstraints() {
        return this.fConstraints;
    }

    public Set<ConstraintTerm> getVariables() {
        return this.fAllVarbles;
    }

    private void addToUsedInSet(ConstraintTerm v, IConstraint constraint) {
        List<IConstraint> usedIn = this.fUsedIn.get(v);
        if (usedIn == null) {
            usedIn = new ArrayList<IConstraint>();
            this.fUsedIn.put(v, usedIn);
        }
        if (this.DEBUG_DECORATION) {
            System.out.println("  Adding constraint " + constraint.toString() + " to used-in set of " + v.toString());
        }
        usedIn.add(constraint);
    }

    private void decorateConstraintVarbles(IConstraint c) {
        ConstraintTerm lhs = c.getLeft();
        ConstraintTerm rhs = c.getRight();
        this.fVariableDecorator.setConstraint(c);
        lhs.processTerms(this.fVariableDecorator);
        rhs.processTerms(this.fVariableDecorator);
    }

    private void decorateVarbles() {
        if (this.DEBUG_DECORATION) {
            System.out.println();
            System.out.println("*** Collecting & annotating constraint variables ***");
        }
        for (IConstraint constraint : this.fConstraints) {
            if (this.DEBUG_DECORATION) {
                System.out.println("Pre-processing constraint " + constraint.toString());
            }
            this.decorateConstraintVarbles(constraint);
        }
    }

    static List<ConstraintTerm> sortedConstraintVariables(Collection<ConstraintTerm> varbles) {
        ConstraintTerm[] va = varbles.toArray(new ConstraintTerm[varbles.size()]);
        Arrays.sort(va, new Comparator<ConstraintTerm>(){

            @Override
            public int compare(ConstraintTerm o1, ConstraintTerm o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return Arrays.asList(va);
    }

    void dumpVariableList() {
        System.out.println();
        System.out.println("*** Constraint Variables: ***");
        List<ConstraintTerm> scv = ConstraintGraph.sortedConstraintVariables(this.fAllVarbles);
        for (ConstraintTerm t : scv) {
            System.out.println(t.toString());
        }
    }

    void dumpConstraints() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n");
        buf.append("*** Constraints: ***\n");
        ArrayList<String> cs = new ArrayList<String>();
        Iterator<IConstraint> it = this.fConstraints.iterator();
        while (it.hasNext()) {
            cs.add(it.next().toString());
        }
        Collections.sort(cs);
        it = cs.iterator();
        while (it.hasNext()) {
            buf.append(it.next()).append("\n");
        }
        return buf.toString();
    }

    private void dumpUsedInLists(PrintStream ps) {
        ps.println();
        ps.println("*** Used-In Lists: ***");
        List<ConstraintTerm> scv = ConstraintGraph.sortedConstraintVariables(this.fAllVarbles);
        for (ConstraintTerm v : scv) {
            boolean gotOne = false;
            List<IConstraint> usedIn = this.fUsedIn.get(v);
            if (usedIn == null) continue;
            for (IConstraint eq : usedIn) {
                if (!gotOne) {
                    ps.println(v.toString() + ":");
                    gotOne = true;
                }
                ps.println("              " + eq.toString());
            }
        }
    }

    private class VariableDecorator
    implements ConstraintTerm.ITermProcessor {
        private IConstraint fConstraint;

        private VariableDecorator() {
        }

        void setConstraint(IConstraint c) {
            this.fConstraint = c;
        }

        public void processTerm(ConstraintTerm term) {
            ConstraintGraph.this.addToUsedInSet(term, this.fConstraint);
            if (!ConstraintGraph.this.fAllVarbles.contains(term)) {
                ConstraintGraph.this.fAllVarbles.add(term);
            }
        }
    }
}

