/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.reachingdefs;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.imp.analysis.reachingdefs.DefinitionLiteral;

class DefinitionSet {
    private Set<DefinitionLiteral> fElements = new LinkedHashSet<DefinitionLiteral>();

    public DefinitionSet() {
    }

    public DefinitionSet(DefinitionLiteral d) {
        this.fElements.add(d);
    }

    public DefinitionSet copy() {
        DefinitionSet s = new DefinitionSet();
        s.fElements.addAll(this.fElements);
        return s;
    }

    public Iterator iterator() {
        return this.fElements.iterator();
    }

    public DefinitionSet unionWith(DefinitionLiteral d) {
        DefinitionSet result = this.copy();
        result.fElements.add(d);
        return result;
    }

    public DefinitionSet unionWith(DefinitionSet s) {
        DefinitionSet result = this.copy();
        result.fElements.addAll(s.fElements);
        return result;
    }

    public DefinitionSet without(DefinitionLiteral d) {
        if (d.isWildcard()) {
            DefinitionSet result = new DefinitionSet();
            for (DefinitionLiteral e : this.fElements) {
                if (d.matches(e)) continue;
                result.fElements.add(e);
            }
            return result;
        }
        DefinitionSet result = this.copy();
        result.fElements.remove(d);
        return result;
    }

    private boolean hasWildcard() {
        for (DefinitionLiteral element : this.fElements) {
            if (!element.isWildcard()) continue;
            return true;
        }
        return false;
    }

    public DefinitionSet without(DefinitionSet s) {
        if (s.hasWildcard()) {
            if (s.fElements.size() != 1) {
                throw new UnsupportedOperationException("DefinitionSet.without() can't handle non-singleton operand set.");
            }
            DefinitionLiteral wildcard = s.fElements.iterator().next();
            DefinitionSet result = new DefinitionSet();
            for (DefinitionLiteral element : this.fElements) {
                if (wildcard.matches(element)) continue;
                result.fElements.add(element);
            }
            return result;
        }
        DefinitionSet result = this.copy();
        result.fElements.removeAll(s.fElements);
        return result;
    }

    public boolean containsAll(DefinitionSet s) {
        return this.fElements.containsAll(s.fElements);
    }

    public boolean contains(DefinitionLiteral defLit) {
        return this.fElements.contains(defLit);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefinitionSet)) {
            return false;
        }
        DefinitionSet other = (DefinitionSet)o;
        return ((Object)this.fElements).equals(other.fElements);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{ ");
        Iterator<DefinitionLiteral> iter = this.fElements.iterator();
        while (iter.hasNext()) {
            DefinitionLiteral d = iter.next();
            b.append(d);
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        b.append(" }");
        return b.toString();
    }
}

