/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.reachingdefs;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.imp.analysis.reachingdefs.ConstraintGraph;
import org.eclipse.imp.analysis.reachingdefs.ConstraintOperator;
import org.eclipse.imp.analysis.reachingdefs.ConstraintTerm;
import org.eclipse.imp.analysis.reachingdefs.DefinitionLiteral;
import org.eclipse.imp.analysis.reachingdefs.DefinitionSet;
import org.eclipse.imp.analysis.reachingdefs.IConstraint;
import org.eclipse.imp.analysis.reachingdefs.IEstimateEnvironment;
import org.eclipse.imp.analysis.reachingdefs.SubsetOperator;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;

public class ReachingDefsSolver {
    private IConstraint[] fConstraints;
    private ConstraintGraph fGraph;
    private final boolean fgDebug = false;
    private EstimateEnvironment fEstimates = new EstimateEnvironment();
    private Stack<ConstraintTerm> fWorkList = new Stack();

    public ReachingDefsSolver(IConstraint[] constraints) {
        this.fConstraints = constraints;
    }

    private boolean isLValue(ASTNode selectedNode) {
        ASTNode parent = selectedNode.getParent();
        return parent.getNodeType() == 7 && ((Assignment)parent).getLeftHandSide() == selectedNode;
    }

    public void solve() {
        this.fGraph = new ConstraintGraph(Arrays.asList(this.fConstraints));
        this.initializeEstimates(this.fGraph);
        while (!this.fWorkList.empty()) {
            ConstraintTerm t = this.fWorkList.pop();
            List<IConstraint> usedIn = this.fGraph.getUsedIn(t);
            for (IConstraint c : usedIn) {
                this.satisfyConstraint(c);
            }
        }
    }

    private void satisfyConstraint(IConstraint c) {
        ConstraintTerm lhs = c.getLeft();
        ConstraintTerm rhs = c.getRight();
        ConstraintOperator op = c.getOperator();
        if (lhs.isComplexTerm()) {
            lhs.recomputeEstimate(this.fEstimates);
        }
        if (rhs.isComplexTerm()) {
            rhs.recomputeEstimate(this.fEstimates);
        }
        DefinitionSet lhsEst = this.fEstimates.getEstimate(lhs);
        DefinitionSet rhsEst = this.fEstimates.getEstimate(rhs);
        if (!(op instanceof SubsetOperator)) {
            throw new UnsupportedOperationException("Unable to process constraint operator " + op);
        }
        if (!rhsEst.containsAll(lhsEst)) {
            this.fEstimates.setEstimate(rhs, rhsEst.unionWith(lhsEst));
        }
    }

    private void initializeEstimates(ConstraintGraph graph) {
        for (ConstraintTerm v : graph.getVariables()) {
            if (v instanceof DefinitionLiteral) {
                this.fEstimates.setEstimate(v, new DefinitionSet((DefinitionLiteral)v));
                continue;
            }
            this.fEstimates.setEstimate(v, new DefinitionSet());
        }
    }

    public void reportResults(ASTNode selectedNode) {
        for (ConstraintTerm t : ConstraintGraph.sortedConstraintVariables(this.fGraph.getVariables())) {
            System.out.println(t.toString() + " => " + this.fEstimates.getEstimate(t));
        }
        if (this.isLValue(selectedNode)) {
            // empty if block
        }
    }

    public IEstimateEnvironment getReachingDefinitions() {
        return this.fEstimates;
    }

    class EstimateEnvironment
    implements IEstimateEnvironment {
        private Map<ConstraintTerm, DefinitionSet> fEstimates = new LinkedHashMap<ConstraintTerm, DefinitionSet>();

        EstimateEnvironment() {
        }

        public void setEstimate(ConstraintTerm t, DefinitionSet newEst) {
            DefinitionSet curEst = this.fEstimates.get(t);
            if (curEst == null || !curEst.equals(newEst)) {
                this.fEstimates.put(t, newEst);
                if (!ReachingDefsSolver.this.fWorkList.contains(t)) {
                    ReachingDefsSolver.this.fWorkList.push(t);
                }
            }
        }

        public DefinitionSet getEstimate(ConstraintTerm t) {
            return this.fEstimates.get(t);
        }
    }
}

