/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints;

import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.analysis.search.PolyglotSourceFinder;
import org.eclipse.imp.analysis.type.constraints.BasicPolyglotConstraintCreator;
import org.eclipse.imp.analysis.type.constraints.ITypeVariableFactory;
import org.eclipse.imp.analysis.type.constraints.TypeConstraintCollector;
import org.eclipse.imp.analysis.type.constraints.TypeConstraintFactory;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public class TypeAnalyzer {
    private final ISourceProject fSrcProject;

    public TypeAnalyzer(ISourceProject srcProject) {
        this.fSrcProject = srcProject;
    }

    public void analyze() {
        ITypeVariableFactory varFactory = null;
        TypeConstraintFactory constrFactory = null;
        TypeConstraintCollector collector = new TypeConstraintCollector(new BasicPolyglotConstraintCreator(constrFactory, varFactory));
        Language lang = LanguageRegistry.findLanguage((String)"java");
        PolyglotSourceFinder srcFinder = new PolyglotSourceFinder(new TextFileDocumentProvider(), this.fSrcProject, collector, collector.getVisitor(), lang);
        try {
            this.fSrcProject.getRawProject().accept((IResourceVisitor)srcFinder);
            collector.dumpConstraints(System.out);
            this.solveConstraints();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void solveConstraints() {
    }
}

