/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lpg.runtime.IAst;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.IPathEntry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.SymbolTable;
import org.eclipse.imp.preferences.PreferencesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTUtils {
    private ASTUtils() {
    }

    public static LPGParser.LPG getRoot(IAst node) {
        while (node != null && !(node instanceof LPGParser.LPG)) {
            node = node.getParent();
        }
        return (LPGParser.LPG)node;
    }

    public static List<LPGParser.Imacro_name_symbol> getMacros(LPGParser.LPG root) {
        SymbolTable<LPGParser.ASTNode> st = root.symbolTable;
        return st.allDefsOfType(LPGParser.Imacro_name_symbol.class);
    }

    public static List<LPGParser.nonTerm> getNonTerminals(LPGParser.LPG root) {
        SymbolTable<LPGParser.ASTNode> st = root.symbolTable;
        return st.allDefsOfType(LPGParser.nonTerm.class);
    }

    public static List<LPGParser.terminal> getTerminals(LPGParser.LPG root) {
        SymbolTable<LPGParser.ASTNode> st = root.symbolTable;
        return st.allDefsOfType(LPGParser.terminal.class);
    }

    public static List<LPGParser.ASTNode> findItemOfType(LPGParser.LPG root, Class ofType) {
        LPGParser.LPG_itemList itemList = root.getLPG_INPUT();
        ArrayList<LPGParser.ASTNode> result = new ArrayList<LPGParser.ASTNode>();
        for (int i = 0; i < itemList.size(); ++i) {
            LPGParser.ILPG_item item = itemList.getLPG_itemAt(i);
            if (!ofType.isInstance(item)) continue;
            result.add((LPGParser.ASTNode)((Object)item));
        }
        return result;
    }

    public static String stripName(String rawId) {
        int idx = rawId.indexOf(36);
        return idx >= 0 ? rawId.substring(0, idx) : rawId;
    }

    protected static List<String> collectIncludedFiles(LPGParser.LPG root, ICompilationUnit refUnit) {
        ArrayList<String> result = new ArrayList<String>();
        LPGParser.option_specList optSeg = root.getoptions_segment();
        for (int i = 0; i < optSeg.size(); ++i) {
            LPGParser.option_spec optSpec = optSeg.getoption_specAt(i);
            LPGParser.optionList optList = optSpec.getoption_list();
            for (int o = 0; o < optList.size(); ++o) {
                LPGParser.Ioption_value optValue;
                LPGParser.option opt = optList.getoptionAt(o);
                LPGParser.ASTNodeToken sym = opt.getSYMBOL();
                String optName = ((Object)sym).toString();
                if (!optName.equals("import_terminals") && !optName.equals("template") && !optName.equals("filter") || !((optValue = opt.getoption_value()) instanceof LPGParser.option_value0)) continue;
                String fileName = ((LPGParser.option_value0)optValue).getSYMBOL().toString();
                result.add(fileName);
                if (!optName.equals("import_terminals")) continue;
                IPath filterPath = refUnit.getPath().removeLastSegments(1).append(fileName);
                ICompilationUnit filterUnit = ModelFactory.open((IPath)filterPath, (ISourceProject)refUnit.getProject());
                LPGParser.LPG filterRoot = (LPGParser.LPG)ASTUtils.findAndParseSourceFile(refUnit.getProject(), filterPath, fileName, (IProgressMonitor)new NullProgressMonitor());
                List<String> level2Incs = ASTUtils.collectIncludedFiles(filterRoot, filterUnit);
                result.addAll(level2Incs);
            }
        }
        return result;
    }

    public static Object findDefOf(LPGParser.IASTNodeToken s, LPGParser.LPG root, ICompilationUnit refUnit, IProgressMonitor monitor) {
        String id = ASTUtils.stripName(s.toString());
        List<String> includedFiles = ASTUtils.collectIncludedFiles(root, refUnit);
        for (String fileName : includedFiles) {
            LPGParser.ASTNode decl;
            LPGParser.LPG includedRoot = (LPGParser.LPG)ASTUtils.findAndParseSourceFile(refUnit.getProject(), refUnit.getPath(), fileName, monitor);
            if (includedRoot == null || (decl = (LPGParser.ASTNode)includedRoot.symbolTable.get((Object)id)) == null) continue;
            return decl;
        }
        return null;
    }

    public static Object findDefOf(LPGParser.IASTNodeToken s, LPGParser.LPG root, IParseController parseController) {
        Object def;
        String id = ASTUtils.stripName(s.toString());
        LPGParser.ASTNode decl = (LPGParser.ASTNode)root.symbolTable.get((Object)id);
        if ((decl == null || ((LPGParser.ASTNodeToken)s).parent == decl) && (def = ASTUtils.findDefOf(s, root, ModelFactory.open((IPath)parseController.getPath(), (ISourceProject)parseController.getProject()), (IProgressMonitor)new NullProgressMonitor())) != null) {
            return def;
        }
        if (decl == null) {
            LPGParser.ASTNode node = (LPGParser.ASTNode)((Object)s);
            LPGParser.ASTNode parent = (LPGParser.ASTNode)node.getParent();
            LPGParser.ASTNode grandParent = (LPGParser.ASTNode)parent.getParent();
            if (grandParent instanceof LPGParser.option) {
                LPGParser.option opt = (LPGParser.option)grandParent;
                String optName = opt.getSYMBOL().toString();
                if (optName.equals("import_terminals") || optName.equals("template") || optName.equals("filter")) {
                    return ASTUtils.lookupImportedFile(parseController.getProject(), parseController.getPath(), id);
                }
            } else if (parent instanceof LPGParser.IncludeSeg) {
                LPGParser.IncludeSeg iseg = (LPGParser.IncludeSeg)parent;
                String includeFile = iseg.getinclude_segment().getSYMBOL().toString();
                return ASTUtils.lookupImportedFile(parseController.getProject(), parseController.getPath(), includeFile);
            }
        }
        return decl;
    }

    public static ICompilationUnit lookupImportedFile(ISourceProject srcProject, IPath refFile, String fileName) {
        IPath refPath = refFile.removeLastSegments(1);
        IProject project = srcProject.getRawProject();
        if (project.getFile(refPath.append(fileName)).exists()) {
            return ModelFactory.open((IPath)refPath.append(fileName), (ISourceProject)srcProject);
        }
        if (project.getFile(fileName).exists()) {
            return ModelFactory.open((IPath)new Path(fileName), (ISourceProject)srcProject);
        }
        List buildPath = srcProject.getBuildPath();
        for (IPathEntry entry : buildPath) {
            IPath candidatePath = project.getLocation().append(entry.getPath()).append(fileName);
            if (!project.getFile(candidatePath).exists()) continue;
            return ModelFactory.open((IPath)candidatePath, (ISourceProject)srcProject);
        }
        PreferencesService prefService = new PreferencesService(project, LPGRuntimePlugin.getInstance().getLanguageID());
        String includeSearchPath = prefService.getStringPreference("IncludePathToUse");
        String[] includeDirs = includeSearchPath.split(";");
        for (int i = 0; i < includeDirs.length; ++i) {
            Path includeDirPath = new Path(includeDirs[i]);
            IPath includeFile = includeDirPath.append(fileName);
            if (!new File(includeFile.toOSString()).exists()) continue;
            return ModelFactory.open((IPath)includeFile, (ISourceProject)srcProject);
        }
        return null;
    }

    public static ICompilationUnit lookupSourceFile(ISourceProject project, IPath refLocation, String filePath) {
        ICompilationUnit icu = ModelFactory.open((IFile)project.getRawProject().getFile(refLocation.removeFirstSegments(1).removeLastSegments(1).append(filePath)), (ISourceProject)project);
        if (icu == null) {
            icu = ModelFactory.open((IPath)new Path(filePath), (ISourceProject)project);
        }
        return icu;
    }

    public static Object findAndParseSourceFile(ISourceProject project, IPath refLocation, String fileName, IProgressMonitor monitor) {
        ICompilationUnit unit = ASTUtils.lookupSourceFile(project, refLocation, fileName);
        if (unit != null) {
            return unit.getAST(null, monitor);
        }
        return null;
    }

    public static List<LPGParser.ASTNode> findRefsOf(LPGParser.nonTerm nonTerm2) {
        final ArrayList<LPGParser.ASTNode> result = new ArrayList<LPGParser.ASTNode>();
        LPGParser.LPG root = ASTUtils.getRoot(nonTerm2);
        List<LPGParser.nonTerm> nonTerms = ASTUtils.getNonTerminals(root);
        for (int i = 0; i < nonTerms.size(); ++i) {
            LPGParser.nonTerm nt = nonTerms.get(i);
            final String nonTermName = nonTerm2.getruleNameWithAttributes().getSYMBOL().toString();
            nt.accept(new LPGParser.AbstractVisitor(){

                public void unimplementedVisitor(String s) {
                }

                public boolean visit(LPGParser.symWithAttrs1 n) {
                    if (n.getSYMBOL().toString().equals(nonTermName)) {
                        result.add(n);
                    }
                    return super.visit(n);
                }
            });
        }
        return result;
    }

    public static List<LPGParser.ASTNode> findRefsOf(LPGParser.terminal term) {
        final ArrayList<LPGParser.ASTNode> result = new ArrayList<LPGParser.ASTNode>();
        LPGParser.LPG root = ASTUtils.getRoot(term);
        List<LPGParser.nonTerm> nonTerms = ASTUtils.getNonTerminals(root);
        for (int i = 0; i < nonTerms.size(); ++i) {
            LPGParser.nonTerm nt = nonTerms.get(i);
            final String symbolName = term.toString();
            nt.accept(new LPGParser.AbstractVisitor(){

                public void unimplementedVisitor(String s) {
                }

                public boolean visit(LPGParser.symWithAttrs1 n) {
                    if (n.getSYMBOL().toString().equals(symbolName)) {
                        result.add(n);
                    }
                    return super.visit(n);
                }
            });
        }
        return result;
    }
}

