/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.editor.ModelTreeContentProvider;
import org.eclipse.imp.editor.OutlineContentProviderBase;
import org.eclipse.imp.editor.OutlineLabelProvider;
import org.eclipse.imp.editor.ProblemsLabelDecorator;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.editor.internal.AbstractInformationControl;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OutlineInformationControl
extends AbstractInformationControl {
    private KeyAdapter fKeyAdapter;
    private OutlineContentProviderBase fOutlineContentProvider;
    private Object fInput = null;
    private OutlineSorter fOutlineSorter;
    private OutlineLabelProvider fInnerLabelProvider;
    protected Color fForegroundColor;
    private LexicalSortingAction fLexicalSortingAction;
    Map fTypeHierarchies = new HashMap();
    private Language fLanguage;
    private ILabelProvider fLangLabelProvider;
    private OutlineLabelProvider.IElementImageProvider fElemImageProvider;
    private final boolean fShowStorage = false;
    protected static final Object[] NO_CHILDREN = new Object[0];

    public OutlineInformationControl(Shell parent, int shellStyle, int treeStyle, String commandId, Language language) {
        super(parent, shellStyle, treeStyle, commandId, true);
        this.fLanguage = language;
    }

    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText(parent);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        OutlineTreeViewer treeViewer = new OutlineTreeViewer(tree);
        this.fLexicalSortingAction = new LexicalSortingAction(treeViewer);
        this.fForegroundColor = parent.getDisplay().getSystemColor(16);
        this.fLanguage = ((UniversalEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).fLanguage;
        this.fOutlineContentProvider = new ModelTreeContentProvider(null);
        this.fOutlineContentProvider.setInfoControl(this);
        this.fLangLabelProvider = ServiceFactory.getInstance().getLabelProvider(this.fLanguage);
        this.fElemImageProvider = ServiceFactory.getInstance().getElementImageProvider(this.fLanguage);
        this.fInnerLabelProvider = new OutlineLabelProvider(this.fLangLabelProvider, this.fElemImageProvider, this.fOutlineContentProvider.fShowInheritedMembers, false, this.fForegroundColor);
        this.fInnerLabelProvider.addLabelDecorator(new ProblemsLabelDecorator());
        treeViewer.setLabelProvider((IBaseLabelProvider)this.fInnerLabelProvider);
        treeViewer.addFilter(new AbstractInformationControl.NamePatternFilter(this));
        treeViewer.setContentProvider((IContentProvider)this.fOutlineContentProvider);
        this.fOutlineSorter = new OutlineSorter();
        treeViewer.setSorter(this.fOutlineSorter);
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return treeViewer;
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public Object getSelectedElement() {
        return super.getSelectedElement();
    }

    protected String getStatusFieldText() {
        if (this.fOutlineContentProvider.isShowingInheritedMembers()) {
            return "Press Ctrl+O to hide inherited members";
        }
        return "Press Ctrl+O to show inherited members";
    }

    protected String getId() {
        return "org.eclipse.imp.QuickOutline";
    }

    public void setInput(Object information) {
        if (information == null || information instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        this.fInput = information;
        this.inputChanged(this.fInput, information);
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    KeyStroke[] strokes = keySequence.getKeyStrokes();
                    for (int i = 0; i < strokes.length; ++i) {
                        if ((strokes[i].getModifierKeys() & 0x40000) == 0 || strokes[i].getNaturalKey() != 79) continue;
                        e.doit = false;
                        OutlineInformationControl.this.toggleShowInheritedMembers();
                        return;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    protected void handleStatusFieldClicked() {
        this.toggleShowInheritedMembers();
    }

    protected void toggleShowInheritedMembers() {
        this.fOutlineContentProvider.toggleShowInheritedMembers();
        this.updateStatusFieldText();
    }

    protected void fillViewMenu(IMenuManager viewMenu) {
        super.fillViewMenu(viewMenu);
        viewMenu.add((IContributionItem)new Separator("Sorters"));
        if (this.fLexicalSortingAction != null) {
            viewMenu.add((IAction)this.fLexicalSortingAction);
        }
    }

    private IProgressMonitor getProgressMonitor() {
        IWorkbenchPage wbPage = RuntimePlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (wbPage == null) {
            return null;
        }
        IEditorPart editor = wbPage.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    private class LexicalSortingAction
    extends Action {
        private static final String STORE_LEXICAL_SORTING_CHECKED = "LexicalSortingAction.isChecked";
        private TreeViewer fOutlineViewer;

        private LexicalSortingAction(TreeViewer outlineViewer) {
            super("Sort", 2);
            this.setToolTipText("Sort by name");
            this.setDescription("Sort entries lexically by name");
            RuntimePlugin.getImageDescriptor("alphab_sort_co.gif");
            this.fOutlineViewer = outlineViewer;
            boolean checked = OutlineInformationControl.this.getDialogSettings().getBoolean(STORE_LEXICAL_SORTING_CHECKED);
            this.setChecked(checked);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    LexicalSortingAction.this.fOutlineViewer.refresh(false);
                }
            });
            if (store) {
                OutlineInformationControl.this.getDialogSettings().put(STORE_LEXICAL_SORTING_CHECKED, on);
            }
        }
    }

    private class OutlineSorter
    extends ViewerSorter {
        private static final int OTHER = 1;

        private OutlineSorter() {
        }

        public void sort(Viewer viewer, Object[] elements) {
            if (!OutlineInformationControl.this.fLexicalSortingAction.isChecked()) {
                return;
            }
            super.sort(viewer, elements);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            String label1 = OutlineInformationControl.this.fLangLabelProvider.getText(e1);
            String label2 = OutlineInformationControl.this.fLangLabelProvider.getText(e2);
            return label1.compareTo(label2);
        }

        public int category(Object element) {
            return 1;
        }
    }

    private class OutlineTreeViewer
    extends TreeViewer {
        private boolean fIsFiltering;

        private OutlineTreeViewer(Tree tree) {
            super(tree);
            this.fIsFiltering = false;
        }

        protected Object[] getFilteredChildren(Object parent) {
            Object[] result = this.getRawChildren(parent);
            int unfilteredChildren = result.length;
            ViewerFilter[] filters = this.getFilters();
            if (filters != null) {
                for (int i = 0; i < filters.length; ++i) {
                    result = filters[i].filter((Viewer)this, parent, result);
                }
            }
            this.fIsFiltering = unfilteredChildren != result.length;
            return result;
        }

        protected void internalExpandToLevel(Widget node, int level) {
            if (this.fIsFiltering || node instanceof Item) {
                // empty if block
            }
            super.internalExpandToLevel(node, level);
        }
    }
}

